// calendar.js - Kalendara inicializacija un notikumu parvaldiba

document.addEventListener('DOMContentLoaded', function() {
    let calendarEl = document.getElementById('calendar');
    let calendar = new FullCalendar.Calendar(calendarEl, {
        initialView: 'dayGridMonth',
        headerToolbar: {
            left: 'prev,next today',
            center: 'title',
            right: 'dayGridMonth,timeGridWeek,timeGridDay,listYear'
        },
        locale: 'lv', // Kalendars latvieu valoda
        dateClick: function(info) {
            openModal(info.dateStr); // Atver modali notikuma pievienoanai
        },
        events: {
            url: '../php/fetch_events.php',
            failure: function() {
                alert('Notikumu ielade neizdevas');
            }
        }
    });
    calendar.render();
});

// Atver modali, lai pievienotu jaunu notikumu
function openModal(date) {
    document.getElementById('eventModal').style.display = 'block';
    document.getElementById('eventDate').value = date;
}

// Aizver modali
function closeModal() {
    document.getElementById('eventModal').style.display = 'none';
}
