-- --------------------------------------------------------
-- Host:                         127.0.0.1
-- Server version:               10.4.32-MariaDB - mariadb.org binary distribution
-- Server OS:                    Win64
-- HeidiSQL Version:             12.8.0.6908
-- --------------------------------------------------------

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET NAMES utf8 */;
/*!50503 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;


-- Dumping database structure for lietvedibas_programma
CREATE DATABASE IF NOT EXISTS `lietvedibas_programma` /*!40100 DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci */;
USE `lietvedibas_programma`;

-- Dumping structure for table lietvedibas_programma.adreses
CREATE TABLE IF NOT EXISTS `adreses` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `adrese` varchar(50) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=27 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci COMMENT='Adrešu saraksts';

-- Dumping data for table lietvedibas_programma.adreses: ~23 rows (approximately)
INSERT INTO `adreses` (`id`, `adrese`) VALUES
	(1, 'Lielā iela 40, Jelgava'),
	(2, 'Elizabetes iela 132, Rīga'),
	(3, 'Kalnu iela 13, Liepāja'),
	(4, '12345'),
	(5, '126'),
	(6, '712'),
	(7, 'ga'),
	(8, 'asf'),
	(9, 'zxc'),
	(10, '1512'),
	(11, '123123'),
	(12, 'asdads'),
	(13, '123213'),
	(14, 'dasd'),
	(15, 'asd'),
	(16, 'asdasdasdsa'),
	(17, 'asdas'),
	(18, 'asdasqweewq'),
	(19, 'dasdasdasdsad'),
	(20, 'test'),
	(21, 'test2'),
	(22, 'ggg'),
	(23, 'ads'),
	(24, '1265712'),
	(25, 'asdasd 1123'),
	(26, 'TESTS');

-- Dumping structure for table lietvedibas_programma.apmaksa
CREATE TABLE IF NOT EXISTS `apmaksa` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `rekins_id` int(11) NOT NULL,
  `nosaukums` varchar(50) NOT NULL,
  `mervieniba_id` int(11) NOT NULL DEFAULT 0,
  `daudzums` decimal(20,2) NOT NULL,
  `cena` decimal(20,2) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `FK_apmaksa_dokumenti_rekins` (`rekins_id`),
  KEY `FK_apmaksa_mervienibas` (`mervieniba_id`),
  CONSTRAINT `FK_apmaksa_dokumenti_rekins` FOREIGN KEY (`rekins_id`) REFERENCES `dokumenti_rekins` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `FK_apmaksa_mervienibas` FOREIGN KEY (`mervieniba_id`) REFERENCES `mervienibas` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB AUTO_INCREMENT=136 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci COMMENT='Rēķinu apmaksas informācija';

-- Dumping data for table lietvedibas_programma.apmaksa: ~9 rows (approximately)
INSERT INTO `apmaksa` (`id`, `rekins_id`, `nosaukums`, `mervieniba_id`, `daudzums`, `cena`) VALUES
	(1, 1, 'Egle', 2, 20.30, 10.00),
	(2, 1, 'Priede', 2, 20.30, 12.77),
	(3, 1, 'Osis', 2, 43.20, 55.22),
	(4, 2, 'Egle', 2, 33.00, 45.00),
	(5, 2, 'Priede', 2, 51.00, 23.00),
	(6, 2, 'Osis', 2, 42.00, 32.00),
	(13, 3, 'Egle', 2, 51.00, 23.00),
	(14, 3, 'Osis', 2, 13.00, 51.00),
	(17, 3, 'Priede', 2, 51.00, 12.00),
	(132, 104, 'Strada1', 3, 11.00, 22.00),
	(133, 104, 'Strada2', 3, 33.00, 44.00),
	(134, 105, 'Strada3', 3, 55.00, 66.00),
	(135, 105, 'Strada4', 3, 77.00, 88.00);

-- Dumping structure for table lietvedibas_programma.bankas
CREATE TABLE IF NOT EXISTS `bankas` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `banka` varchar(50) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci COMMENT='Banku saraksts';

-- Dumping data for table lietvedibas_programma.bankas: ~9 rows (approximately)
INSERT INTO `bankas` (`id`, `banka`) VALUES
	(1, 'Swedbank'),
	(2, 'Luminor'),
	(3, 'SEB'),
	(4, '12345'),
	(5, ''),
	(6, '1231'),
	(7, '123'),
	(8, 'asd'),
	(9, 'qweqewqew'),
	(10, '3');

-- Dumping structure for table lietvedibas_programma.darbinieki
CREATE TABLE IF NOT EXISTS `darbinieki` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `lietotajvards` varchar(50) NOT NULL,
  `parole` varchar(50) NOT NULL,
  `tokens` varchar(64) DEFAULT NULL,
  `tokens_termins` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci COMMENT='Darbinieku saraksts';

-- Dumping data for table lietvedibas_programma.darbinieki: ~2 rows (approximately)
INSERT INTO `darbinieki` (`id`, `lietotajvards`, `parole`, `tokens`, `tokens_termins`) VALUES
	(1, 'RobertsSaulitis', 'R0b3rt5', NULL, NULL),
	(2, 'admin', 'admin', 'f526d2b9b4db80ee08de5707bf0dd24bbec214d00d7b7caa6b1f5ac21ea57af2', '2024-12-04 17:47:19');

-- Dumping structure for table lietvedibas_programma.dokumenti_rekins
CREATE TABLE IF NOT EXISTS `dokumenti_rekins` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `klients_id` int(11) NOT NULL,
  `rekins_nr` varchar(50) NOT NULL,
  `izr_datums` date NOT NULL,
  `apm_datums` date NOT NULL,
  `pvn` decimal(20,6) NOT NULL,
  `piezimes` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `FK_dokumenti_rekins_klienti` (`klients_id`),
  CONSTRAINT `FK_dokumenti_rekins_klienti` FOREIGN KEY (`klients_id`) REFERENCES `klienti` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB AUTO_INCREMENT=106 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci COMMENT='Rēķinu saraksts';

-- Dumping data for table lietvedibas_programma.dokumenti_rekins: ~3 rows (approximately)
INSERT INTO `dokumenti_rekins` (`id`, `klients_id`, `rekins_nr`, `izr_datums`, `apm_datums`, `pvn`, `piezimes`) VALUES
	(1, 1, '001', '2024-10-13', '2024-10-15', 21.000000, ''),
	(2, 3, '002', '2024-10-11', '2024-10-16', 11.000000, NULL),
	(3, 2, '003', '2024-10-12', '2024-10-14', 0.000000, NULL),
	(104, 30, '004', '2024-12-01', '2025-03-11', 21.000000, 'fffff'),
	(105, 30, '005', '2024-12-01', '2024-12-11', 21.000000, 'fffff');

-- Dumping structure for table lietvedibas_programma.klienti
CREATE TABLE IF NOT EXISTS `klienti` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `nosaukums` varchar(50) NOT NULL,
  `reg_nr` varchar(50) NOT NULL,
  `pvn_reg_nr` varchar(50) NOT NULL,
  `adrese_id` int(11) NOT NULL,
  `banka_id` int(11) NOT NULL,
  `banka_kods` varchar(50) DEFAULT NULL,
  `banka_nr` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `FK_klienti_adreses` (`adrese_id`),
  KEY `FK_klienti_bankas` (`banka_id`),
  CONSTRAINT `FK_klienti_adreses` FOREIGN KEY (`adrese_id`) REFERENCES `adreses` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `FK_klienti_bankas` FOREIGN KEY (`banka_id`) REFERENCES `bankas` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB AUTO_INCREMENT=31 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci COMMENT='Klientu saraksts';

-- Dumping data for table lietvedibas_programma.klienti: ~4 rows (approximately)
INSERT INTO `klienti` (`id`, `nosaukums`, `reg_nr`, `pvn_reg_nr`, `adrese_id`, `banka_id`, `banka_kods`, `banka_nr`) VALUES
	(1, 'WoodTrade SIA', '9000', '9001', 1, 1, '222', '333'),
	(2, 'TradeShipping SIA', '12354', '5151', 2, 3, '512', '661'),
	(3, 'LogShip SIA', '6654', '53723', 3, 2, '813', '98992'),
	(30, 'TESTS', '12312312', 'TESTS', 26, 5, '12412', '');

-- Dumping structure for table lietvedibas_programma.mervienibas
CREATE TABLE IF NOT EXISTS `mervienibas` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `mervieniba` varchar(50) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci COMMENT='Mērvienību saraksts';

-- Dumping data for table lietvedibas_programma.mervienibas: ~3 rows (approximately)
INSERT INTO `mervienibas` (`id`, `mervieniba`) VALUES
	(1, 'gab.'),
	(2, '		m3'),
	(3, 'km');

/*!40103 SET TIME_ZONE=IFNULL(@OLD_TIME_ZONE, 'system') */;
/*!40101 SET SQL_MODE=IFNULL(@OLD_SQL_MODE, '') */;
/*!40014 SET FOREIGN_KEY_CHECKS=IFNULL(@OLD_FOREIGN_KEY_CHECKS, 1) */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40111 SET SQL_NOTES=IFNULL(@OLD_SQL_NOTES, 1) */;
