<?php
require 'savienojums.php';  //Pievieno datubāzes savienojumu no savienojums.php faila

if ($_SERVER['REQUEST_METHOD'] == 'POST') { //Ja servera metode ir POST, atjaunina klienta datus datubāzē
    $klientaId = $_POST['klientaId'];
    $klientaNosauk = $_POST['klientaNosauk'];
    $regNum = $_POST['regNum'];
    $pvnNum = $_POST['pvnNum'];
    $adrese = $_POST['adrese'];
    $bankasNosauk = $_POST['bankasNosauk'];
    $bankasKods = $_POST['bankasKods'];
    $bankasNum = $_POST['bankasNum'];

    if (empty($klientaNosauk) || empty($regNum) || empty($adrese) || empty($pvnNum)) {    //Pārbauda, vai visi obligātie lauki ir aizpildīti
        echo json_encode(['status' => 'kļūda', 'ziņa' => 'Jāaizpilda obligātie lauki!']);   //Paziņojums, ka visi obligātie lauki nav aizpildīti
        exit;
    }

    $stmt = $savienojums->prepare("SELECT id FROM adreses WHERE adrese = ?");   //Pārbauda, vai tāda adrese jau ir datubāzē
    $stmt->bind_param('s', $adrese);
    $stmt->execute();
    $stmt->bind_result($adresesId);
    
    if (!$stmt->fetch()) {  //Ja adrese nav datubāzē, tad izveido jaunu
        $stmt->close();
        $stmt = $savienojums->prepare("INSERT INTO adreses (adrese) VALUES (?)");   //Ievieto jauno adresi datubāzē un pievieno klientam noteikto adreses identifikatoru
        $stmt->bind_param('s', $adrese);
        $stmt->execute();
        $adresesId = $savienojums->insert_id;
    }
    $stmt->close();

    $stmt = $savienojums->prepare("SELECT id FROM bankas WHERE banka = ?"); //Pārbauda, vai tāda banka jau ir datubāzē
    $stmt->bind_param('s', $bankasNosauk);
    $stmt->execute();
    $stmt->bind_result($bankasId);
    
    if (!$stmt->fetch()) {  //Ja banka nav datubāzē, tad izveido jaunu
        $stmt->close();
        $stmt = $savienojums->prepare("INSERT INTO bankas (banka) VALUES (?)"); //Ievieto jauno adresi datubāzē un pievieno klientam noteikto bankas ID
        $stmt->bind_param('s', $bankasNosauk);
        $stmt->execute();
        $bankasId = $savienojums->insert_id;
    }
    $stmt->close();

    //Atjaunina klienta datus
    $stmt = $savienojums->prepare("UPDATE klienti SET nosaukums = ?, reg_nr = ?, pvn_reg_nr = ?, adrese_id = ?, banka_id = ?, banka_kods = ?, banka_nr = ? WHERE id = ?");
    $stmt->bind_param('sssssssi', $klientaNosauk, $regNum, $pvnNum, $adresesId, $bankasId, $bankasKods, $bankasNum, $klientaId);

    if ($stmt->execute()) { //Pārbauda vai izdevies ievietot datus un paziņo par to
        echo json_encode(['status' => 'izdevies']);
    } else {    //Paziņo, ka nevarēja izmainīt  datus
        echo json_encode(['status' => 'kļūda', 'ziņa' => 'Nevarēja izmainīt klienta datus!']);
    }

    $stmt->close();
} else if ($_SERVER['REQUEST_METHOD'] == 'GET') {   //Ja servera metode ir GET, tad ievāc informāciju par klientu ar nosūtīto identifikatoru
    if (isset($_GET['id'])) {   //Ja identifikators ir saņemts, tad pieprasa dokumentu un klientu datus no datubāzes
        $klientaId = $_GET['id'];
        $pieprasijums = "
            SELECT 
                k.id, 
                k.nosaukums, 
                k.reg_nr, 
                k.pvn_reg_nr, 
                a.adrese AS adrese, 
                b.banka AS bankName, 
                k.banka_kods AS bankCode, 
                k.banka_nr AS bankAccount
            FROM 
                klienti k
            LEFT JOIN 
                adreses a ON k.adrese_id = a.id
            LEFT JOIN 
                bankas b ON k.banka_id = b.id
            WHERE 
                k.id = ?
        ";

        if ($stmt = $savienojums->prepare($pieprasijums)) { //Pieprasījums, kas ņem informāciju par noteikto klientu
            $stmt->bind_param('i', $klientaId);
            $stmt->execute();
            $stmt->bind_result($id, $klientaNosauk, $regNum, $pvnNum, $adrese, $bankasNosauk, $bankasKods, $bankasNum);
            
            if ($stmt->fetch()) {   //Ja klients ir datubāzē, tad nosūta klienta datus
                echo json_encode([   //Nosūta klienta datus lietotājam rediģēšanai
                    'status' => 'success',
                    'data' => [
                        'id' => $id,
                        'klientaNosauk' => $klientaNosauk,
                        'regNum' => $regNum,
                        'pvnNum' => $pvnNum,
                        'adrese' => $adrese,
                        'bankasNosauk' => $bankasNosauk,
                        'bankasKods' => $bankasKods,
                        'bankasNum' => $bankasNum
                    ]
                ]);
            } else {    //Ja klients nav datubāzē, tad paziņo par to
                echo json_encode(['status' => 'kļūda', 'ziņa' => 'Klients nav atrasts!']);
            }

            $stmt->close();
        } else {    //Ja pieprasījums nav izdevies, tad paziņo par to
            echo json_encode(['status' => 'kļūda', 'ziņa' => 'Pieprasījums nav izdevies!']);
        }
    } else {    //Ja identifikators nav saņemts, tad paziņo par to
        echo json_encode(['status' => 'kļūda', 'ziņa' => 'Nepieciešams klienta ID!']);
    }
}
$savienojums->close();  //Aizver savienojumu
?>
