<?php
session_start();    //Uzsāk sesiju
require 'savienojums.php';  //Pievieno datubāzes savienojumu no savienojums.php faila

header('Content-Type: application/json');   //Datu tips - JSON

if ($_SERVER['REQUEST_METHOD'] === 'POST') {    //Ja servera metode ir POST, tad ievieto dokumentu datubāzā
    $rekins_id = $_POST['rekins_id'];
    $klients_id = $_POST['klients_id'];
    $rekins_nr = $_POST['rekins_nr'];
    $izr_datums = $_POST['izr_datums'];
    $apm_datums = $_POST['apm_datums'];
    $pvn = $_POST['pvn'];
    $piezimes = $_POST['piezimes'];

    //SQL pieprasījums, kas atjaunina dokumenta datus
    $stmt = $savienojums->prepare("UPDATE dokumenti_rekins SET klients_id = ?, rekins_nr = ?, izr_datums = ?, apm_datums = ?, pvn = ?, piezimes = ? WHERE id = ?");
    $stmt->bind_param("sissdsi", $klients_id, $rekins_nr, $izr_datums, $apm_datums, $pvn, $piezimes, $rekins_id);
    $stmt->execute();

    //SQL pieprasījums, kas dzēš esošās apmaksas no dokumenta
    $tableData = $_POST['tableData'];
    $stmt = $savienojums->prepare("DELETE FROM apmaksa WHERE rekins_id = ?");
    $stmt->bind_param("i", $rekins_id);
    $stmt->execute();

    foreach ($tableData as $row) {  //Dokumenta apmaksas datu rindu ievietošana masīvā
        $stmt = $savienojums->prepare("INSERT INTO apmaksa (rekins_id, nosaukums, mervieniba_id, daudzums, cena) VALUES (?, ?, ?, ?, ?)");
        $stmt->bind_param("isiss", $rekins_id, $row['nosaukums'], $row['mervieniba_id'], $row['daudzums'], $row['cena']);
        $stmt->execute();
    }

    echo json_encode(['success' => 'Dokuments atjaunots!', 'status' => 'success']);    //Paziņojums par dokumenta veiksmīgu atjaunšanu
    exit;
} elseif ($_SERVER['REQUEST_METHOD'] === 'GET') {    //Ja servera metode ir GET, tad ievāc dokumentu datus
    $rekins_id = $_GET['rekins_id'];

    //SQL pieprasījums, kas ievāc dokumenta datus
    $stmt = $savienojums->prepare("SELECT * FROM dokumenti_rekins WHERE id = ?");
    $stmt->bind_param("i", $rekins_id);
    $stmt->execute();
    $rezultats = $stmt->get_result();
    $rinda = $rezultats->fetch_assoc();

    //SQL pieprasījums, kas ievāc dokumenta apmaksas informāciju
    $stmt = $savienojums->prepare("SELECT * FROM apmaksa WHERE rekins_id = ?");
    $stmt->bind_param("i", $rekins_id);
    $stmt->execute();
    $rezultats = $stmt->get_result();
    $apmaksa = array();

    while ($rinda2 = $rezultats->fetch_assoc()) {   //Katru apmaksu saglabā masīvā
        $apmaksa[] = $rinda2;
    }

    $data = array(  //Dokumenta informācija
        'status' => 'success',
        'klients_id' => $rinda['klients_id'],
        'rekins_nr' => $rinda['rekins_nr'],
        'izr_datums' => $rinda['izr_datums'],
        'apm_datums' => $rinda['apm_datums'],
        'pvn' => $rinda['pvn'],
        'piezimes' => $rinda['piezimes'],
        'apmaksa' => $apmaksa
    );

    echo json_encode($data);    //Nosūta dokumenta informāciju apstrādei
    exit;
}

?>