<?php
require 'savienojums.php';  //Pievieno datubāzes savienojumu no savienojums.php faila

if ($_SERVER['REQUEST_METHOD'] == 'POST') { //Ja servera metode ir POST, tad ievieto nosūtītos datus mainīgajos
    $klientaNosauk = $_POST['klientaNosauk'];
    $regNum = $_POST['regNum'];
    $pvnNum = $_POST['pvnNum'];
    $adrese = $_POST['adrese'];
    $bankasNosauk = $_POST['bankasNosauk'];
    $bankasKods = $_POST['bankasKods'];
    $bankasNum = $_POST['bankasNum'];
    
    $stmt = $savienojums->prepare("SELECT id FROM bankas WHERE banka = ?"); //Pieprasījums, kas saņem bankas identifikatoru pēc bankas nosaukuma
    $stmt->bind_param('s', $bankasNosauk);
    $stmt->execute();
    $resultats = $stmt->get_result();

    if ($resultats->num_rows > 0) { //Ja banka ir datubāzē, tad pievieno noteiktajam klientam bankas identifikatoru
        $rinda = $resultats->fetch_assoc();
        $bankasId = $rinda['id'];
    } else {    //Ievieto kā jaunu banku, un pievieno noteiktajam klientam bankas identifikatoru
        $stmt = $savienojums->prepare("INSERT INTO bankas (banka) VALUES (?)"); 
        $stmt->bind_param('s', $bankasNosauk);
        $stmt->execute();
        $bankasId = $stmt->insert_id;
    }

    $stmt = $savienojums->prepare("SELECT id FROM adreses WHERE adrese = ?");   //Pieprasījums, kas saņem identifikatoru pēc noteiktas adreses
    $stmt->bind_param('s', $adrese);
    $stmt->execute();
    $resultats = $stmt->get_result();

    if ($resultats->num_rows > 0) { //Ja adrese ir datubāzē, tad pievieno noteiktajam klientam adreses identifikatoru
        $rinda = $resultats->fetch_assoc();
        $adresesId = $rinda['id'];
    } else {    //Ievieto kā jaunu adresi, un pievieno noteiktajam klientam adreses identifikatoru
        $stmt = $savienojums->prepare("INSERT INTO adreses (adrese) VALUES (?)");   
        $stmt->bind_param('s', $adrese);
        $stmt->execute();
        $adresesId = $stmt->insert_id;
    }

    //Ievieto visus lietotāja ievadītos klienta datus datubāzē
    $stmt = $savienojums->prepare("INSERT INTO klienti (nosaukums, reg_nr, pvn_reg_nr, adrese_id, banka_id, banka_kods, banka_nr) VALUES (?, ?, ?, ?, ?, ?, ?)");   
    $stmt->bind_param('sssiiis', $klientaNosauk, $regNum, $pvnNum, $adresesId, $bankasId, $bankasKods, $bankasNum);

    if ($stmt->execute()) { //Paziņojums par veiksmīgu pievienošanu
        echo json_encode(['status' => 'izdevies', 'ziņa' => 'Klients pievienots veiksmīgi.']);
    } else {    //Paziņojums par neizdevušos pievienošanu
        echo json_encode(['status' => 'kļūda', 'ziņa' => 'Neizdevās pievienot klientu.']);
    }
}
