<?php
session_start();    //Uzsāk sesiju
require 'savienojums.php';  //Pievieno datubāzes savienojumu no savienojums.php faila

header('Content-Type: application/json');   //Datu tips - JSON

if ($_SERVER['REQUEST_METHOD'] === 'POST') {    //Ja servera metode ir POST, tad ievieto dokumentu datubāzē
    $klients_id = $_POST['klients_id'];
    $rekins_nr = $_POST['rekins_nr'];
    $izr_datums = $_POST['izr_datums'];
    $apm_datums = $_POST['apm_datums'];
    $pvn = $_POST['pvn'];
    $piezimes = $_POST['piezimes'];

    $stmt = $savienojums->prepare("INSERT INTO dokumenti_rekins (rekins_nr, klients_id, izr_datums, apm_datums, pvn, piezimes) VALUES (?, ?, ?, ?, ?, ?)");
    $stmt->bind_param("sissds", $rekins_nr, $klients_id, $izr_datums, $apm_datums, $pvn, $piezimes);
    $stmt->execute();

    //SQL pieprasījums, kas ievāc dokumenta identifikatoru
    $tableData = $_POST['tableData'];
    $stmt = $savienojums->prepare("SELECT id FROM dokumenti_rekins WHERE rekins_nr = ? LIMIT 1");
    $stmt->bind_param("s", $rekins_nr);
    $stmt->execute();
    $rezultats = $stmt->get_result();
    $rinda = $rezultats->fetch_assoc();
    $rekins_id = $rinda['id'];

    foreach ($tableData as $row) {  //Dokumenta apmaksas datu rindu ievietošana masīvā
        $stmt = $savienojums->prepare("INSERT INTO apmaksa (rekins_id, nosaukums, mervieniba_id, daudzums, cena) VALUES (?, ?, ?, ?, ?)");
        $stmt->bind_param("isiss", $rekins_id, $row['nosaukums'], $row['mervieniba_id'], $row['daudzums'], $row['cena']);
        $stmt->execute();
    }

    echo json_encode(['success' => 'Dokuments pievienots!', 'status' => 'success']);    //Paziņojums par dokumenta veiksmīgu pievienošanu
    exit;
}

?>