<?php
session_start();    //Uzsāk sesiju
require 'savienojums.php';  //Pievieno datubāzes savienojumu no savienojums.php faila

if ($_SERVER["REQUEST_METHOD"] == "POST") { //Ja servera metode ir POST, tad programma salīdzina vai lietotāja ievadītie dati atbilst kādam no darbiniekiem
    $lietotajs = $_POST['lietotajvards'];
    $parole = $_POST['parole'];

    $stmt = $savienojums->prepare("SELECT * FROM darbinieki WHERE lietotajvards = ? LIMIT 1");  //Pieprasījums, kas pārbauda vai darbinieks eksistē
    $stmt->bind_param("s", $lietotajs);
    $stmt->execute();
    $resultats = $stmt->get_result();

    if ($resultats->num_rows === 1) {   //Ja darbinieks eksistē, tad ļauj programmai turpināt pārbaudi, bet ja nē, tad izmet paziņojumu
        $rinda = $resultats->fetch_assoc();

        if ($rinda['parole'] === $parole) { //Ja parole sakrīt, tad piešķir lietotājam atļauju tikt pie datiem
            $tokens = bin2hex(random_bytes(32));
            $termins = date('Y-m-d H:i:s', strtotime('+1 hour'));

            //SQL pieprasījums, kas atjaunina darbinieka datus un pievieno token un termiņu
            $update_stmt = $savienojums->prepare("UPDATE darbinieki SET tokens = ?, tokens_termins = ? WHERE lietotajvards = ?");
            $update_stmt->bind_param("sss", $tokens, $termins, $lietotajs);
            $update_stmt->execute();

            $_SESSION['pierakstijies'] = true;
            $_SESSION['lietotajvards'] = $rinda['lietotajvards'];
            $_SESSION['tokens'] = $tokens;

            header("Location: logtradeLietvediba.php"); //Aizvirza lietotāju uz galveno lapu
            exit;
        } else {    //Ja parole neatbilst, tad paziņo to
            echo "<script>alert('Nepareiza parole!'); window.location.href='pieslegsanas_lapa.php';</script>";
        }
    } else {    //Ja darbinieks neeksistē, tad paziņo to
        echo "<script>alert('Lietotājs neeksistē!'); window.location.href='pieslegsanas_lapa.php';</script>";
    }

    $stmt->close();
}

$savienojums->close();  //Aizver savienojumu
?>