<!-- Galvenā lapa -->
<?php
session_start();    //Uzsāk sesiju

//Neļauj izmantot jebkāda veida kešatmiņu
header("Cache-Control: no-store, no-cache, must-revalidate, max-age=0");
header("Cache-Control: post-check=0, pre-check=0", false);
header("Pragma: no-cache"); 

require 'savienojums.php';  //Pievieno datubāzes savienojumu no savienojums.php faila

if (!isset($_SESSION['pierakstijies']) || $_SESSION['pierakstijies'] !== true || !isset($_SESSION['tokens'])) { //Lietotāja piekļuves pārbuade
    header("Location: pieslegsanas_lapa.php");  //Aizvirza lietotāju uz pieslēgšanās lapu, ja lietotājs nav pierakstijies
    exit;
}

//SQL pieprasījums, kas pārbauda vai lietotājs ir pierakstūjies
$lietotajs = $_SESSION['lietotajvards'];
$stmt = $savienojums->prepare("SELECT * FROM darbinieki WHERE lietotajvards = ? AND tokens = ? AND tokens_termins < NOW() LIMIT 1");    
$stmt->bind_param("ss", $lietotajs, $_SESSION['tokens']);
$stmt->execute();
$resultats = $stmt->get_result();

if ($resultats->num_rows !== 1) {   //Aizvirza lietotāju uz pieslēgšanās lapu, ja lietotājam nav piekļuves atļauja
    header("Location: pieslegsanas_lapa.php");
    exit;
};
?>

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <title>Logtrade Services lietvedība</title>
    <!-- Visu nepieciešamo bilbiotēku un failu iekļaušana --> 
    <script src="//localhost/kvalifikacija/JS/funkcijas.js"></script>
    <link rel="stylesheet" href="//localhost/kvalifikacija/CSS/stili.css">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css">
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;600&family=Open+Sans:wght@400;600&display=swap" rel="stylesheet">
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
    <script src="https://code.jquery.com/jquery-3.5.1.min.js"></script>
    <script src="https://unpkg.com/@popperjs/core@2"></script>
    <script src="https://cdn.jsdelivr.net/npm/exceljs/dist/exceljs.min.js"></script>
</head>

<body>
    <header class="container-fluid header-bg">  <!-- Galvene -->
        <div class="row">
            <div class="col text-center">
                <h1><a href="//localhost/kvalifikacija/PHP/atslegties.php">Iziet</a></h1>    <!-- Poga, kas izdzēš lietotāja sesiju un iziet no programmas --> 
            </div>
        </div>
    </header>

    <h1>Rēķinu saraksts</h1>
    <table id="dokumenti" class="table">    <!-- Dokumentu saraksta tabula --> 
        <thead>
            <tr>
                <th>Rēķina numurs</th>
                <th>Datums</th>
                <th>Klients</th>
                <th>Summa</th>
                <th>Darbības</th>
            </tr>
        </thead>
        <tbody></tbody>
    </table>
    <button onclick='window.location.href="//localhost/kvalifikacija/PHP/izveidot_dokumentu.php"' class="btn btn-success"> + Pievienot dokumentu</button>  <!-- Poga, lai pievienotu jaunu dokumentu --> 

    <h1>Klientu saraksts</h1>
    <table id="klienti" class="table">  <!-- Klientu saraksta tabula --> 
        <thead>
            <tr>
                <th>Nosaukums</th>
                <th>Darbības</th>
            </tr>
        </thead>
        <tbody></tbody>
    </table>
    <button onclick="pievienotKlientu()" class="btn btn-primary"> + Pievienot jaunu klientu</button>    <!-- Poga, lai pievienotu jaunu klientu --> 

    <script>
        $(document).ready(function () { //Kad lietotājs ielādē galveno (šo) lapu, tad pieprasa dokumentu un klientu datus no datubāzes
            ievaktDatus();  
        });
    </script>
</body>