<?php
session_start();    // Start session
require 'savienojums.php';  // Include database connection from savienojums.php

header('Content-Type: application/json');    // Data type - JSON

if ($_SERVER['REQUEST_METHOD'] === 'GET') {    // Check if the request method is GET
    // Get document ID from the request (e.g., via query parameter)
    if (isset($_GET['dokuments_id'])) {
        $dokuments_id = $_GET['dokuments_id'];

        // SQL query to get all information about the document
        $query = "
            SELECT 
                d.rekins_nr,
                d.izr_datums,
                d.apm_datums,
                d.pvn,
                d.piezimes,
                k.nosaukums AS klienta_nosaukums,
                k.reg_nr AS klienta_reg_nr,
                k.pvn_reg_nr AS klienta_pvn_reg_nr,
                a.adrese AS klienta_adrese,
                b.banka AS klienta_banka,
                k.banka_kods AS klienta_banka_kods,
                k.banka_nr AS klienta_banka_nr,
                ap.nosaukums AS apmaksas_nosaukums,
                ap.mervieniba_id,
                ap.daudzums,
                ap.cena,
                m.mervieniba AS mervienibas_nosaukums
            FROM dokumenti_rekins d
            LEFT JOIN klienti k ON d.klients_id = k.id
            LEFT JOIN adreses a ON k.adrese_id = a.id
            LEFT JOIN bankas b ON k.banka_id = b.id
            LEFT JOIN apmaksa ap ON d.id = ap.rekins_id
            LEFT JOIN mervienibas m ON ap.mervieniba_id = m.id
            WHERE d.id = ?
        ";

        // Prepare and execute the query
        $stmt = $savienojums->prepare($query);
        $stmt->bind_param("i", $dokuments_id);  // Bind the document ID parameter
        $stmt->execute();
        $rezultats = $stmt->get_result();

        // Fetch the result and return it as an associative array
        if ($rinda = $rezultats->fetch_assoc()) {
            $document_info = [
                'rekins_nr' => $rinda['rekins_nr'],
                'izr_datums' => $rinda['izr_datums'],
                'apm_datums' => $rinda['apm_datums'],
                'pvn' => $rinda['pvn'],
                'piezimes' => $rinda['piezimes'],
                'klients' => [
                    'nosaukums' => $rinda['klienta_nosaukums'],
                    'reg_nr' => $rinda['klienta_reg_nr'],
                    'pvn_reg_nr' => $rinda['klienta_pvn_reg_nr'],
                    'adrese' => $rinda['klienta_adrese'],
                    'banka' => $rinda['klienta_banka'],
                    'banka_kods' => $rinda['klienta_banka_kods'],  // Bank code
                    'banka_nr' => $rinda['klienta_banka_nr']       // Bank account number
                ],
                'apmaksa' => []
            ];

            // Loop through apmaksas (payments) data and add it to the response
            do {
                $document_info['apmaksa'][] = [
                    'nosaukums' => $rinda['apmaksas_nosaukums'],
                    'mervieniba_id' => $rinda['mervieniba_id'],
                    'daudzums' => $rinda['daudzums'],
                    'cena' => $rinda['cena'],
                    'mervienibas_nosaukums' => $rinda['mervienibas_nosaukums']
                ];
            } while ($rinda = $rezultats->fetch_assoc());  // Continue fetching if there are multiple payment rows

            // Return the document information as JSON
            echo json_encode($document_info);
        } else {
            // If no document found, return an error message
            echo json_encode(['error' => 'Dokuments netika atrasts']);
        }

    } else {
        // If no document ID is provided, return an error message
        echo json_encode(['error' => 'Dokuments ID nav nodrošināts']);
    }
}

?>
