<!-- Dokumentu veidošanas lapa -->
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Pievienot Rēķinu</title>
    <!-- Visu nepieciešamo bilbiotēku un failu iekļaušana -->
    <script src="//localhost/kvalifikacija/JS/funkcijas.js"></script>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css">
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;600&family=Open+Sans:wght@400;600&display=swap" rel="stylesheet">
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
    <script src="https://code.jquery.com/jquery-3.5.1.min.js"></script>
    <script src="https://unpkg.com/@popperjs/core@2"></script>
    
</head>
<body class="body1">
    <h1>Izveidot Jaunu Dokumentu</h1>
    <form id="izveidot_rekinu" method="POST">   <!-- Forma lai izveidotu vai rediģētu dokumentu -->
        <label for="klients_id">Klients:</label>
        <select id="klients_id" name="klients_id" required> <!-- Klientu saraksts -->
        </select>
        <br><br>
        <button type="button" onclick="pievienotKlientu()"> + Pievienot jaunu klientu</button>  <!-- Jauna klienta pievienošana -->
        <br><br>

        <label for="rekins_nr">Rēķina nr.:</label>
        <input type="text" id="rekins_nr" name="rekins_nr" readonly required>   <!-- Rēķina numura rādītājs -->
        <br><br>

        <label for="izr_datums">Rēķina izrakstīšanas datums:</label>
        <input type="date" id="izr_datums" name="izr_datums" value="<?php echo date('Y-m-d'); ?>" onchange="this.form.izr_datums.value = this.value;" required> <!-- Izrakstīšanas datums -->
        <br><br>

        <label for="apmaksas_termins">Apmaksas termiņš (dienas):</label>
        <input type="number" id="apm_termins" name="apm_termins" onchange="calcApmDatums()" default="0" > <!-- Apmaksas termiņš -->
        <br><br>

        <label for="apm_datums">Apmaksas datums:</label>
        <input type="date" id="apm_datums" name="apm_datums" value="<?php echo date('Y-m-d'); ?>" onchange="calcApmTermins()" required> <!-- Apmaksas datums -->
        <br><br>

        <label for="pvn">PVN apmērs %:</label>
        <input type="text" id="pvn" name="pvn" oninput="updateSumma('pvn')" required>   <!-- PVN apmērs % -->
        <br><br>

        <table id="apmaksas_tabula">    <!-- Apmaksas tabula -->
            <thead>
                <tr>
                <th>Nosaukums</th>
                <th>Mērvienība</th>
                <th>Daudzums</th>
                <th>Cena</th>
                <th>Summa</th>
                </tr>
            </thead>
            <tbody></tbody> <!-- Tabulas rindas -->
        </table>
        <button type="button" onclick='pievienotRindu("",0,"","","")'> + Pievienot rindu</button>    <!-- Jaunas rindas pievienošana -->
        <br><br>

        <label for="piezimes">Piezīmes:</label>
        <input type="text" id="piezimes" name="piezimes" required>   <!-- Dokumenta piezīmes -->
        <br><br>

        <button type="button" id="izveidotDok" onclick='izveidotDokumentu(rekina_id, veids)'>Saglabāt</button>    <!-- Dokumenta saglabāšanas poga -->
    </form>
    <script>
        var urlParams = new URLSearchParams(window.location.search);
        var rekina_id = urlParams.get('id');
        var veids = urlParams.get('veids'); 
        $(document).ready(function() {  //Kad lietotājs ielādē galveno (šo) lapu, tad pieprasa dokumentu un klientu datus no datubāzes vai pieveno rindu
            if (veids == 'rediget') {   //Ja lietotājs ielādē dokumentu rediget_klientu.php lapu, tad pieprasa dokumentu un klientu datus no datubāzes
                dokDatuRedigesana();
            } else if ( veids == "kopet") {    //Pievieno rindu
                dokDatuKopesana();
            } else {
                jaunsDok();
            }
        });
    </script>
</body>
</html>
