<?php
session_start();    //Uzsāk sesiju
header('Content-Type: application/json');
require 'savienojums.php';  //Pievieno datubāzes savienojumu no savienojums.php faila

if (!isset($_SESSION['pierakstijies']) || $_SESSION['pierakstijies'] !== true || !isset($_SESSION['tokens'])) { //Lietotāja piekļuves pārbuade
    header("Location: pieslegsanas_lapa.php");
    exit;
}

//SQL pieprasījums, kas meklē vai lietotāja ievadītie pieslēgšanās dati atbilst kādam darbiniekam
$lietotajs = $_SESSION['lietotajvards'];
$stmt = $savienojums->prepare("SELECT * FROM darbinieki WHERE lietotajvards = ? AND tokens = ? AND tokens_termins < NOW() LIMIT 1");    
$stmt->bind_param("ss", $lietotajs, $_SESSION['tokens']);
$stmt->execute();
$resultats = $stmt->get_result();

if ($resultats->num_rows !== 1) {   //Novirza atpakaļ uz pieslēgšanās lapu, ja lietotājs neeksistē
    header("Location: pieslegsanas_lapa.php");
    exit;
} else {    //Ja lietotājs eksistē, tad ievāc datus par dokumentiem un klientiem
    //SQL pieprasījums, kas ievāc datus par dokumentiem
    $dokumenti = [];
    $dokumentuPieprasijums = "SELECT d.id, d.rekins_nr, d.apm_datums AS datums, k.nosaukums AS klients, SUM(a.daudzums * a.cena + a.daudzums * a.cena * (d.pvn/100)) AS summa   
        FROM dokumenti_rekins d
        JOIN klienti k ON d.klients_id = k.id   
        JOIN apmaksa a ON a.rekins_id = d.id
        GROUP BY d.id"; //SQL pieprasījums, kas ievāc datus par dokumentiem
    $dokumentuRezultats = $savienojums->query($dokumentuPieprasijums);  

    if ($dokumentuRezultats->num_rows > 0) {    //Ja dokumenti eksistē, tad papildina masīvu ar dokumentu datiem
        while ($rinda = $dokumentuRezultats->fetch_assoc()) {   //Papildina masīvu ar dokumentu datiem
            $dokumenti[] = $rinda;
        }
    }

    //SQL pieprasījums, kas ievāc datus par klientiem
    $klienti = [];
    $klientuPieprasijums = "SELECT id, nosaukums FROM klienti"; //SQL pieprasījums, kas ievāc datus par klientiem
    $klientuRezultats = $savienojums->query($klientuPieprasijums);  

    if ($klientuRezultats->num_rows > 0) {    //Ja klienti eksistē, tad papildina masīvu ar klientu datiem
        while ($rinda = $klientuRezultats->fetch_assoc()) { //Papildina masīvu ar klientu datiem
            $klienti[] = $rinda;
        }
    }

    echo json_encode(['dokumenti' => $dokumenti, 'klienti' => $klienti]);   //Nosūta datus lietotājam
    exit;
}
?>