<?php
require 'savienojums.php';  //Pievieno datubāzes savienojumu no savienojums.php faila

if ($_SERVER['REQUEST_METHOD'] == 'POST') { //Pārbauda, vai pieprasījuma metode ir "POST"
    $klientsId = $_POST['id'];  //Saņem klienta ID no POST pieprasījuma un saglabā to mainīgajā

    $stmt = $savienojums->prepare("SELECT id FROM klienti WHERE id = ?");   //Sagatavo SQL vaicājumu, lai pārbaudītu, vai klients ar norādīto ID eksistē
    $stmt->bind_param('i', $klientsId);                                     
    $stmt->execute();   
    $resultats = $stmt->get_result();

    if ($resultats->num_rows > 0) { //Ja klients eksistē, tad izdzeš rēķinu
        $stmt = $savienojums->prepare("DELETE FROM klienti WHERE id = ?");
        $stmt->bind_param('i', $klientsId);

        if ($stmt->execute()) {     //Ja rēķins veiksmīgi dzēsts, paziņojums par to
            echo json_encode(['status' => 'izdevies', 'ziņa' => 'Rēķins ir veiksmīgi dzēsts.']);
        } else {    //Ja rēķinu neizdevās dzēst, paziņojums par to
            echo json_encode(['status' => 'kļūda', 'ziņa' => 'Neizdevās dzēst rēķinu.']);
        }
    } else {    //Ja rēķins neeksistē, paziņojums par to
        echo json_encode(['status' => 'kļūda', 'ziņa' => 'Rēķins neeksistē.']);
    }
}
?>