function pievienotKlientu() {   //Jauna klienta pievienošana
    Swal.fire({ //Klienta pievienošana dialoga formā
        title: 'Pievienot jaunu klientu',
        html: `
            <input type="text" id="klientaNosauk" class="swal2-input" placeholder="Klients">
            <input type="text" id="regNum" class="swal2-input" placeholder="Reģistrācijas numurs">
            <input type="text" id="pvnNum" class="swal2-input" placeholder="PVN reģistrācijas numurs">
            <textarea id="adrese" class="swal2-textarea" placeholder="Juridiskā adrese"></textarea>
            <input type="text" id="bankasNosauk" class="swal2-input" placeholder="Banka">
            <input type="text" id="bankasKods" class="swal2-input" placeholder="Bankas kods">
            <input type="text" id="bankasNum" class="swal2-input" placeholder="Bankas koda numurs">
        `,
        focusConfirm: false,
        preConfirm: () => { //Klienta datu validācija
            const klientaNosauk = $('#klientaNosauk').val();
            const regNum = $('#regNum').val();
            const pvnNum = $('#pvnNum').val();
            const adrese = $('#adrese').val();
            const bankasNosauk = $('#bankasNosauk').val();
            const bankasKods = $('#bankasKods').val();
            const bankasNum = $('#bankasNum').val();

            if (!klientaNosauk || !regNum || !adrese) { //Klienta datu obligātu lauku validācija
                Swal.showValidationMessage('Lūdzu aizpildiet obligātos laukus');
            }
            return { klientaNosauk, regNum, pvnNum, bankasNosauk, bankasKods, bankasNum, adrese };  //Klienta datu objekts
        }
    }).then((resultats) => {    //Klienta datu pievienošana pēc pogas "Saglabāt" nospiešanas
        if (resultats.isConfirmed) {    //Klienta datu pievienošana
            $.ajax({    //Klienta datu pievienošana datubāzei
                url: 'pievienot_klientu.php', 
                type: 'POST',
                data: resultats.value,
                success: function (response) {  //Klienta datu pievienošanas funkcija
                    Swal.fire('Success', 'Jauns klients pievienots veiksmīgi!', 'success');
                    ievaktDatus();
                    ievaktDokDatus('#klients_id', '#rekins_nr');
                },
                error: function (xhr, status, error) {  //Klienta datu pievienošanas kļūda
                    Swal.fire('Error', 'Neizdevās pievienot klientu.', 'error');
                }
            });
        }
    });
};

function kopetKlientu(klientaId) {  //Esoša klienta kopēšana
    $.ajax({    //Klienta datu kopēšanai nepieciešamo datu iegūšana
        url: 'rediget_klientu.php',
        method: 'GET',
        data: { id: klientaId },
        dataType: 'json',
        success: function(klients) {    //Klienta datu kopēšanas funkcija
            Swal.fire({ //Klienta datu kopēšana dialoga formā
                title: 'Kopēt klientu',
                html: `
                    <input type="text" id="klientaNosauk" class="swal2-input" placeholder="Klients" value="${klients.data.klientaNosauk}">
                    <input type="text" id="regNum" class="swal2-input" placeholder="Reģistrācijas numurs" value="${klients.data.regNum}">
                    <input type="text" id="pvnNum" class="swal2-input" placeholder="PVN reģistrācijas numurs" value="${klients.data.pvnNum}">
                    <textarea id="adrese" class="swal2-textarea" placeholder="Juridiskā adrese">${klients.data.adrese}</textarea>
                    <input type="text" id="bankasNosauk" class="swal2-input" placeholder="Banka" value="${klients.data.bankasNosauk}">
                    <input type="text" id="bankasKods" class="swal2-input" placeholder="Bankas kods" value="${klients.data.bankasKods}">
                    <input type="text" id="bankasNum" class="swal2-input" placeholder="Bankas konta numurs" value="${klients.data.bankasNum}">
                `,
                focusConfirm: false,
                preConfirm: () => { //Klienta datu ievietošana laukos pirms pogas "Saglabāt" nospiešanas
                    const klientaNosauk = $('#klientaNosauk').val();
                    const regNum = $('#regNum').val();
                    const pvnNum = $('#pvnNum').val();
                    const adrese = $('#adrese').val();
                    const bankasNosauk = $('#bankasNosauk').val();
                    const bankasKods = $('#bankasKods').val();
                    const bankasNum = $('#bankasNum').val();

                    if (!klientaNosauk || !regNum || !adrese) { //Klienta datu obligātu lauku validācija
                        Swal.showValidationMessage('Lūdzu aizpildiet obligātos laukus');
                    }
                    return { klientaId, klientaNosauk, regNum, pvnNum, bankasNosauk, bankasKods, bankasNum, adrese };    //Klienta datu objekts
                }
            }).then((resultats) => {    //Klienta datu pievienošana pēc pogas "Saglabāt" nospiešanas
                if (resultats.isConfirmed) {    //Klienta datu pievienošana
                    $.ajax({    //Klienta datu pievienošana datubāzei
                        url: 'pievienot_klientu.php',
                        type: 'POST',
                        data: resultats.value,
                        success: function (response) {  //Paziņojums, ja dati veiksmīgi pievienoti
                            Swal.fire('Success', 'Jauns klients pievienots veiksmīgi!', 'success');
                            ievaktDatus();
                        },
                        error: function (xhr, status, error) {  //Paziņojums, ja datus neizdevās pievienot
                            Swal.fire('Error', 'Neizdevās pievienot klientu.', 'error');
                        }
                    });
                }
            });
        },
        error: function(xhr, status, error) {    //Klienta datu iegūšanas kļūda
            Swal.fire('Error', 'Neizdevās iegūt klienta datus.', 'error');
        }
    });
} 

function dzestKlientu(klientaId) {  //Klienta datu dzēšana
    Swal.fire({ //Klienta datu dzēšanas pārliecināšanās
        title: 'Vai tiešām vēlaties dzēst šo klientu?',
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#d33',
        cancelButtonColor: '#3085d6',
        confirmButtonText: 'Jā',
        cancelButtonText: 'Nē'
    }).then((resultats) => {    //Klienta datu dzēšanas pārliecināšanās
        if (resultats.isConfirmed) {    //Klienta datu dzēšana, ja lietotājs apstiprina
            $.ajax({    //Klienta datu dzēšana no datubāzes
                url: 'dzest_klientu.php',
                type: 'POST',
                data: { id: klientaId },
                success: function(atbilde) {    //Datu dzēšanas funkcija
                    var atbilde = JSON.parse(atbilde);
                    if (atbilde.status === 'izdevies') {    //Datu dzēšanas izdošanās
                        Swal.fire('Dzēsts!', 'Klients ir veiksmīgi dzēsts.', 'success');
                        ievaktDatus();  //Klientu tabulas atjaunināšana
                    } else {    //Datu dzēšanas kļūda
                        Swal.fire('Kļūda!', atbilde.message, 'error');
                    }
                },
                error: function(xhr, status, error) {    //Klienta datu dzēšanas kļūda
                    Swal.fire('Kļūda!', 'Neizdevās dzēst klientu.', 'error');
                }
            });
        }
    });
}

function redigetKlientu(klientaId) {    //Klienta datu rediģēšana
    $.ajax({    //Klienta datu ievākšana rediģēšanai
        url: 'rediget_klientu.php',
        method: 'GET',
        data: { id: klientaId },
        dataType: 'json',
        success: function(klients) {    //Klienta datu rediģēšanas funkcija, ja dati veiksmīgi ievākti
            Swal.fire({ //Klienta datu rediģēšanas pārliecināšanās
                title: 'Rediģēt klientu',
                html: `
                    <input type="text" id="klientaNosauk" class="swal2-input" placeholder="Klients" value="${klients.data.klientaNosauk}">
                    <input type="text" id="regNum" class="swal2-input" placeholder="Reģistrācijas numurs" value="${klients.data.regNum}">
                    <input type="text" id="pvnNum" class="swal2-input" placeholder="PVN reģistrācijas numurs" value="${klients.data.pvnNum}">
                    <textarea id="adrese" class="swal2-textarea" placeholder="Juridiskā adrese">${klients.data.adrese}</textarea>
                    <input type="text" id="bankasNosauk" class="swal2-input" placeholder="Banka" value="${klients.data.bankasNosauk}">
                    <input type="text" id="bankasKods" class="swal2-input" placeholder="Bankas kods" value="${klients.data.bankasKods}">
                    <input type="text" id="bankasNum" class="swal2-input" placeholder="Bankas konta numurs" value="${klients.data.bankasNum}">
                `,
                focusConfirm: false,
                preConfirm: () => { //Klienta datu ievietošana laukos pirms pogas "Saglabāt"
                    const klientaNosauk = $('#klientaNosauk').val();
                    const regNum = $('#regNum').val();
                    const pvnNum = $('#pvnNum').val();
                    const adrese = $('#adrese').val();  
                    const bankasNosauk = $('#bankasNosauk').val();
                    const bankasKods = $('#bankasKods').val();
                    const bankasNum = $('#bankasNum').val();

                    if (!klientaNosauk || !regNum || !adrese) { //Klienta datu obligātu lauku validācija
                        Swal.showValidationMessage('Lūdzu aizpildiet obligātos laukus');
                    }
                    return { klientaId, klientaNosauk, regNum, pvnNum, bankasNosauk, bankasKods, bankasNum, adrese };    //Klienta datu objekts
                }
            }).then((resultats) => {    //Klienta datu atjaunināšana pēc pogas "Saglabāt" nospiešanas
                if (resultats.isConfirmed) {    //Klienta datu atjaunināšana
                    $.ajax({    //Klienta datu atjaunināšana datubāzē
                        url: 'rediget_klientu.php',
                        type: 'POST',
                        data: resultats.value,
                        success: function (atbilde) {    //Klienta datu atjaunināšanas funkcija
                            var atbilde = JSON.parse(atbilde);
                            if (atbilde.status === 'izdevies') {    //Klienta datu atjaunināšanas izdošanās
                                Swal.fire('Success', 'Klienta dati ir veiksmīgi atjaunināti!', 'success');
                                ievaktDatus();
                            } else {    //Klienta datu atjaunināšanas kļuada
                                Swal.fire('Error', atbilde.message, 'error');
                            }
                        },
                        error: function (xhr, status, error) {  //Klienta datu atjaunināšanas kļūda
                            Swal.fire('Error', 'Neizdevās atjaunināt klienta datus.', 'error');
                        }
                    });
                }
            });
        },
        error: function(xhr, status, error) {    //Klienta datu iegūšanas kļūda
            Swal.fire('Error', 'Neizdevās iegūt klienta datus.', 'error');
        }
    });
}

function redigetDokumentu(dokuments_id, veids){    //Dokumentu datu rediģēšana
    window.location.href = "izveidot_dokumentu.php?id=" + dokuments_id + "&veids=" + veids;    //Aizvirza uz dokumentu veidošanas lapu, pievienojot izvēlētā dokumenta identifikatoru
};

function ievaktDatus() {    //Tabulu datu ievākšana vai atjaunošana programmas izpildes laikā
    $.ajax({    //Datu ievākšana no datubāzes
        url: 'ievakt_datus.php',
        method: 'GET',
        dataType: 'json',
        success: function(dati) {    //Datu ievietošanas funkcija
            var dokumentuTabula = $('table#dokumenti tbody');
            dokumentuTabula.empty();    //Dokumentu tabulas attīrīšana

            if (dati.dokumenti.length > 0) {    //Tabula ar dokumentiem
                $.each(dati.dokumenti, function(index, dokuments) { //Dokumentu datu ievietošana
                    var row = '<tr>' +
                        '<td>' + htmlspecialchars(dokuments.rekins_nr) + '</td>' +
                        '<td>' + htmlspecialchars(dokuments.datums) + '</td>' +
                        '<td>' + htmlspecialchars(dokuments.klients) + '</td>' +
                        '<td>' + htmlspecialchars(parseFloat(dokuments.summa).toFixed(2)) + ' €</td>' +
                        '<td>' +
                            '<button onclick="dzestDokumentu(' + dokuments.id + ', ' + dokuments.rekins_nr.toString() + ')">Dzēst</button>' +
                            '<button onclick="redigetDokumentu(' + dokuments.id + ', \'rediget\')">Rediģēt</button>' +
                            '<button onclick="redigetDokumentu(' + dokuments.id + ', \'kopet\')">Kopēt</button>' +
                            '<button onclick="lejupieladetDokumentu(' + dokuments.id + ')">Lejupielādēt</button>' +
                        '</td>' +
                    '</tr>';
                    dokumentuTabula.append(row);    //Dokumenta rindas ievietošana tabulā
                });
            } else {    //Dokumenta tabulai pievieno noklusījuma rindu, ja nav dokumentu
                dokumentuTabula.append('<tr><td colspan="5">Nav atrasti rēķini.</td></tr>');
            }

            var klientuTabula = $('table#klienti tbody');
            klientuTabula.empty();  //Klientu tabulas attīrīšana

            if (dati.klienti.length > 0) {  //Tabula ar klientiem
                $.each(dati.klienti, function(index, klients) { //Klientu datu ievietošana
                    var row = '<tr>' +
                        '<td>' + htmlspecialchars(klients.nosaukums) + '</td>' +
                        '<td>' +
                            '<button onclick="dzestKlientu(' + klients.id + ')">Dzēst</button>' +
                            '<button onclick="redigetKlientu(' + klients.id + ')">Rediģēt</button>' +
                            '<button onclick="kopetKlientu(' + klients.id + ')">Kopēt</button>' +
                        '</td>' +
                    '</tr>';
                    klientuTabula.append(row);  //Klienta rindas ievietošana tabulā
                });
            } else {    //Klienta tabulai pievieno noklusījuma rindu, ja nav klientu
                klientuTabula.append('<tr><td colspan="5">Nav atrasti klienti.</td></tr>');  
            }
        },
        error: function(xhr, status, error) {    //Datu iegūšanas kļūda
            console.error('Error fetching data: ', error);
        }
    });
}   

function ievaktDokDatus(klientaIzvelnesId, mervienibuIzvelnesId) {
    return new Promise((resolve, reject) => { // Wrap in a Promise
        $.ajax({
            url: 'ievakt_dok_datus.php',
            method: 'GET',
            dataType: 'json',
            success: function(dati) { 
                // Clear and populate klientaIzvelnesId
                $(klientaIzvelnesId).empty();
                $(klientaIzvelnesId).append('<option value="0">Izvēlieties klientu</option>');
                if (dati.klienti) {
                    dati.klienti.forEach(function(klients) {
                        $(klientaIzvelnesId).append(
                            `<option value="${klients.id}">${klients.nosaukums}</option>`
                        );
                    });
                }
                
                // Add a default row
                pievienotRindu("", 0, "", "", "");

                // Clear and populate mervienibuIzvelnesId
                $(mervienibuIzvelnesId).empty();
                $(mervienibuIzvelnesId).append('<option value="0">Izvēlieties mērvienību</option>');
                if (dati.mervienibas) {
                    dati.mervienibas.forEach(function(mervieniba) {
                        $(mervienibuIzvelnesId).append(
                            `<option value="${mervieniba.id}">${mervieniba.mervieniba}</option>`
                        );
                    });
                }

                // Resolve the Promise after successful data handling
                resolve();
            },
            error: function() {
                alert('Kļūda ielādējot klientu datus.');
                reject(new Error('Kļūda ielādējot klientu datus.'));
            }
        });
    });
}


function ievaktRekinaNr(rekinaNr) {
    return new Promise((resolve, reject) => { // Wrap in a Promise
        $.ajax({
            url: 'ievakt_rekina_nr.php',
            method: 'GET',
            dataType: 'json',
            success: function(dati) {
                // Populate the provided rekinaNr input with the next invoice number
                $(rekinaNr).val(dati.nakamais_rekina_nr);
                resolve(); // Resolve the Promise after successful operation
            },
            error: function() {
                alert('Kļūda meklējot rēķina numuru.');
                reject(new Error('Kļūda meklējot rēķina numuru.')); // Reject on error
            }
        });
    });
}

function ievaktDokDatus2(dokuments_id) {
    return new Promise((resolve, reject) => { // Wrap in a Promise
        $.ajax({
            url: 'rediget_dokumentu.php',
            method: 'GET',
            data: { rekins_id: dokuments_id },
            dataType: 'json',
            success: function(dati) {
                if (dati.status === 'success') {
                    var dokumentuRedaktors = $('#izveidot_rekinu');
                    dokumentuRedaktors.find('#klients_id').val(dati.klients_id);
                    dokumentuRedaktors.find('#rekins_nr').val(dati.rekins_nr);
                    dokumentuRedaktors.find('#izr_datums').val(dati.izr_datums);
                    dokumentuRedaktors.find('#apm_datums').val(dati.apm_datums);
                    dokumentuRedaktors.find('#pvn').val(dati.pvn);
                    dokumentuRedaktors.find('#piezimes').val(dati.piezimes);

                    var tabula = $('#izveidot_rekinu #apmaksa_tabula tbody');
                    tabula.empty(); // Clear payment table
                    if (dati.apmaksa && dati.apmaksa.length > 0) {
                        // Populate payment table
                        $.each(dati.apmaksa, function(index, apmaksa) {
                            pievienotRindu(apmaksa.nosaukums, apmaksa.mervieniba_id, apmaksa.daudzums, apmaksa.cena, dati.pvn);
                        });
                    }
                    resolve(); // Resolve the Promise on success
                } else {
                    Swal.fire('Error', 'Neizdevās iegūt dokumenta datus.', 'error');
                    reject(new Error('Dokumenta datu iegūšana neizdevās.'));
                }
            },
            error: function(xhr, status, error) {
                Swal.fire('Error', 'Neizdevās iegūt dokumenta datus.', 'error');
                reject(new Error('Kļūda sazinoties ar serveri: ' + error));
            }
        });
    });
}

async function dokDatuKopesana() {
    try {
        await ievaktDokDatus('#klients_id', '#mervienibasId');
        await ievaktDokDatus2(rekina_id);
        await ievaktRekinaNr('#rekins_nr');
    } catch (error) {
        console.error('An error occurred:', error);
    }
}

async function dokDatuRedigesana() {
    try {
        ievaktRekinaNr('#rekins_nr');
        ievaktDokDatus('#klients_id', '#mervienibasId');
        ievaktDokDatus2(rekina_id);
    } catch (error) {
        console.error('An error occurred:', error);
    }
}

async function jaunsDok() {
    try {
        ievaktRekinaNr('#rekins_nr');
        ievaktDokDatus('#klients_id', '#mervienibasId');
    } catch (error) {
        console.error('An error occurred:', error);
    }
}

function dzestDokumentu(rekins_id, rekins_nr) {    //Dokumentu datu dzēšana
    Swal.fire({    //Dokumenta datu dzēšanas pārliecināšanās
        title: 'Vai tiešām vēlaties dokumentu Nr.' + rekins_nr + '?',
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#d33',
        cancelButtonColor: '#3085d6',
        confirmButtonText: 'Jā',
        cancelButtonText: 'Nē'
    }).then((resultats) => {    //Dokumenta datu dzēšanas funkcija
        if (resultats.isConfirmed) {    //Dokumenta datu dzēšanas, ja lietotājs apstiprina
            $.ajax({    //Dokumenta datu dzēšana no datubāzes
                type: 'POST',
                url: 'dzest_dokumentu.php',
                data: { id: rekins_id },
                success: function(atbilde) {    //Dokumenta datu dzēšanas funkcija
                    if (atbilde.status === 'success') {    //Dokumenta datu dzēšanas izdošanās
                        Swal.fire('Success', 'Dokumenta dati veiksmīgi dzēsti!', 'success');
                        ievaktDatus();  //Dokumentu tabulas atjaunināšana
                    } else {    //Dokumenta datu dzēšanas kļūda
                        Swal.fire('Error', 'Neizdevās dzēst datus!', 'error');
                    }
                }
            });
        }
    });
}

function izveidotDokumentu(rekina_id, veids) {    //Jauna dokumenta veidošana
    var data = {    //Dokumenta vispārējo datu piešķiršana masīvam
        klients_id: $('#klients_id').val(),
        rekins_nr: $('#rekins_nr').val(),
        izr_datums: $('#izr_datums').val(),
        apm_datums: $('#apm_datums').val(),
        pvn: $('#pvn').val(),
        piezimes: $('#piezimes').val(),
        tableData: []
    };
  
    $('#apmaksas_tabula tbody tr').each(function() {    //Dokumenta apmaksas datu ievietošana masīvā
        var row = {
            nosaukums: $(this).find('td:eq(0) input').val(),
            mervieniba_id: $(this).find('td:eq(1) select').val(),
            daudzums: $(this).find('td:eq(2) input').val(),
            cena: $(this).find('td:eq(3) input').val()
        };
        data.tableData.push(row);    //Dokumenta apmaksas datu rindas ievietošana masīvā
    });
  
    if (!rekina_id || veids == 'kopet') {
        $.ajax({    //Dokumenta datu ievākšana no datubāzes
            type: 'POST',
            url: 'pievienot_dokumentu.php',
            data: data,
            success: function(response) {    //Dokumenta datu pievienošanas funkcija
                console.log(data);
                alert("Dokuments pievienots!");  //Paziņojums par dokumenta pievienošanu
                window.location.href = 'logtradeLietvediba.php';    //Aizvirza uz galveno lapu lapu
            }
        });
    } else {
        data.rekins_id = rekina_id;
        $.ajax({    //Dokumenta datu ievākšana no datubāzes
            type: 'POST',
            url: 'rediget_dokumentu.php',
            data: data,
            success: function(response) {    //Dokumenta datu pievienošanas funkcija
                console.log(data);
                alert("Dokuments saglabāts!");  //Paziņojums par dokumenta pievienošanu
                //window.location.href = 'logtradeLietvediba.php';    //Aizvirza uz galveno lapu lapu
            }
        });
    }
}

function lejupieladetDokumentu(id) {
    $.ajax({
        url: 'lejupieladet_dokumentu.php',  // Your PHP script to get the document info
        type: 'GET',
        data: {
            dokuments_id: id  // Send document ID as a query parameter
        },
        success: function(data) {
            // Create a new workbook and worksheet
            const workbook = new ExcelJS.Workbook();
            const worksheet = workbook.addWorksheet('Document Information');

            // Set headers in the first row (A1, B1, C1, etc.)
            worksheet.getCell('A1').value = 'Document Number';
            worksheet.getCell('B1').value = 'Issue Date';
            worksheet.getCell('C1').value = 'Payment Date';
            worksheet.getCell('D1').value = 'VAT';
            worksheet.getCell('E1').value = 'Notes';
            worksheet.getCell('F1').value = 'Client Name';
            worksheet.getCell('G1').value = 'Client Registration Number';
            worksheet.getCell('H1').value = 'Client VAT Registration Number';
            worksheet.getCell('I1').value = 'Client Address';
            worksheet.getCell('J1').value = 'Client Bank';
            worksheet.getCell('K1').value = 'Client Bank Code';
            worksheet.getCell('L1').value = 'Client Bank Account Number';

            // Set the data starting from row 2 (without dokuments_id)
            worksheet.getCell('A2').value = data.rekins_nr;
            worksheet.getCell('B2').value = data.izr_datums;
            worksheet.getCell('C2').value = data.apm_datums;
            worksheet.getCell('D2').value = data.pvn;
            worksheet.getCell('E2').value = data.piezimes;

            // Client data starts from row 2
            worksheet.getCell('F2').value = data.klients.nosaukums;
            worksheet.getCell('G2').value = data.klients.reg_nr;
            worksheet.getCell('H2').value = data.klients.pvn_reg_nr;
            worksheet.getCell('I2').value = data.klients.adrese;
            worksheet.getCell('J2').value = data.klients.banka;
            worksheet.getCell('K2').value = data.klients.banka_kods;
            worksheet.getCell('L2').value = data.klients.banka_nr;

            // Add a row for payment data
            worksheet.getCell('A4').value = 'Payments:';
            worksheet.getCell('A5').value = 'Item';
            worksheet.getCell('B5').value = 'Unit';
            worksheet.getCell('C5').value = 'Quantity';
            worksheet.getCell('D5').value = 'Price';

            // Populate payment data starting from row 6
            let rowIndex = 6;
            data.apmaksa.forEach(payment => {
                worksheet.getCell('A' + rowIndex).value = payment.nosaukums;
                worksheet.getCell('B' + rowIndex).value = payment.mervienibas_nosaukums;
                worksheet.getCell('C' + rowIndex).value = payment.daudzums;
                worksheet.getCell('D' + rowIndex).value = payment.cena;
                rowIndex++;
            });

            // Set column widths for better readability
            worksheet.getColumn('A').width = 20;
            worksheet.getColumn('B').width = 20;
            worksheet.getColumn('C').width = 15;
            worksheet.getColumn('D').width = 15;
            worksheet.getColumn('E').width = 10;
            worksheet.getColumn('F').width = 30;
            worksheet.getColumn('G').width = 30;

            // Write to a file (in a browser, trigger download)
            workbook.xlsx.writeBuffer().then(function (buffer) {
                const blob = new Blob([buffer], { type: 'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet' });
                const link = document.createElement('a');
                link.href = URL.createObjectURL(blob);
                link.download = `document_${data.rekins_nr}.xlsx`; // Name of the downloaded file
                link.click();
            });
        },
        error: function(xhr, status, error) {
            // Handle any errors with the AJAX request
            console.error('Error: ' + error);
        }
    });
}


var rows = 0;
var pirmaRinda = "";
function pievienotRindu(nosaukums, mervieniba_id, daudzums, cena, pvn) {    //Apmaksas rindas pievienošana
    var table = document.getElementById("apmaksas_tabula").getElementsByTagName('tbody')[0];
    var row = table.insertRow();
    
    var nosaukumsCell = row.insertCell(0);
    var mervienibaCell = row.insertCell(1);
    var daudzumsCell = row.insertCell(2);
    var cenaCell = row.insertCell(3);
    var summaCell = row.insertCell(4);

    nosaukumsCell.innerHTML = '<input type="text" name="nosaukums[]" value="' + nosaukums + '">';
    var mervienibaSelect;
    if (rows == 0) {    //Pirmās rindas mērvienību izvēlnes izveide
        mervienibaSelect = document.createElement('select');
        mervienibaSelect.name = 'mervieniba[]';
        mervienibaSelect.id = 'mervienibasId';
        mervienibaCell.appendChild(mervienibaSelect);    //Mērvienību izvēlnes pievienošana šūnā
    } else {    //Nākamo rindu mērvienību izvēlnes izveide
        mervienibaSelect = document.getElementById('mervienibasId');
        var newSelect = document.createElement('select');
        newSelect.name = 'mervieniba[]';
        for (var i = 0; i < mervienibaSelect.options.length; i++) {    //Mērvienību izvēlnes papildināšana ar mervienību izvēlēm
            var option = mervienibaSelect.options[i];
            var newOption = new Option(option.text, option.value);
            newSelect.options.add(newOption);   //Pievieno mērvienību izvēlnei
        }
        setTimeout(function() {
            newSelect.value = mervieniba_id;
        }, 50);
        mervienibaCell.appendChild(newSelect);    //Mērvienību izvēlnes pievienošana šūnā
        if (mervieniba_id == "0") {
            pirmaRinda = "dzests";
        };
        if (pirmaRinda != "dzests" && rows != 0) {
            pirmaRinda = "dzests";
            document.getElementById("apmaksas_tabula").deleteRow(1);
            newSelect.id = "mervienibasId";
        }
    }
    daudzumsCell.innerHTML = '<input type="number" name="daudzums[]" value="' + daudzums + '" oninput="updateSumma(this)">';
    cenaCell.innerHTML = '<input type="number" step="0.01" name="cena[]" value="' + cena + '" oninput="updateSumma(this)">';
    var summa = cena * daudzums + (cena * daudzums * (pvn/100));
    summaCell.innerHTML = '<span class="summa">' + summa + '</span>';

    rows++;    //Rindu skaitītājs
    calcApmTermins();    //Apmaksas terminu reķināšana
}

function updateSumma(element) {     //Apmaksas summu reķināšana
    if (element == "pvn") {   //Apmaksas summu aprēķins, ja ievadīts pvn
        var table = document.getElementById("apmaksas_tabula").getElementsByTagName('tbody')[0];
        var rows = table.getElementsByTagName('tr');
        var pvn = document.getElementById("pvn").value;
        for (var i=0; i < rows.length; i++) {    //Apmaksas summu atjaunošana
            var row = rows[i];
            var daudzums = row.cells[2].getElementsByTagName('input')[0].value;
            var cena = row.cells[3].getElementsByTagName('input')[0].value;
            var summa = row.cells[4].getElementsByClassName('summa')[0];
            summa.textContent = (daudzums * cena + (daudzums * cena *(pvn/100))).toFixed(2);
        }
    } else {    //Apmaksas summu apręķins, ja ievadāts daudzums vai cena
        var row = element.parentElement.parentElement;
        var daudzums = row.cells[2].getElementsByTagName('input')[0].value;
        var cena = row.cells[3].getElementsByTagName('input')[0].value;
        var summa = row.cells[4].getElementsByClassName('summa')[0];
        var pvn = document.getElementById("pvn").value;

        summa.textContent = (daudzums * cena + (daudzums * cena *(pvn/100))).toFixed(2); //Apmaksas summu atjaunošana
    }
}

function calcApmDatums() {    //Apmaksas datuma reķināšana
    let izr_date = new Date(document.getElementById('izr_datums').value);
    let apm_termins = document.getElementById('apm_termins').value;
    let apm_date = new Date(izr_date.setDate(izr_date.getDate() + parseInt(apm_termins)));
    document.getElementById('apm_datums').valueAsDate = apm_date;    //Apmaksas datuma atjaunošana
}

function calcApmTermins() {    //Apmaksas termiņa reķināšana
    let izr_date = new Date(document.getElementById('izr_datums').value);
    let apm_date = new Date(document.getElementById('apm_datums').value);
    let apm_termins = Math.ceil((apm_date - izr_date) / (1000 * 60 * 60 * 24));
    document.getElementById('apm_termins').value = apm_termins;    //Apmaksas termiņa atjaunošana
}

function htmlspecialchars(str) {    //HTML speciālo rakstzīmju pārveidošana
    return str
    .replace(/&/g, '&amp;')
    .replace(/</g, '&lt;')
    .replace(/>/g, '&gt;')
    .replace(/"/g, '&quot;')
    .replace(/'/g, '&#039;');
}