<!-- Autors: Roberts Saulītis -->
<!-- Apraksts: Rēķinu HTML lapa -->
<?php
//Neļauj izmantot jebkāda veida kešatmiņu
header("Cache-Control: no-store, no-cache, must-revalidate, max-age=0");
header("Cache-Control: post-check=0, pre-check=0", false);
header("Pragma: no-cache");
require '../app/autentifikacija.php';  //Pievieno autentifikāciju no autentifikacija.php faila
?>
<!DOCTYPE html>

<head>
    <!-- Noklusējuma iestatījumi -->
    <meta charset="UTF-8">
    <title>Pievienot Rēķinu</title>
    <!-- Visu nepieciešamo bilbiotēku un failu iekļaušana -->
     <link rel="stylesheet" href="./CSS/lapu_stili.css">
    <link rel="stylesheet" href="./CSS/rekinu_stili.css">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css">
    <script src="./js/rekinu_funkcijas.js"></script>
    <script src="./js/lapu_funkcijas.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>
</head>

<body class="overflow-x-hidden bg-light py-3 px-3">
    <!-- Galvene -->
    <header class="container-fluid bg-dark text-white py-3 rounded">
        <div class="pielagots-logs">
            <div class="row align-items-center w-100">
                <!-- Nosaukums -->
                <div class="col-lg-3 col-md-4 col-12 text-start">
                    <h1 class="mb-0 fw-bold fs-2 text-nowrap">LogTrade Services</h1>
                </div>
                <!-- Pulkstenis -->
                <div class="col-lg-6 col-md-4 col-12 text-center">
                    <p id="pulkstenis" class="mb-0 fs-4 fw-light"></p>
                </div>
                <div class="col-lg-3 col-md-4 col-12 text-end">
                    <!-- Pogas - atgriešanās uz iepriekšējo lapu un atslēgšanās no programmas -->
                    <h1 class="mb-0">
                        <a href="./index.php" class="text-white text-decoration-none btn btn-outline-light btn-sm px-4 py-2 kursors-virs">Atgriezties</a>
                        <a href="../app/atslegties.php" class="text-white text-decoration-none btn btn-outline-light btn-sm px-4 py-2 kursors-virs">Iziet</a>
                    </h1>
                </div>
            </div>
        </div>
    </header>

    <div class="logs py-4">
        <div class="row mb-3">
            <div class="col-12 text-center">
                <h2 class="fw-bold">Ŗēķinu lapa</h2>
            </div>
        </div>
        <div class="row">
            <!-- Rēķinu izveides forma -->
            <div class="col-12">
                <form id="rekinu_izveides_veidlapa" method="POST" class="p-4 border rounded shadow-sm bg-light">
                    <div class="row">
                        <!-- Rēķina numurs -->
                        <div class="col-md-4 mb-3">
                            <label for="rekins_nr" class="form-label">Rēķina nr.:</label><span class="zvaigzne">*</span>
                            <input type="text" id="rekins_nr" name="rekins_nr" class="form-control" readonly required>
                        </div>
                        <!-- Klients -->
                        <div class="col-md-4 mb-3">
                            <label for="klients_id" class="form-label">Klients:</label><span class="zvaigzne">*</span>
                            <div class="d-flex">
                                <select id="klients_id" name="klients_id" class="form-select me-2 klients-izvelne" required oninvalid="this.setCustomValidity('Izvēlies klientu!')" oninput="this.setCustomValidity('')">
                                    <option value="">Izvēlieties klientu</option>
                                </select>
                            </div>
                        </div>
                        <!-- Poga jauna klienta pievienošanai -->
                        <div class="col-md-4 mb-3 d-flex flex-column justify-content-between">
                            <p></p>
                            <p></p>
                            <button type="button" class="btn btn-outline-primary w-100 pievienot-klientu-poga" onclick="pievienotKlientu()">Pievienot klientu</button>
                        </div>
                    </div>

                    <div class="row">
                        <!-- Izrakstīšanas datums -->
                        <div class="col-md-4 mb-3">
                            <label for="izr_datums" class="form-label">Rēķina izrakstīšanas datums:</label><span class="zvaigzne">*</span>
                            <input type="date" id="izr_datums" name="izr_datums" class="form-control" value="<?php echo date('Y-m-d'); ?>" onchange="this.form.izr_datums.value = this.value;" required oninvalid="this.setCustomValidity('Izvēlies datumu!')" oninput="this.setCustomValidity(''); izrekinatApmTerminu(); izrekinatApmDatumu()">
                        </div>
                        <!-- Apmaksas termiņš -->
                        <div class="col-md-4 mb-3">
                            <label for="apm_termins" class="form-label">Apmaksas termiņš (dienas):</label><span class="zvaigzne">*</span>
                            <input type="number" id="apm_termins" name="apm_termins" class="form-control" onchange="izrekinatApmDatumu()" default="0" oninvalid="this.setCustomValidity('Ievadi apmaksas termiņu!')" oninput="this.setCustomValidity('')">
                        </div>
                        <!-- Apmaksas datums -->
                        <div class="col-md-4 mb-3">
                            <label for="apm_datums" class="form-label">Apmaksas datums:</label><span class="zvaigzne">*</span>
                            <input type="date" id="apm_datums" name="apm_datums" class="form-control" value="<?php echo date('Y-m-d'); ?>" required oninvalid="this.setCustomValidity('Ievadi apmaksas datumu!')" oninput="this.setCustomValidity(''); izrekinatApmTerminu()">
                        </div>
                    </div>

                    <!-- PVN -->
                    <div class="mb-3">
                        <label for="pvn" class="form-label">PVN apmērs %:</label><span class="zvaigzne">*</span>
                        <input type="number" id="pvn" name="pvn" class="form-control" step="0.01" required oninvalid="this.setCustomValidity('Ievadi PVN apmēru!')" oninput="this.setCustomValidity(''); atjaunotSummu('pvn')">
                    </div>

                    <!-- Apmaksas tabula -->
                    <div class="mb-3">
                        <table class="table table-bordered table-striped" id="apmaksas_tabula">
                            <thead class="table-dark">
                                <tr>
                                    <th class="col-5">Nosaukums<span class="zvaigzne">*</span></th>
                                    <th class="col-3">Mērvienība<span class="zvaigzne">*</span></th>
                                    <th class="col-1">Daudzums<span class="zvaigzne">*</span></th>
                                    <th class="col-1">Cena<span class="zvaigzne">*</span></th>
                                    <th class="col-1">Summa</th>
                                    <th class="col-1">Dzēst</th>
                                </tr>
                            </thead>
                            <tbody></tbody>
                        </table>
                    </div>

                    <div class="row">
                        <div class="col-md-9">
                            <!-- Apmaksas rindas pievienošanas poga -->
                            <div class="mb-3">
                                <button type="button" class="btn btn-outline-secondary" onclick="pievienotRindu('',0,'','','')">Pievienot rindu</button>
                            </div>
                            <!-- Piezīmes -->
                            <div class="mb-3">
                                <label for="piezimes" class="form-label">Piezīmes:</label>
                                <input type="text" id="piezimes" name="piezimes" class="form-control">
                            </div>
                        </div>

                        <!-- Kopsummas -->
                        <div class="col-md-3">
                            <div class="mb-3">
                                <table class="table table-sm table-bordered w-auto">
                                    <tbody>
                                        <!-- Kopsumma bez PVN -->
                                        <tr>
                                            <td class="kopsumma">Kopā bez PVN:</td>
                                            <td class="text-end fw-bold"><span id="kopasummaBezPvn"></span></td>
                                        </tr>
                                        <!-- PVN kopsumma -->
                                        <tr>
                                            <td class="kopsumma">PVN:</td>
                                            <td class="text-end fw-bold"><span id="kopsummaPvn"></span></td>
                                        </tr>
                                        <!-- Kopsumma ar PVN -->
                                        <tr>
                                            <td class="kopsumma">Kopā ar PVN:</td>
                                            <td class="text-end fw-bold"><span id="kopasummaArPvn"></span></td>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>

                    <!-- Rēķina saglabāšanas poga -->
                    <div class="text-center">
                        <button type="submit" id="izveidot_rekinu" class="btn btn-success">Saglabāt</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</body>
