<!-- Autors: Roberts Saulītis -->
<!-- Apraksts: Galvenā (index) HTML lapa -->
<?php
header("Cache-Control: no-store, no-cache, must-revalidate, max-age=0");
header("Cache-Control: post-check=0, pre-check=0", false);
header("Pragma: no-cache"); //Neļauj izmantot jebkāda veida kešatmiņu
require '../app/autentifikacija.php';  //Pievieno autentifikāciju no autentifikacija.php faila
?>
<!DOCTYPE html>

<head>
    <!-- Noklusējuma iestatījumi -->
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <title>Logtrade Services lietvedība</title>
    <!-- Visu nepieciešamo bilbiotēku un failu iekļaušana -->
    <link rel="stylesheet" href="./CSS/lapu_stili.css">
    <link rel="stylesheet" href="./CSS/index_stili.css">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css">
    <script src="./js/index_funkcijas.js"></script>
    <script src="./js/lapu_funkcijas.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/exceljs/dist/exceljs.min.js"></script>
</head>

<body class="overflow-x-hidden bg-light py-3 px-3">
    <!-- Galvenes izkārtojums -->
    <header class="container-fluid bg-dark text-white py-3 rounded">
        <div class="pielagots-logs">
            <div class="row align-items-center w-100">
                <!-- Nosaukumas -->
                <div class="col-lg-3 col-md-4 col-12 text-start">
                    <h1 class="mb-0 fw-bold fs-2 text-nowrap">LogTrade Services</h1>
                </div>
                <!-- Pulkstenis -->
                <div class="col-lg-6 col-md-4 col-12 text-center">
                    <p id="pulkstenis" class="mb-0 fs-4 fw-light"></p>
                </div>
                <!-- Atslēgšanās poga -->
                <div class="col-lg-3 col-md-4 col-12 text-end">
                    <h1 class="mb-0">
                        <a href="../app/atslegties.php" class="text-white text-decoration-none btn btn-outline-light btn-sm px-4 py-2 kursors-virs">Iziet</a>
                    </h1>
                </div>
            </div>
        </div>
    </header>
    <!-- Galvenā sadaļa -->
    <div class="logs">
        <div class="row gx-4">
            <!-- Rēķinu sadaļa -->
            <div class="col-lg-8">
                <div class="p-3 border border-secondary rounded shadow-sm mb-3">
                    <div class="d-flex align-items-center justify-content-between mb-3">
                        <h2 class="mb-0">Rēķinu saraksts</h2>
                        <div class="d-flex align-items-center">
                            <label for="meklejuma_kolonna" class="form-label me-2">Meklēt pēc kolonnas:</label>
                            <select id="meklejuma_kolonna" class="form-select d-inline-block w-auto me-2">
                                <option value="rekins_nr">Rēķina nr.</option>
                                <option value="datums">Datums</option>
                                <option value="klients" selected>Klients</option>
                            </select>
                            <input type="text" id="meklejums" class="form-control d-inline-block w-auto" placeholder="Ierakstiet, lai meklētu..." oninput="filtretTabulu()">
                        </div>
                    </div>
                    <!-- Rēķinu tabula -->
                    <div>
                        <table id="rekini" class="table table-striped table-bordered">
                            <thead class="table-dark">
                                <tr>
                                    <th>Rēķina nr.</th>
                                    <th>Datums</th>
                                    <th>Klients</th>
                                    <th>Summa</th>
                                    <th>Darbības</th>
                                </tr>
                            </thead>
                            <tbody>
                            </tbody>
                        </table>
                    </div>
                    <!-- Rēķinu saraksta lapu kontrole -->
                    <div id="paginationControls" class="d-flex justify-content-between align-items-center mt-2">
                        <button id="iepriekseja_lapa" class="btn btn-outline-primary btn-sm" onclick="mainitLapu(-1)" disabled>Iepriekšējā lapa</button>
                        <span id="sobrideja_lapa" class="fw-bold">Lapa Nr.1</span>
                        <button id="nakama_lapa" class="btn btn-outline-primary btn-sm" onclick="mainitLapu(1)">Nākamā lapa</button>
                    </div>
                    <!-- Rēķinu lapas novirzes poga -->
                    <button onclick='window.location.href="./rekinu_lapa.php"' class="btn btn-success mt-3 w-100">Pievienot rēķinu</button>
                </div>
            </div>
            <!-- Klientu sadaļa -->
            <div class="col-lg-4">
                <div class="p-3 border border-secondary rounded shadow-sm">
                    <!-- Virsraksts -->
                    <div class="d-flex align-items-center justify-content-between mb-3">
                        <h2 class="mb-0">Klientu saraksts</h2>
                    </div>
                    <!-- Klientu tabula -->
                    <div class="atsauciga-tabula">
                        <table id="klienti" class="table table-striped table-bordered">
                            <thead class="table-dark">
                                <tr>
                                    <th>Nosaukums</th>
                                    <th>Darbības</th>
                                </tr>
                            </thead>
                            <tbody>
                            </tbody>
                        </table>
                    </div>
                    <!-- Jauna klienta pievienošanas poga -->
                    <button onclick="pievienotKlientu()" class="btn btn-primary mt-3 w-100">Pievienot klientu</button>
                </div>
            </div>
        </div>
    </div>
</body>