-- --------------------------------------------------------
-- Host:                         127.0.0.1
-- Server version:               9.1.0 - MySQL Community Server - GPL
-- Server OS:                    Win64
-- HeidiSQL Version:             12.10.0.7015
-- --------------------------------------------------------

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET NAMES utf8 */;
/*!50503 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;


-- Dumping database structure for lietvedibas_programma
CREATE DATABASE IF NOT EXISTS `lietvedibas_programma` /*!40100 DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci */ /*!80016 DEFAULT ENCRYPTION='N' */;
USE `lietvedibas_programma`;

-- Dumping structure for table lietvedibas_programma.adreses
CREATE TABLE IF NOT EXISTS `adreses` (
  `id` int NOT NULL AUTO_INCREMENT COMMENT 'Adreses unikāls identifikators',
  `adrese` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT 'Adreses nosaukums',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci COMMENT='Adrešu saraksts';

-- Dumping data for table lietvedibas_programma.adreses: ~1 rows (approximately)
INSERT INTO `adreses` (`id`, `adrese`) VALUES
	(1, 'Piemēra iela 31, Jelgava, LV-3001');

-- Dumping structure for table lietvedibas_programma.apmaksa
CREATE TABLE IF NOT EXISTS `apmaksa` (
  `id` int NOT NULL AUTO_INCREMENT COMMENT 'Rēķina apmaksas unikāls identifikators',
  `rekins_id` int NOT NULL COMMENT 'Rēķina identifikators',
  `nosaukums` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT 'Apmaksas nosaukums',
  `mervieniba_id` int NOT NULL DEFAULT '0' COMMENT 'Mērvienības identifikators',
  `daudzums` decimal(20,2) NOT NULL COMMENT 'Apmaksas daudzums',
  `cena` decimal(20,2) NOT NULL COMMENT 'Apmaksas cena uz vienu vērtību',
  PRIMARY KEY (`id`),
  KEY `FK_apmaksa_dokumenti_rekins` (`rekins_id`),
  KEY `FK_apmaksa_mervienibas` (`mervieniba_id`),
  CONSTRAINT `FK_apmaksa_dokumenti_rekins` FOREIGN KEY (`rekins_id`) REFERENCES `dokumenti_rekins` (`id`),
  CONSTRAINT `FK_apmaksa_mervienibas` FOREIGN KEY (`mervieniba_id`) REFERENCES `mervienibas` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci COMMENT='Rēķinu apmaksas informācija';

-- Dumping data for table lietvedibas_programma.apmaksa: ~1 rows (approximately)
INSERT INTO `apmaksa` (`id`, `rekins_id`, `nosaukums`, `mervieniba_id`, `daudzums`, `cena`) VALUES
	(1, 1, 'Egles apaļkoki 2,9m', 2, 45.64, 80.00);

-- Dumping structure for table lietvedibas_programma.bankas
CREATE TABLE IF NOT EXISTS `bankas` (
  `id` int NOT NULL AUTO_INCREMENT COMMENT 'Bankas unikāls identifikators',
  `banka` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT 'Bankas nosaukums',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci COMMENT='Banku saraksts';

-- Dumping data for table lietvedibas_programma.bankas: ~1 rows (approximately)
INSERT INTO `bankas` (`id`, `banka`) VALUES
	(1, '');

-- Dumping structure for table lietvedibas_programma.darbinieki
CREATE TABLE IF NOT EXISTS `darbinieki` (
  `id` int NOT NULL AUTO_INCREMENT COMMENT 'Darbinieka unikāls identifikators',
  `lietotajvards` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT 'Lietotāja lietotājvārds',
  `parole` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT 'Lietotāja parole',
  `tokens` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT 'Sesijas tokens',
  `tokens_termins` datetime DEFAULT NULL COMMENT 'Tokena derīguma termiņš',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci COMMENT='Darbinieku saraksts';

-- Dumping data for table lietvedibas_programma.darbinieki: ~1 rows (approximately)
INSERT INTO `darbinieki` (`id`, `lietotajvards`, `parole`, `tokens`, `tokens_termins`) VALUES
	(1, 'Administrators', 'Admin410', '5d9ee1ed9787586e09754d53f2b0e8d85f2c706174cfb417af02604bb5792d64', '2025-06-03 13:18:06');

-- Dumping structure for table lietvedibas_programma.dokumenti_rekins
CREATE TABLE IF NOT EXISTS `dokumenti_rekins` (
  `id` int NOT NULL AUTO_INCREMENT COMMENT 'Rēķina unikāls identifikators',
  `klients_id` int NOT NULL COMMENT 'Rēķina klienta identifikators',
  `rekins_nr` varchar(3) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '0' COMMENT 'Rēķina numurs',
  `izr_datums` date NOT NULL COMMENT 'Rēķina izrakstīšanas datums',
  `apm_datums` date NOT NULL COMMENT 'Rēķina apmaksas datums',
  `pvn` decimal(10,2) NOT NULL COMMENT 'Rēķinam piemērojamais PVN',
  `piezimes` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT 'Rēķina piezīmes',
  PRIMARY KEY (`id`),
  UNIQUE KEY `rekins_nr` (`rekins_nr`),
  KEY `FK_dokumenti_rekins_klienti` (`klients_id`),
  CONSTRAINT `FK_dokumenti_rekins_klienti` FOREIGN KEY (`klients_id`) REFERENCES `klienti` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci COMMENT='Rēķinu saraksts';

-- Dumping data for table lietvedibas_programma.dokumenti_rekins: ~1 rows (approximately)
INSERT INTO `dokumenti_rekins` (`id`, `klients_id`, `rekins_nr`, `izr_datums`, `apm_datums`, `pvn`, `piezimes`) VALUES
	(1, 1, '001', '2025-02-07', '2025-02-17', 21.00, 'Rēķins sagatavots elektroniski');

-- Dumping structure for table lietvedibas_programma.izmantotie_dok_nr
CREATE TABLE IF NOT EXISTS `izmantotie_dok_nr` (
  `dokumenta_nr` varchar(3) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT 'Izmantots rēķinu numurs',
  PRIMARY KEY (`dokumenta_nr`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci COMMENT='Izmantoto rēķinu numuru saraksts';

-- Dumping data for table lietvedibas_programma.izmantotie_dok_nr: ~1 rows (approximately)
INSERT INTO `izmantotie_dok_nr` (`dokumenta_nr`) VALUES
	('001');

-- Dumping structure for table lietvedibas_programma.klienti
CREATE TABLE IF NOT EXISTS `klienti` (
  `id` int NOT NULL AUTO_INCREMENT COMMENT 'Klienta unikāls identifikators',
  `nosaukums` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT 'Klienta nosaukums',
  `reg_nr` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT 'Reģistrācijas numurs',
  `pvn_reg_nr` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT 'PVN reģistrācijas numurs',
  `adrese_id` int NOT NULL COMMENT 'Klienta adreses identifikators',
  `banka_id` int NOT NULL COMMENT 'Klienta bankas identifikators',
  `banka_kods` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT 'Klienta bankas kods',
  `banka_nr` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT 'Klienta bankas numurs',
  PRIMARY KEY (`id`),
  KEY `FK_klienti_adreses` (`adrese_id`),
  KEY `FK_klienti_bankas` (`banka_id`),
  CONSTRAINT `FK_klienti_adreses` FOREIGN KEY (`adrese_id`) REFERENCES `adreses` (`id`),
  CONSTRAINT `FK_klienti_bankas` FOREIGN KEY (`banka_id`) REFERENCES `bankas` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci COMMENT='Klientu saraksts';

-- Dumping data for table lietvedibas_programma.klienti: ~1 rows (approximately)
INSERT INTO `klienti` (`id`, `nosaukums`, `reg_nr`, `pvn_reg_nr`, `adrese_id`, `banka_id`, `banka_kods`, `banka_nr`) VALUES
	(1, 'SIA Izdomāts Uzņēmums', '123456', '654321', 1, 1, '', '');

-- Dumping structure for table lietvedibas_programma.mervienibas
CREATE TABLE IF NOT EXISTS `mervienibas` (
  `id` int NOT NULL AUTO_INCREMENT COMMENT 'Mērvienības unikāls identifikators',
  `mervieniba` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT 'Mērvienības nosaukums',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci COMMENT='Mērvienību saraksts';

-- Dumping data for table lietvedibas_programma.mervienibas: ~3 rows (approximately)
INSERT INTO `mervienibas` (`id`, `mervieniba`) VALUES
	(1, 'gab.'),
	(2, '		m3'),
	(3, 'km');

/*!40103 SET TIME_ZONE=IFNULL(@OLD_TIME_ZONE, 'system') */;
/*!40101 SET SQL_MODE=IFNULL(@OLD_SQL_MODE, '') */;
/*!40014 SET FOREIGN_KEY_CHECKS=IFNULL(@OLD_FOREIGN_KEY_CHECKS, 1) */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40111 SET SQL_NOTES=IFNULL(@OLD_SQL_NOTES, 1) */;
