<?php
/**
* Autors: Roberts Saulītis
* Apraksts: Nepieciešamās darbības lai izveidotu jaunu rēķinu
*/
session_start();    //Uzsāk sesiju
require '../config/savienojums.php';  //Pievieno datubāzes savienojumu no savienojums.php faila

header('Content-Type: application/json');   //Datu tips - JSON

if ($_SERVER['REQUEST_METHOD'] === 'POST') {    //Ja servera metode ir POST, tad ievieto dokumentu datubāzē
    $klients_id = $_POST['klients_id'];
    $rekins_nr = $_POST['rekins_nr'];
    $izr_datums = $_POST['izr_datums'];
    $apm_datums = $_POST['apm_datums'];
    $pvn = $_POST['pvn'];
    $piezimes = $_POST['piezimes'];

    require '../app/inc/sql_izmantotie_nr.php';
    $vaicajums = $savienojums->prepare($vaic);
    $vaicajums->bind_param("s", $rekins_nr);
    $vaicajums->execute();

    require '../app/inc/sql_pievienot_rekinu.php';
    $vaicajums = $savienojums->prepare($vaic);
    $vaicajums->bind_param("sissds", $rekins_nr, $klients_id, $izr_datums, $apm_datums, $pvn, $piezimes);
    $vaicajums->execute();
    
    //SQL pieprasījums, kas ievāc dokumenta identifikatoru
    $tabulas_dati = $_POST['tabulas_dati'];
    require '../app/inc/sql_ievakt_rekina_id.php';
    $vaicajums = $savienojums->prepare($vaic);
    $vaicajums->bind_param("s", $rekins_nr);
    $vaicajums->execute();
    $rezultats = $vaicajums->get_result();
    $rinda = $rezultats->fetch_assoc();
    $rekins_id = $rinda['id'];

    foreach ($tabulas_dati as $row) {  //Dokumenta apmaksas datu rindu ievietošana masīvā
        require '../app/inc/sql_pievienot_apmaksas.php';
        $vaicajums = $savienojums->prepare($vaic);
        $vaicajums->bind_param("isiss", $rekins_id, $row['nosaukums'], $row['mervieniba_id'], $row['daudzums'], $row['cena']);
        $vaicajums->execute();
    }

    echo json_encode(['izdevies' => 'Dokuments pievienots!', 'stavoklis' => 'izdevies']);    //Paziņojums par dokumenta veiksmīgu pievienošanu
}

?>