<?php
/**
* Autors: Roberts Saulītis
* Apraksts: Nepieciešamās darbības lai izveidotu jaunu klientu
*/
require '../config/savienojums.php';  //Pievieno datubāzes savienojumu no savienojums.php faila

if ($_SERVER['REQUEST_METHOD'] == 'POST') { //Ja servera metode ir POST, tad ievieto nosūtītos datus mainīgajos
    $klienta_nosaukums = $_POST['klienta_nosaukums'];
    $reg_num = $_POST['reg_num'];
    $pvn_num = $_POST['pvn_num'];
    $adrese = $_POST['adrese'];
    $bankas_nosauk = $_POST['bankas_nosauk'];
    $bankas_kods = $_POST['bankas_kods'];
    $bankas_num = $_POST['bankas_num'];
    
    require '../app/inc/sql_parbaudit_banku.php';
    $vaicajums = $savienojums->prepare($vaic); //Pieprasījums, kas saņem bankas identifikatoru pēc bankas nosaukuma
    $vaicajums->bind_param('s', $bankas_nosauk);
    $vaicajums->execute();
    $resultats = $vaicajums->get_result();

    if ($resultats->num_rows > 0) { //Ja banka ir datubāzē, tad pievieno noteiktajam klientam bankas identifikatoru
        $rinda = $resultats->fetch_assoc();
        $bankasId = $rinda['id'];
    } else {    //Ievieto kā jaunu banku, un pievieno noteiktajam klientam bankas identifikatoru
        require '../app/inc/sql_pievienot_banku.php';
        $vaicajums = $savienojums->prepare($vaic); 
        $vaicajums->bind_param('s', $bankas_nosauk);
        $vaicajums->execute();
        $bankasId = $vaicajums->insert_id;
    }
    require '../app/inc/sql_parbaudit_adresi.php';
    $vaicajums = $savienojums->prepare($vaic);   //Pieprasījums, kas saņem identifikatoru pēc noteiktas adreses
    $vaicajums->bind_param('s', $adrese);
    $vaicajums->execute();
    $resultats = $vaicajums->get_result();

    if ($resultats->num_rows > 0) { //Ja adrese ir datubāzē, tad pievieno noteiktajam klientam adreses identifikatoru
        $rinda = $resultats->fetch_assoc();
        $adresesId = $rinda['id'];
    } else {    //Ievieto kā jaunu adresi, un pievieno noteiktajam klientam adreses identifikatoru
        require '../app/inc/sql_pievienot_adresi.php';
        $vaicajums = $savienojums->prepare($vaic);   
        $vaicajums->bind_param('s', $adrese);
        $vaicajums->execute();
        $adresesId = $vaicajums->insert_id;
    }

    require '../app/inc/sql_pievienot_klientu.php';
    $vaicajums = $savienojums->prepare($vaic);   //Ievieto visus lietotāja ievadītos klienta datus datubāzē
    $vaicajums->bind_param('sssiiss', $klienta_nosaukums, $reg_num, $pvn_num, $adresesId, $bankasId, $bankas_kods, $bankas_num);

    if ($vaicajums->execute()) { //Paziņojums par veiksmīgu pievienošanu
        echo json_encode(['stavoklis' => 'izdevies', 'ziņa' => 'Klients pievienots veiksmīgi.']);
    } else {    //Paziņojums par neizdevušos pievienošanu
        echo json_encode(['stavoklis' => 'kļūda', 'ziņa' => 'Neizdevās pievienot klientu.']);
    }
}
