<?php
/**
* Autors: Roberts Saulītis
* Apraksts: Nepieciešamās darbības lai ievāktu galvenās (index) lapas tabulu datus
*/
session_start();    //Uzsāk sesiju
header('Content-Type: application/json');
require '../config/savienojums.php';  //Pievieno datubāzes savienojumu no savienojums.php faila

if ($_SERVER['REQUEST_METHOD'] === 'GET') { //Pārbauda, vai servera iesniegšanas metode ir POST
    $rekini = [];
    require '../app/inc/sql_ievakt_rekinus.php'; //SQL pieprasījums, kas ievāc datus par rēķiniem
    $rekinuRezultats = $savienojums->query($vaic);
    if ($rekinuRezultats->num_rows > 0) {    //Ja rēķini eksistē, tad papildina masīvu ar rekinu datiem
        while ($rinda = $rekinuRezultats->fetch_assoc()) {   //Papildina masīvu ar rekinu datiem
            $rekini[] = $rinda;
        }
    }
    $klienti = [];
    require '../app/inc/sql_ievakt_klientus.php'; //SQL pieprasījums, kas ievāc datus par klientiem
    $klientuRezultats = $savienojums->query($vaic);
    if ($klientuRezultats->num_rows > 0) {    //Ja klienti eksistē, tad papildina masīvu ar klientu datiem
        while ($rinda = $klientuRezultats->fetch_assoc()) { //Papildina masīvu ar klientu datiem
            $klienti[] = $rinda;
        }
    }
    echo json_encode([  //Atgriež lietotājam datus
        'stavoklis' => 'izdevies',
        'rekini' => $rekini,
        'klienti' => $klienti
    ]);
    exit;
}
?>
