/**
* Autors: Roberts Saulītis
* Apraksts: Funkcijas priekš galvenās (index) lapas
*/
document.addEventListener("DOMContentLoaded", function () { //Funkcijas, kuras izpildās ar lapas ielādi
    atjaunotLaiku();
    ievaktTabuluDatus();
});

function kopetKlientu(klienta_id) {  //Esoša klienta kopēšana
    $.ajax({    //Klienta datu kopēšanai nepieciešamo datu iegūšana
        url: '../app/rediget_klientu.php',
        method: 'GET',
        data: { id: klienta_id },
        dataType: 'json',
        success: function (klients) {    //Klienta datu saņēmšana
            Swal.fire({ //Klienta datu ievietošana formā
                title: 'Kopēt klientu',
                html: `
                    <input type="text" id="klienta_nosaukums" class="swal2-input sweetalert-ievades" placeholder="Klients" value="${klients.data.klienta_nosaukums}"><span class="zvaigzne">*</span>
                    <input type="text" id="reg_num" class="swal2-input sweetalert-ievades" placeholder="Reģistrācijas numurs" value="${klients.data.reg_num}"><span class="zvaigzne">*</span>
                    <input type="text" id="pvn_num" class="swal2-input sweetalert-ievades" placeholder="PVN reģistrācijas numurs" value="${klients.data.pvn_num}"><span class="zvaigzne">*</span>
                    <input type="text" id="adrese" class="swal2-input sweetalert-ievades" placeholder="Juridiskā adrese" value="${klients.data.adrese}"><span class="zvaigzne">*</span>
                    <input type="text" id="bankas_nosauk" class="swal2-input sweetalert-ievades" placeholder="Banka" value="${klients.data.bankas_nosauk}">
                    <input type="text" id="bankas_kods" class="swal2-input sweetalert-ievades" placeholder="Bankas kods" value="${klients.data.bankas_kods}">
                    <input type="text" id="bankas_num" class="swal2-input sweetalert-ievades" placeholder="Bankas konta numurs" value="${klients.data.bankas_num}">
                `,
                focusConfirm: false,
                preConfirm: () => { //Klienta informācijas saglabāšana
                    const klienta_nosaukums = $('#klienta_nosaukums').val();
                    const reg_num = $('#reg_num').val();
                    const pvn_num = $('#pvn_num').val();
                    const adrese = $('#adrese').val();
                    const bankas_nosauk = $('#bankas_nosauk').val();
                    const bankas_kods = $('#bankas_kods').val();
                    const bankas_num = $('#bankas_num').val();

                    let errors = [];
                    if (!klienta_nosaukums) { errors.push('Klienta nosaukums ir obligāts!'); }
                    if (!reg_num) { errors.push('Reģistrācijas numurs ir obligāts!'); }
                    if (!pvn_num) { errors.push('PVN reģistrācijas numurs ir obligāts!'); }
                    if (!adrese) { errors.push('Juridiskā adrese ir obligāta!'); }

                    if (errors.length > 0) {
                        Swal.showValidationMessage(errors.join('<br>'));
                        return;
                    }
                    
                    return { klienta_id, klienta_nosaukums, reg_num, pvn_num, bankas_nosauk, bankas_kods, bankas_num, adrese };    //Klienta datu objekts
                }
            }).then((resultats) => {    //Klienta datu pievienošana pēc pogas "Saglabāt" nospiešanas
                if (resultats.isConfirmed) {
                    $.ajax({    //Klienta datu nosūtīšana datubāzei
                        url: '../app/pievienot_klientu.php',
                        type: 'POST',
                        data: resultats.value,
                        success: function (response) {  //Paziņojums, ja dati veiksmīgi pievienoti
                            Swal.fire('Veiksmīgi!', 'Jauns klients pievienots veiksmīgi!', 'success');
                            ievaktTabuluDatus();
                        },
                        error: function (xhr, stavoklis, error) {  //Paziņojums, ja datus neizdevās pievienot
                            Swal.fire('Error', 'Neizdevās pievienot klientu.', 'error');
                        }
                    });
                }
            });
        },
        error: function (xhr, stavoklis, error) {    //Klienta datu iegūšanas kļūda
            Swal.fire('Error', 'Neizdevās iegūt klienta datus.', 'error');
        }
    });
}

function dzestKlientu(klienta_id, klienta_nosaukums) {  // Klienta datu dzēšana
    Swal.fire({  // Klienta datu dzēšanas pārliecināšanās
        title: 'Dzēšot klientu ' + klienta_nosaukums + ', jūs dzēsīsiet arī visus klientam saistītos rēķinus. Vai esat pārliecināts?',
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#d33',
        cancelButtonColor: '#3085d6',
        confirmButtonText: 'Jā',
        cancelButtonText: 'Nē'
    }).then((resultats) => {  // Klienta datu dzēšanas apstiprināšana
        if (resultats.isConfirmed) {  // Klienta datu dzēšana, ja lietotājs apstiprina
            $.ajax({  // Klienta datu dzēšana no datubāzes
                url: '../app/dzest_klientu.php',  
                type: 'POST',  
                data: { id: klienta_id },  
                success: function (atbilde) {  // Ja dzēšana veikta veiksmīgi, tad paziņojums par to
                    var atbilde = JSON.parse(atbilde);  
                    if (atbilde.stavoklis === 'izdevies') {  // Datu dzēšanas izdošanās
                        Swal.fire('Dzēsts!', 'Klients ir veiksmīgi dzēsts.', 'success');  
                        ievaktTabuluDatus();  // Klientu tabulas atjaunināšana
                    } else {  // Datu dzēšanas kļūda
                        Swal.fire('Kļūda!', atbilde.zinojums, 'error');  
                    }
                },
                error: function (xhr, stavoklis, error) {  // Klienta datu dzēšanas kļūda
                    Swal.fire('Kļūda!', 'Neizdevās dzēst klientu.', 'error');  
                }
            });
        }
    });
}

function redigetKlientu(klienta_id) {    //Klienta datu rediģēšana
    $.ajax({    //Klienta datu ievākšana rediģēšanai
        url: '../app/rediget_klientu.php',    //Servera skripts datu iegūšanai
        method: 'GET',    //Metode - GET
        data: { id: klienta_id },    //Nosūtam klienta ID kā parametrs
        dataType: 'json',    //Sagaidām JSON formāta atbildi
        success: function (klients) {    //Funkcija, kas izpildās, ja dati veiksmīgi iegūti
            Swal.fire({ //Parāda modālo logu klienta datu rediģēšanai
                title: 'Rediģēt klientu',    //Loga virsraksts
                html: `
                    <input type="text" id="klienta_nosaukums" class="swal2-input sweetalert-ievades" placeholder="Klients" value="${klients.data.klienta_nosaukums}"><span class="zvaigzne">*</span>
                    <input type="text" id="reg_num" class="swal2-input sweetalert-ievades" placeholder="Reģistrācijas numurs" value="${klients.data.reg_num}"><span class="zvaigzne">*</span>
                    <input type="text" id="pvn_num" class="swal2-input sweetalert-ievades" placeholder="PVN reģistrācijas numurs" value="${klients.data.pvn_num}"><span class="zvaigzne">*</span>
                    <input type="text" id="adrese" class="swal2-input sweetalert-ievades" placeholder="Juridiskā adrese" value="${klients.data.adrese}"><span class="zvaigzne">*</span>
                    <input type="text" id="bankas_nosauk" class="swal2-input sweetalert-ievades" placeholder="Banka" value="${klients.data.bankas_nosauk}">
                    <input type="text" id="bankas_kods" class="swal2-input sweetalert-ievades" placeholder="Bankas kods" value="${klients.data.bankas_kods}">
                    <input type="text" id="bankas_num" class="swal2-input sweetalert-ievades" placeholder="Bankas konta numurs" value="${klients.data.bankas_num}">
                `,
                focusConfirm: false,    //Neuzstāda fokusu uz "Saglabāt" pogu automātiski
                preConfirm: () => { //Funkcija, kas izpildās pirms "Saglabāt" pogas nospiešanas
                    const klienta_nosaukums = $('#klienta_nosaukums').val();    //Iegūst klienta nosaukumu
                    const reg_num = $('#reg_num').val();    //Iegūst reģistrācijas numuru
                    const pvn_num = $('#pvn_num').val();    //Iegūst PVN numuru
                    const adrese = $('#adrese').val();    //Iegūst juridisko adresi
                    const bankas_nosauk = $('#bankas_nosauk').val();    //Iegūst bankas nosaukumu
                    const bankas_kods = $('#bankas_kods').val();    //Iegūst bankas kodu
                    const bankas_num = $('#bankas_num').val();    //Iegūst bankas konta numuru

                    let errors = [];
                    if (!klienta_nosaukums) { errors.push('Klienta nosaukums ir obligāts!'); }
                    if (!reg_num) { errors.push('Reģistrācijas numurs ir obligāts!'); }
                    if (!pvn_num) { errors.push('PVN reģistrācijas numurs ir obligāts!'); }
                    if (!adrese) { errors.push('Juridiskā adrese ir obligāta!'); }
                    if (errors.length > 0) {
                        Swal.showValidationMessage(errors.join('<br>'));
                        return;
                    }
                    
                    return { klienta_id, klienta_nosaukums, reg_num, pvn_num, bankas_nosauk, bankas_kods, bankas_num, adrese };    //Atgriež objektu ar ievadītajiem datiem
                }
            }).then((resultats) => {    //Funkcija, kas izpildās pēc "Saglabāt" pogas nospiešanas
                if (resultats.isConfirmed) {    //Pārbauda, vai lietotājs ir apstiprinājis datu rediģēšanu
                    $.ajax({    //Veic AJAX pieprasījumu klienta datu atjaunināšanai
                        url: '../app/rediget_klientu.php',    //Servera skripts datu atjaunināšanai
                        type: 'POST',    //Metode - POST
                        data: resultats.value,    //Nosūtam iegūtos datus
                        success: function () {    //Funkcija, kas izpildās, ja dati veiksmīgi atjaunināti
                            Swal.fire('Saglabāts!', 'Klienta dati veiksmīgi atjaunināti.', 'success');    //Parāda paziņojumu par veiksmīgu atjaunināšanu
                            ievaktTabuluDatus();    //Atjaunina klientu sarakstu tabulā
                        },
                        error: function (xhr, stavoklis, error) {  //Funkcija, kas izpildās, ja rodas kļūda atjaunināšanas laikā
                            Swal.fire('Kļūda!', 'Neizdevās atjaunināt klienta datus.', 'error');    //Parāda kļūdas paziņojumu
                        }
                    });
                }
            });
        },
        error: function (xhr, stavoklis, error) {    //Funkcija, kas izpildās, ja klienta datu iegūšana neizdodas
            Swal.fire('Error', 'Neizdevās iegūt klienta datus.', 'error');    //Parāda kļūdas paziņojumu
        }
    });
}

function redigetRekinu(rekins_id, veids) {    //rēķinu datu rediģēšana
    window.location.href = "./rekinu_lapa.php?id=" + rekins_id + "&veids=" + veids;    //Aizvirza uz rēķinu veidošanas lapu, pievienojot izvēlētā rēķina identifikatoru
};

function dzestRekinu(rekins_id, rekins_nr) {    //rēķinu datu dzēšana
    Swal.fire({    //rēķina datu dzēšanas pārliecināšanās
        title: 'Vai tiešām vēlaties dzēst rēķinu Nr.' + rekins_nr + '?',
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#d33',
        cancelButtonColor: '#3085d6',
        confirmButtonText: 'Jā',
        cancelButtonText: 'Nē'
    }).then((resultats) => {    //rēķina datu dzēšanas funkcija
        if (resultats.isConfirmed) {    //rēķina datu dzēšanas, ja lietotājs apstiprina
            $.ajax({    //rēķina datu dzēšana no datubāzes
                type: 'POST',
                url: '../app/dzest_rekinu.php',
                data: { id: rekins_id },
                success: function () {    //rēķina datu pievienošanas funkcija
                    Swal.fire('Dzēsts!', 'Rēķins veiksmīgi dzēsts.', 'success');
                    ievaktTabuluDatus();
                },
                error: function () {
                    ievaktTabuluDatus();
                    Swal.fire('Kļūda!', 'Neizdevās dzēst rēķinu.', 'error');    //Paziņojums par rēķina neveiksmīgu pievienošanu
                }
            });
        }
    });
}

function lejupieladetRekinu(id) {
    $.ajax({
        url: '../app/lejupieladet_rekinu.php',//Aizsūta pieprasījums uz servera skriptu
        type: 'GET',//Metode GET
        data: { rekins_id: id },//Nosūta rēķina ID uz serveri
        success: function (dati) {//Ja saņemam datus no servera, turpina izpildi
            nosutitajs = { //Definē nosūtītāja datus
                vards: 'SIA LogTrade Services',//Nosūtītāja nosaukums
                reg_nr: '1122334455',//Reģistrācijas numurs
                pvn_reg_nr: 'LV0123456789',//PVN reģistrācijas numurs
                adrese: 'Izdomātā iela 123A, Jelgava, LV-3001',//Juridiskā adrese
                banka: 'SEB banka',//Banka
                banka_kods: 'EDCBA1234',//Bankas kods
                banka_nr: 'LV123DCBA456789'//Bankas konta numurs
            };
            const darbagramata = new ExcelJS.Workbook();//Izveido jaunu Excel darba grāmatu
            const darbalapa = darbagramata.addWorksheet('rekins - ' + dati.rekins_nr);//Pievieno jaunu lapu ar rēķina numuru

            for (let rinda = 1; rinda <= 50; rinda++) { //Cikls, lai iestatītu 50 rindu augstumu un fonta stilu
                darbalapa.getRow(rinda).height = 20;//Iestata rindu augstumu
                for (let kolonna = 1; kolonna <= 9; kolonna++) { //Cikls caur 9 kolonnām
                    darbalapa.getCell(rinda, kolonna).font = { //Iestata fonta īpašības katrai šūnai
                        name: 'Times New Roman',//Fonta nosaukums
                        size: 11,//Fonta lielums
                        bold: false,//Nav treknrakstā
                        italic: false,//Nav slīprakstā
                    };
                }
            }

            //Iestata kolonu platumus
            darbalapa.columns = [
                { width: 12 },//Kolonna A
                { width: 11.5 },//Kolonna B
                { width: 8.5 },//Kolonna C
                { width: 8.5 },//Kolonna D
                { width: 7 },//Kolonna E
                { width: 8.5 },//Kolonna F
                { width: 10 },//Kolonna G
                { width: 9 },//Kolonna H
                { width: 12 },//Kolonna I
            ];

            const videja_apmale = { //Definē vidēja biezuma apmales stilu
                top: { style: 'medium' },//Augšējā mala
                left: { style: 'medium' },//Kreisā mala
                bottom: { style: 'medium' },//Apakšējā mala
                right: { style: 'medium' },//Labā mala
            };

            //Header (Rēķina numura attēlošana)
            const galvene_rekins = darbalapa.getCell('H1');//Atlasīt šūnu H1
            const galvene_rekina_nr = darbalapa.getCell('I1');//Atlasīt šūnu I1
            galvene_rekins.value = 'Reķins Nr: '; //Iestata tekstu šūnā H1
            galvene_rekins.font = { size: 14, bold: true, name: 'Times New Roman' };//Iestata fonta īpašības
            galvene_rekina_nr.value = `${dati.rekins_nr}`;//Iestata rēķina numuru šūnā I1
            galvene_rekina_nr.font = { size: 14, bold: true, name: 'Times New Roman' };//Iestata fonta īpašības
            galvene_rekins.alignment = { wrapText: false, horizontal: 'right' };//Iestata šūnas izkārtojumu
            galvene_rekina_nr.alignment = { wrapText: false, horizontal: 'left' };//Iestata šūnas izkārtojumu

            //Issue Date (Izrakstīšanas datuma attēlošana)
            darbalapa.getCell('A1').value = dati.izr_datums;//Iestata izrakstīšanas datumu šūnā A1
            darbalapa.getCell('A1').alignment = { wrapText: false, horizontal: 'left' };//Iestata šūnas izkārtojumu
            darbalapa.getCell('A1').font = { size: 14, bold: true, name: 'Times New Roman' };//Iestata fonta īpašības

            //Funkcija, lai pievienotu apakšējās malas starp noteiktām šūnām
            function pievienotApaksasApmali(sakuma_rinda, beigu_rinda, sakuma_kolonna, beigu_kolonna, izmers) {
                for (let rinda = sakuma_rinda; rinda <= beigu_rinda; rinda++) { //Cikls caur rindu skaitu
                    for (let kolonna = sakuma_kolonna; kolonna <= beigu_kolonna; kolonna++) { //Cikls caur kolonnām
                        darbalapa.getCell(rinda, kolonna).border = { //Iestata apakšējo apmali
                            bottom: { style: izmers },//Apmales biezums
                        };
                    }
                }
            }

            //Sender Section (Nosūtītāja sadaļa)
            darbalapa.mergeCells('A3:I3');//Apvieno šūnas no A3 līdz I3
            const galvene_nosutitajs = darbalapa.getCell('A3');//Atlasīt apvienoto šūnu
            galvene_nosutitajs.value = 'Nosūtītājs:';//Iestata sadaļas nosaukumu
            galvene_nosutitajs.font = { bold: true, size: 14, name: 'Times New Roman' };//Iestata fonta īpašības
            galvene_nosutitajs.fill = { //Iestata aizpildījuma krāsu
                type: 'pattern',//Tipa definīcija
                pattern: 'solid',//Ciets aizpildījums
                fgColor: { argb: 'D9D9D9' },//Aizpildījuma krāsa
            };
            galvene_nosutitajs.border = videja_apmale;//Pievieno apmales

            darbalapa.getCell('A4').value = nosutitajs.vards;//Iestata nosūtītāja vārdu šūnā A4
            darbalapa.getCell('A4').font = { bold: true, name: 'Times New Roman' };//Iestata fonta īpašības
            darbalapa.getCell('D4').value = `Reģ.Nr:` + nosutitajs.reg_nr;//Iestata reģistrācijas numuru šūnā D4
            darbalapa.getCell('D4').font = { bold: true, name: 'Times New Roman' };//Iestata fonta īpašības
            darbalapa.getCell('I4').value = `PVN reģ.Nr:` + nosutitajs.pvn_reg_nr;//Iestata PVN reģistrācijas numuru šūnā I4
            darbalapa.getCell('I4').font = { bold: true, name: 'Times New Roman' };//Iestata fonta īpašības
            darbalapa.getCell('I4').alignment = { wrapText: false, horizontal: 'right' };//Iestata šūnas izkārtojumu
            darbalapa.getCell('A5').value = 'Juridiskā adrese:';//Iestata etiķeti juridiskai adresei šūnā A5
            darbalapa.getCell('D5').value = nosutitajs.adrese;//Iestata nosūtītāja adresi šūnā D5
            darbalapa.getCell('A6').value = 'Banka:';//Iestata etiķeti bankai šūnā A6
            darbalapa.getCell('B6').value = nosutitajs.banka;//Iestata bankas nosaukumu šūnā B6
            darbalapa.getCell('B6').font = { bold: true, name: 'Times New Roman' };//Iestata fonta īpašības
            darbalapa.getCell('D6').value = `Kods: ` + nosutitajs.banka_kods;//Iestata bankas kodu šūnā D6
            darbalapa.getCell('I6').value = `Konts: ` + nosutitajs.banka_nr;//Iestata bankas konta numuru šūnā I6
            darbalapa.getCell('A7').value = `Izsniegšanas adrese: `;//Iestata etiķeti izsniegšanas adresei šūnā A7
            darbalapa.getCell('D7').value = nosutitajs.adrese;//Iestata izsniegšanas adresi šūnā D7
            darbalapa.getCell('D7').alignment = { wrapText: false };//Iestata šūnas izkārtojumu
            darbalapa.getCell('I6').alignment = { wrapText: false, horizontal: 'right' };//Iestata šūnas izkārtojumu
            pievienotApaksasApmali(4, 6, 1, 9, 'thin');//Pievieno apakšējo apmali sadaļā
            pievienotApaksasApmali(9, 11, 1, 9, 'thin');//Pievieno apakšējo apmali sadaļā

            //Receiver Section (Saņēmēja sadaļa)
            darbalapa.mergeCells('A8:I8');//Apvieno šūnas no A8 līdz I8
            const galvene_sanemejs = darbalapa.getCell('A8');//Atlasīt apvienoto šūnu
            galvene_sanemejs.value = 'Saņēmējs:';//Iestata sadaļas nosaukumu
            galvene_sanemejs.font = { bold: true, size: 14, name: 'Times New Roman' };//Iestata fonta īpašības
            galvene_sanemejs.fill = { //Iestata aizpildījuma krāsu
                type: 'pattern',//Tipa definīcija
                pattern: 'solid',//Ciets aizpildījums
                fgColor: { argb: 'D9D9D9' },//Aizpildījuma krāsa
            };
            galvene_sanemejs.border = videja_apmale;//Pievieno apmales

            darbalapa.getCell('A9').value = dati.klients.nosaukums;//Iestata saņēmēja nosaukumu šūnā A9
            darbalapa.getCell('A9').font = { bold: true, name: 'Times New Roman' };//Iestata fonta īpašības
            darbalapa.getCell('D9').value = `Reģ.Nr:${dati.klients.reg_nr}`;//Iestata reģistrācijas numuru šūnā D9
            darbalapa.getCell('D9').font = { bold: true, name: 'Times New Roman' };//Iestata fonta īpašības
            darbalapa.getCell('I9').value = `PVN reģ.Nr:${dati.klients.pvn_reg_nr}`;//Iestata PVN reģistrācijas numuru šūnā I9
            darbalapa.getCell('I9').font = { bold: true, name: 'Times New Roman' };//Iestata fonta īpašības
            darbalapa.getCell('I9').alignment = { wrapText: false, horizontal: 'right' };//Iestata šūnas izkārtojumu
            darbalapa.getCell('A10').value = 'Juridiskā adrese:';//Iestata etiķeti juridiskai adresei šūnā A10
            darbalapa.getCell('D10').value = `${dati.klients.adrese}`;//Iestata saņēmēja adresi šūnā D10

            darbalapa.getCell('A11').value = 'Banka:';//Iestata etiķeti bankai šūnā A11
            darbalapa.getCell('B11').value = `${dati.klients.banka}`;//Iestata saņēmēja bankas nosaukumu šūnā B11
            darbalapa.getCell('B11').font = { bold: true, name: 'Times New Roman' };//Iestata fonta īpašības
            darbalapa.getCell('D11').value = `Kods: ${dati.klients.banka_kods}`;//Iestata bankas kodu šūnā D11
            darbalapa.getCell('I11').value = `Konts: ${dati.klients.banka_nr}`;//Iestata bankas konta numuru šūnā I11
            darbalapa.getCell('A12').value = `Izsniegšanas adrese: `;//Iestata etiķeti izsniegšanas adresei šūnā A12
            darbalapa.getCell('D12').value = nosutitajs.adrese;//Iestata izsniegšanas adresi šūnā D12
            darbalapa.getCell('D12').alignment = { wrapText: false };//Iestata šūnas izkārtojumu
            darbalapa.getCell('I11').alignment = { wrapText: false, horizontal: 'right' };//Iestata šūnas izkārtojumu

            //Payment Details Section (Maksājuma detaļas)
            darbalapa.getCell('A13').value = 'Samaksas veids un kārtība:';//Iestata etiķeti maksājuma veidam šūnā A13
            darbalapa.getCell('C13').value = 'ar pārskaitījumu';//Iestata maksājuma veidu šūnā C13
            let izr_datums = new Date(dati.izr_datums);//Pārvērš izrakstīšanas datumu par datuma objektu
            let apm_datums = new Date(dati.apm_datums);//Pārvērš apmaksas datumu par datuma objektu
            let termins = Math.ceil((apm_datums - izr_datums) / (1000 * 60 * 60 * 24));//Aprēķina termiņu dienās
            darbalapa.getCell('E13').value = `__${termins}__ dienas/u laikā vai līguma noteiktajā termiņā`;//Iestata termiņu šūnā E13
            darbalapa.getCell('B13').font = { bold: true };//Iestata treknrakstu šūnā B13
            darbalapa.getCell('B13').alignment = { horizontal: 'left' };//Iestata šūnas izkārtojumu
            darbalapa.getCell('C13').alignment = { horizontal: 'left' };//Iestata šūnas izkārtojumu
            darbalapa.getCell('E13').alignment = { horizontal: 'left' };//Iestata šūnas izkārtojumu
            pievienotApaksasApmali(12, 12, 1, 9, 'medium');//Pievieno apakšmalu šūnām rindā 12
            pievienotApaksasApmali(14, 14, 1, 9, 'medium');//Pievieno apakšmalu šūnām rindā 14

            //Itemized Table Header (Preču tabulas galvene)
            darbalapa.mergeCells('A15:E16');//Apvieno šūnas no A15 līdz E16
            darbalapa.getCell('A15').alignment = { vertical: 'middle' };//Centrē saturu vertikāli šūnā A15
            darbalapa.mergeCells('F15:F16');//Apvieno šūnas F15 un F16
            darbalapa.getCell('F15').alignment = { horizontal: 'center', vertical: 'middle', wrapText: true };//Centrē saturu šūnā F15
            darbalapa.mergeCells('G15:G16');//Apvieno šūnas G15 un G16
            darbalapa.getCell('G15').alignment = { horizontal: 'center', vertical: 'middle', wrapText: true };//Centrē saturu šūnā G15
            darbalapa.mergeCells('H15:H16');//Apvieno šūnas H15 un H16
            darbalapa.getCell('H15').alignment = { horizontal: 'center', vertical: 'middle', wrapText: true };//Centrē saturu šūnā H15
            darbalapa.mergeCells('I15:I16');//Apvieno šūnas I15 un I16
            darbalapa.getCell('I15').alignment = { horizontal: 'center', vertical: 'middle', wrapText: true };//Centrē saturu šūnā I15
            darbalapa.getCell('A15').value = 'Nosaukums';//Iestata kolonnu virsrakstu
            darbalapa.getCell('A15').font = { bold: true, name: "Times New Roman", size: 14 };//Iestata fonta īpašības
            darbalapa.getCell('F15').value = 'Mērv.';//Iestata kolonnu virsrakstu
            darbalapa.getCell('G15').value = 'Pieņemtais daudzums';//Iestata kolonnu virsrakstu
            darbalapa.getCell('H15').value = 'Cena bez PVN';//Iestata kolonnu virsrakstu
            darbalapa.getCell('I15').value = 'Summa';//Iestata kolonnu virsrakstu

            var apmaksai = 0;//Inicializē mainīgo kopējai summai
            var apmaksai_pvn = 0;//Inicializē mainīgo kopējam PVN
            let rinda = 17;//Sākuma rinda preču sarakstam
            dati.apmaksa.forEach(payment => { //Cikls caur katru maksājuma ierakstu
                darbalapa.mergeCells(`A${rinda}:E${rinda}`);//Apvieno šūnas, lai ievietotu preces nosaukumu
                darbalapa.getCell(`A${rinda}`).value = payment.nosaukums;//Iestata preces nosaukumu
                darbalapa.getCell(`A${rinda}`).alignment = { horizontal: 'left', vertical: 'middle', wrapText: true };//Iestata izkārtojumu
                darbalapa.getRow(rinda).height = 40;//Iestata rindas augstumu
                darbalapa.getCell(`F${rinda}`).value = payment.mervienibas_nosaukums;//Iestata mērvienību nosaukumu
                darbalapa.getCell(`F${rinda}`).alignment = { horizontal: 'center', vertical: 'middle', wrapText: true };//Centrē saturu šūnā F
                darbalapa.getCell(`G${rinda}`).value = payment.daudzums.replace(".", ",");//Iestata daudzumu, aizvietojot punktu ar komatu
                darbalapa.getCell(`G${rinda}`).alignment = { horizontal: 'center', vertical: 'middle', wrapText: true };//Centrē saturu šūnā G
                darbalapa.getCell(`H${rinda}`).value = payment.cena.replace(".", ",");//Iestata cenu, aizvietojot punktu ar komatu
                darbalapa.getCell(`H${rinda}`).alignment = { horizontal: 'center', vertical: 'middle', wrapText: true };//Centrē saturu šūnā H
                summa = payment.cena * payment.daudzums;//Aprēķina rindu summu
                darbalapa.getCell(`I${rinda}`).value = summa;//Iestata rindu summu šūnā I
                darbalapa.getCell(`I${rinda}`).alignment = { horizontal: 'center', vertical: 'middle', wrapText: true };//Centrē saturu šūnā I
                darbalapa.getCell(`I${rinda}`).numFmt = '0.00';//Iestata formātu summas attēlošanai
                apmaksai_pvn = apmaksai_pvn + (summa * (dati.pvn / 100));
                apmaksai = apmaksai + summa + (summa * (dati.pvn / 100));//Kopā pievieno cenu ar PVN
                rinda++;//Pāriet uz nākamo rindu
            });

            darbalapa.mergeCells(`A${rinda}:E${rinda}`);//Apvieno šūnas rindas beigās priekš PVN etiķetes
            darbalapa.getCell(`A${rinda}`).value = 'PVN:';//Iestata tekstu "PVN:"
            darbalapa.getCell(`A${rinda}`).alignment = { horizontal: 'right' };//Centrē tekstu pa labi
            darbalapa.getCell(`A${rinda}`).font = { bold: true, name: "Times New Roman" };//Iestata fonta īpašības
            darbalapa.getCell(`I${rinda}`).value = apmaksai_pvn;//Iestata kopējo PVN šūnā
            darbalapa.getCell(`I${rinda}`).numFmt = '0.00';//Iestata formātu PVN attēlošanai
            rinda++;//Pāriet uz nākamo rindu
            darbalapa.mergeCells(`A${rinda}:E${rinda}`);//Apvieno šūnas rindas beigās priekš kopējās summas etiķetes
            darbalapa.getCell(`A${rinda}`).value = 'Kopā:';//Iestata tekstu "Kopā:"
            darbalapa.getCell(`A${rinda}`).alignment = { horizontal: 'right' };//Centrē tekstu pa labi
            darbalapa.getCell(`A${rinda}`).font = { bold: true, name: "Times New Roman" };//Iestata fonta īpašības
            darbalapa.getCell(`I${rinda}`).value = apmaksai;//Iestata kopējo summu šūnā I
            darbalapa.getCell(`I${rinda}`).numFmt = '0.00';//Iestata formātu kopējai summai

            //Funkcija, lai pievienotu apmales ap tabulas šūnām
            function tabulas_apmale(sakuma_rinda, beigu_rinda, sakuma_kolonna, beigu_kolonna) {
                for (let rinda = sakuma_rinda; rinda <= beigu_rinda; rinda++) { //Cikls caur visām rindām tabulā
                    for (let kolonna = sakuma_kolonna; kolonna <= beigu_kolonna; kolonna++) { //Cikls caur visām kolonnām tabulā
                        darbalapa.getCell(rinda, kolonna).border = { //Iestata visas apmales
                            bottom: { style: 'thin' },
                            top: { style: 'thin' },
                            left: { style: 'thin' },
                            right: { style: 'thin' }
                        };
                    }
                }
            }
            tabulas_apmale(15, rinda, 1, 9);//Pievieno apmales visai preču tabulai

            darbalapa.mergeCells(`A${rinda + 1}:I${rinda + 1}`);//Apvieno šūnas komentāru ierakstīšanai
            darbalapa.getCell(`A${rinda + 1}`).value = dati.piezimes;//Iestata komentārus šūnā
            darbalapa.getCell(`A${rinda + 1}`).font = { italic: true, name: "Times New Roman" };//Iestata slīpraksta fontu komentāriem
            darbalapa.getCell(`A${rinda + 1}`).alignment = { horizontal: 'left', wrapText: true };//Nodrošina, ka summa tiek pareizi attēlota
            darbalapa.getCell(`A${rinda + 2}`).value = 'Summa apmaksai ar vārdiem:';//Iestata etiķeti summai vārdiem
            darbalapa.getCell(`D${rinda + 2}`).value = cenaVardos(apmaksai);//Iestata kopējo summu vārdiem šūnā D
            darbalapa.getCell(`D${rinda + 2}`).font = { bold: true, name: "Times New Roman" };//Iestata fonta īpašības

            darbalapa.getCell(`A${rinda + 4}`).value = 'Izsniedza:';//Iestata etiķeti izsniegšanas sadaļai
            darbalapa.getCell(`A${rinda + 5}`).value = 'Vārds, uzvārds:';//Iestata vietu vārda un uzvārda ierakstam
            darbalapa.getCell(`C${rinda + 5}`).value = '_______________________';//Ievieto zīmēšanas līniju
            darbalapa.getCell(`F${rinda + 5}`).value = 'Paraksts:';//Iestata etiķeti parakstam
            darbalapa.getCell(`G${rinda + 5}`).value = '_______________________';//Ievieto zīmēšanas līniju parakstam

            //Funkcija, kas pārveido skaitli par vārdiem (Eiro un centi)
            function cenaVardos(skaitlis) {
                if (typeof skaitlis === "string") {
                    skaitlis = parseFloat(skaitlis.replace(",", "."));//Pārvērš tekstu par skaitli, aizvietojot komatu ar punktu
                }
                if (typeof skaitlis !== "number" || isNaN(skaitlis)) {
                    throw new Error("Ievadei jābūt skaitlim vai derīgam skaitļa tekstam.");//Izmet kļūdu, ja ievade nav derīga skaitlis
                }
                const vieni = ["", "viens", "divi", "trīs", "četri", "pieci", "seši", "septiņi", "astoņi", "deviņi"];//Vārdi skaitļiem 0-9
                const padsmiti = ["desmit", "vienpadsmit", "divpadsmit", "trīspadsmit", "četrpadsmit", "piecpadsmit", "sešpadsmit", "septiņpadsmit", "astoņpadsmit", "deviņpadsmit"];//Vārdi skaitļiem 10-19
                const desmiti = ["", "", "divdesmit", "trīsdesmit", "četrdesmit", "piecdesmit", "sešdesmit", "septiņdesmit", "astoņdesmit", "deviņdesmit"];//Vārdi desmitiem
                const tukstosi = ["", "tūkstotis", "tūkstoši"];//Vārdi tūkstošiem

                function numberToWords(n) {
                    if (n === 0) return "nulle";//Atgriež "nulle", ja skaitlis ir 0
                    let vardi = "";

                    if (n >= 1000) { //Ja skaitlis ir tūkstošos
                        const tuks = Math.floor(n / 1000);//Aprēķina cik tūkstoši
                        vardi += numberToWords(tuks) + " " + (tuks === 1 ? tukstosi[1] : tukstosi[2]) + " ";//Pievieno tūkstošu vārdu
                        n %= 1000;//Atlikums pēc tūkstošu daļas izņemšanas
                    }

                    if (n >= 100) { //Ja skaitlis ir simti
                        const simt = Math.floor(n / 100);//Aprēķina simtus
                        vardi += vieni[simt] + " simti ";//Pievieno simtu vārdu
                        n %= 100;//Atlikums pēc simtu daļas izņemšanas
                    }

                    if (n >= 20) { //Ja skaitlis ir divdesmit vai lielāks
                        const desm = Math.floor(n / 10);//Aprēķina desmitu daļu
                        vardi += desmiti[desm] + " ";//Pievieno desmitu vārdu
                        n %= 10;//Atlikums pēc desmitu daļas izņemšanas
                    }

                    if (n >= 10) { //Ja skaitlis ir no 10 līdz 19
                        vardi += padsmiti[n - 10] + " ";//Pievieno padsmitu vārdu
                        n = 0;//Nobeidz, jo atlikums ir 0
                    }

                    if (n > 0) { //Ja atlikums ir lielāks par 0
                        vardi += vieni[n] + " ";//Pievieno vienu skaitļa vārdu
                    }

                    return vardi.trim();//Atgriež rezultātu bez liekiem atstarpēm
                }

                function centuDaudzums(centi) {
                    const rezultats = (centi + '/100').replace(/\/0+$/, '');//Pievieno centu daļu formātu
                    return rezultats;//Atgriež centu daļu kā tekstu
                }

                const [viss_vardos, centu_daudz] = skaitlis.toFixed(2).split(".");//Sadalīt skaitli eiro un centos
                const viss_vardos_rezultats = numberToWords(parseInt(viss_vardos, 10));//Pārvērš eiro daļu vārdiem
                const centu_daudz_rezultats = centuDaudzums(centu_daudz);//Pārvērš centu daļu vārdiem

                return `${viss_vardos_rezultats} Eur un ${centu_daudz_rezultats}`;//Atgriež pilnu summu vārdiem
            }

            //Raksta darba grāmatu kā Excel failu un lejupielādē to
            darbagramata.xlsx.writeBuffer().then(function (buffer) {
                const blob = new Blob([buffer], { type: 'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet' });//Izveido Blob objektu ar faila saturu
                const link = document.createElement('a');//Izveido saites elementu
                link.href = URL.createObjectURL(blob);//Izveido URL no Blob objekta
                link.download = `Rekins_${dati.rekins_nr}.xlsx`;//Nosaka lejupielādējama faila nosaukumu
                link.click();//Automātiski noklikšķina uz saites, lai sāktu lejupielādi
            });

        },
        error: function (xhr, stavoklis, error) {
            console.error('Error: ' + error);//Izvada kļūdas paziņojumu konsolē, ja rodas problēmas
        },
    });
}


function ieladetRekinuTabulu() {    //Ielādē rēķinu tabulu
    const rekinu_tabula = $('#rekini tbody');    //Atlasīt rēķinu tabulas ķermeņa elementu
    rekinu_tabula.empty();    //Notīra tabulu

    const sakuma_indekss = (sobrideja_lapa - 1) * lapas_rindas;    //Aprēķina sākuma indeksu
    const beigu_indekss = Math.min(sakuma_indekss + lapas_rindas, filtretie_dati.length);    //Aprēķina beigu indeksu, lai neizietu ārpus datu garuma

    if (filtretie_dati.length > 0) {    //Ja ir dati
        for (let i = sakuma_indekss; i < beigu_indekss; i++) {    //Iterē pa dati, kas jāparāda pašreizējā lapā
            const rekins = filtretie_dati[i];    //Iegūst konkrēto rēķinu
            const row = `
                <tr>
                    <td>${htmlSpecRakstzimes(rekins.rekins_nr)}</td>
                    <td>${htmlSpecRakstzimes(rekins.datums)}</td>
                    <td>${htmlSpecRakstzimes(rekins.klients)}</td>
                    <td>${htmlSpecRakstzimes(parseFloat(rekins.summa).toFixed(2))} €</td>
                    <td>
                        <button class="btn btn-sm btn-danger me-1" onclick="dzestRekinu(${rekins.id}, '${htmlSpecRakstzimes(rekins.rekins_nr)}')">Dzēst</button>
                        <button class="btn btn-sm btn-warning me-1" onclick="redigetRekinu(${rekins.id}, 'rediget')">Rediģēt</button>
                        <button class="btn btn-sm btn-info me-1" onclick="redigetRekinu(${rekins.id}, 'kopet')">Kopēt</button>
                        <button class="btn btn-sm btn-success" onclick="lejupieladetRekinu(${rekins.id})">Lejupielādēt</button>
                    </td>
                </tr>`;    //Izveido tabulas rindu ar rēķina datiem un darbību pogām
            rekinu_tabula.append(row);    //Pievieno rindu tabulai
        }
    } else {
        rekinu_tabula.append('<tr><td colspan="5">Nav atrasti rēķini.</td></tr>');    //Ja dati nav atrasti, parāda paziņojumu
    }

    $('#sobrideja_lapa').text(`Lapa Nr.${sobrideja_lapa}`);    //Atjaunina pašreizējās lapas numuru
    $('#iepriekseja_lapa').prop('disabled', sobrideja_lapa === 1);    //Ieslēdz vai izslēdz iepriekšējās lapas pogu
    $('#nakama_lapa').prop('disabled', beigu_indekss >= filtretie_dati.length);    //Ieslēdz vai izslēdz nākamās lapas pogu
}

function ieladetKlientuTabulu(dati) {    //Ielādē klientu tabulu
    const klientu_tabula = $('#klienti tbody');    //Atlasīt klientu tabulas ķermeņa elementu
    klientu_tabula.empty();    //Notīra tabulu

    if (dati.length > 0) {    //Ja ir klientu dati
        $.each(dati, function (index, klients) {    //Iterē pa katru klientu
            const row = `
                <tr>
                    <td>${htmlSpecRakstzimes(klients.nosaukums)}</td>
                    <td>
                        <button class="btn btn-sm btn-danger me-1" onclick="dzestKlientu(${klients.id}, '${klients.nosaukums}')" class="klientu-poga">Dzēst</button>
                        <button class="btn btn-sm btn-warning me-1" onclick="redigetKlientu(${klients.id})" class="klientu-poga">Rediģēt</button>
                        <button class="btn btn-sm btn-info me-1" onclick="kopetKlientu(${klients.id})" class="klientu-poga">Kopēt</button>
                    </td>
                </tr>`;    //Izveido tabulas rindu ar klienta datiem un darbību pogām
            klientu_tabula.append(row);    //Pievieno rindu klientu tabulai
        });
    } else {
        klientu_tabula.append('<tr><td colspan="2">Nav atrasti klienti.</td></tr>');    //Ja klienti nav atrasti, parāda paziņojumu
    }
}

let sobridejie_dati = [];    //Mainīgais visu rēķinu datiem
let filtretie_dati = [];    //Mainīgais filtrētajiem rēķinu datiem
let sobrideja_lapa = 1;    //Pašreizējās lapas numurs
const lapas_rindas = 10;    //Vienumu skaits lapā

function filtretTabulu() {    //Filtrē tabulu pēc meklēšanas kritērijiem
    const meklejums = $('#meklejums').val().toLowerCase();    //Iegūst meklēšanas tekstu un pārvērš mazajiem burtiem
    const meklejuma_kolonna = $('#meklejuma_kolonna').val();    //Iegūst kolonnas nosaukumu, kurā meklēt

    filtretie_dati = sobridejie_dati.filter(rekins => {    //Filtrē datus pēc meklēšanas kritērijiem
        const kolonnas_vertiba = rekins[meklejuma_kolonna]?.toString().toLowerCase() || '';    //Iegūst konkrētās kolonnas vērtību
        return kolonnas_vertiba.includes(meklejums);    //Pārbauda, vai vērtība satur meklēšanas tekstu
    });

    sobrideja_lapa = 1;    //Nodrošina, ka lapas numurs sākas no 1
    ieladetRekinuTabulu();    //Atjaunina rēķinu tabulu
}

function mainitLapu(virziens) {    //Maina lapas numuru (iepriekšējā/nākamā lapa)
    const kopa_lapas = Math.ceil(filtretie_dati.length / lapas_rindas);    //Aprēķina kopējo lapu skaitu

    if (virziens === 1 && sobrideja_lapa < kopa_lapas) {    //Ja virziens ir uz nākamo lapu un tā pastāv
        sobrideja_lapa++;    //Palielina lapas numuru
    } else if (virziens === -1 && sobrideja_lapa > 1) {    //Ja virziens ir uz iepriekšējo lapu un tā pastāv
        sobrideja_lapa--;    //Samazina lapas numuru
    }

    ieladetRekinuTabulu();    //Atjaunina rēķinu tabulu
}