<?php
/**
* Autors: Roberts Saulītis
* Apraksts: Nepieciešamās darbības lai rediģētu esoša klienta datus
*/
require '../config/savienojums.php';  //Pievieno datubāzes savienojumu no savienojums.php faila

if ($_SERVER['REQUEST_METHOD'] == 'POST') { //Ja servera metode ir POST, atjaunina klienta datus datubāzē
    $klienta_id = $_POST['klienta_id'];
    $klienta_nosaukums = $_POST['klienta_nosaukums'];
    $reg_num = $_POST['reg_num'];
    $pvn_num = $_POST['pvn_num'];
    $adrese = $_POST['adrese'];
    $bankas_nosauk = $_POST['bankas_nosauk'];
    $bankas_kods = $_POST['bankas_kods'];
    $bankas_num = $_POST['bankas_num'];

    if (empty($klienta_nosaukums) || empty($reg_num) || empty($adrese) || empty($pvn_num)) {    //Pārbauda, vai visi obligātie lauki ir aizpildīti
        echo json_encode(['stavoklis' => 'kļūda', 'ziņa' => 'Jāaizpilda obligātie lauki!']);   //Paziņojums, ka visi obligātie lauki nav aizpildīti
        exit;
    }
    require '../app/inc/sql_parbaudit_adresi.php';
    $vaicajums = $savienojums->prepare($vaic);   //Pārbauda, vai tāda adrese jau ir datubāzē
    $vaicajums->bind_param('s', $adrese);
    $vaicajums->execute();
    $vaicajums->bind_result($adresesId);
    
    if (!$vaicajums->fetch()) {  //Ja adrese nav datubāzē, tad izveido jaunu
        $vaicajums->close();
        require '../app/inc/sql_pievienot_adresi.php';
        $vaicajums = $savienojums->prepare($vaic);   //Ievieto jauno adresi datubāzē un pievieno klientam noteikto adreses identifikatoru
        $vaicajums->bind_param('s', $adrese);
        $vaicajums->execute();
        $adresesId = $savienojums->insert_id;
    }
    $vaicajums->close();
    require '../app/inc/sql_parbaudit_banku.php';
    $vaicajums = $savienojums->prepare($vaic); //Pārbauda, vai tāda banka jau ir datubāzē
    $vaicajums->bind_param('s', $bankas_nosauk);
    $vaicajums->execute();
    $vaicajums->bind_result($bankasId);
    
    if (!$vaicajums->fetch()) {  //Ja banka nav datubāzē, tad izveido jaunu
        $vaicajums->close();
        require '../app/inc/sql_pievienot_banku.php';
        $vaicajums = $savienojums->prepare($vaic); //Ievieto jauno adresi datubāzē un pievieno klientam noteikto bankas ID
        $vaicajums->bind_param('s', $bankas_nosauk);
        $vaicajums->execute();
        $bankasId = $savienojums->insert_id;
    }
    $vaicajums->close();

    //Atjaunina klienta datus
    require '../app/inc/sql_rediget_klientu.php';
    $vaicajums = $savienojums->prepare($vaic);
    $vaicajums->bind_param('sssssssi', $klienta_nosaukums, $reg_num, $pvn_num, $adresesId, $bankasId, $bankas_kods, $bankas_num, $klienta_id);

    if ($vaicajums->execute()) { //Pārbauda vai izdevies ievietot datus un paziņo par to
        echo json_encode(['stavoklis' => 'izdevies']);
    } else {    //Paziņo, ka nevarēja izmainīt  datus
        echo json_encode(['stavoklis' => 'kļūda', 'ziņa' => 'Nevarēja izmainīt klienta datus!']);
    }

    $vaicajums->close();
} else if ($_SERVER['REQUEST_METHOD'] == 'GET') {   //Ja servera metode ir GET, tad ievāc informāciju par klientu ar nosūtīto identifikatoru
    if (isset($_GET['id'])) {   //Ja identifikators ir saņemts, tad pieprasa dokumentu un klientu datus no datubāzes
        $klienta_id = $_GET['id'];
        require '../app/inc/sql_ievakt_klientu.php';
        if ($vaicajums = $savienojums->prepare($vaic)) { //Pieprasījums, kas ņem informāciju par noteikto klientu
            $vaicajums->bind_param('i', $klienta_id);
            $vaicajums->execute();
            $vaicajums->bind_result($id, $klienta_nosaukums, $reg_num, $pvn_num, $adrese, $bankas_nosauk, $bankas_kods, $bankas_num);
            if ($vaicajums->fetch()) {   //Ja klients ir datubāzē, tad nosūta klienta datus
                echo json_encode([   //Nosūta klienta datus lietotājam rediģēšanai
                    'stavoklis' => 'izdevies',
                    'data' => [
                        'id' => $id,
                        'klienta_nosaukums' => $klienta_nosaukums,
                        'reg_num' => $reg_num,
                        'pvn_num' => $pvn_num,
                        'adrese' => $adrese,
                        'bankas_nosauk' => $bankas_nosauk,
                        'bankas_kods' => $bankas_kods,
                        'bankas_num' => $bankas_num
                    ]
                ]);
            } else {    //Ja klients nav datubāzē, tad paziņo par to
                echo json_encode(['stavoklis' => 'kļūda', 'ziņa' => 'Klients nav atrasts!']);
            }

            $vaicajums->close();
        } else {    //Ja pieprasījums nav izdevies, tad paziņo par to
            echo json_encode(['stavoklis' => 'kļūda', 'ziņa' => 'Pieprasījums nav izdevies!']);
        }
    } else {    //Ja identifikators nav saņemts, tad paziņo par to
        echo json_encode(['stavoklis' => 'kļūda', 'ziņa' => 'Nepieciešams klienta ID!']);
    }
}
$savienojums->close();  //Aizver savienojumu
?>
