<?php
/**
* Autors: Roberts Saulītis
* Apraksts: Nepieciešamās darbības lai veiktu rēķina lejupielādēt
*/
session_start();    //Uzsāk sesiju
require '../config/savienojums.php';  //Pievieno datubāzes savienojumu no savienojums.php faila
header('Content-Type: application/json');    // Data type - JSON

if ($_SERVER['REQUEST_METHOD'] === 'GET') {    //Pārbauda, vai servera metode ir GET
    if (isset($_GET['rekins_id'])) {    //Jā rēķina identifikators ir saņemts, tad veic darbības
        $dokuments_id = $_GET['rekins_id'];
        require '../app/inc/sql_lejupieladet_rekinu.php';
        $vaicajums = $savienojums->prepare($vaic);  //Sagatavo SQL pieprasījumu, kas ievāc rēķina lejupielādēšanai nepieciešamos datus
        $vaicajums->bind_param("i", $dokuments_id);
        $vaicajums->execute();
        $rezultats = $vaicajums->get_result();

        if ($rinda = $rezultats->fetch_assoc()) {   //Ja dati saņemti, tad saglabā vērtības mainīgajos
            $document_info = [  //Dokumenta vispārējā informācijk
                'rekins_nr' => $rinda['rekins_nr'],
                'izr_datums' => $rinda['izr_datums'],
                'apm_datums' => $rinda['apm_datums'],
                'pvn' => $rinda['pvn'],
                'piezimes' => $rinda['piezimes'],
                'klients' => [
                    'nosaukums' => $rinda['klienta_nosaukums'],
                    'reg_nr' => $rinda['klienta_reg_nr'],
                    'pvn_reg_nr' => $rinda['klienta_pvn_reg_nr'],
                    'adrese' => $rinda['klienta_adrese'],
                    'banka' => $rinda['klienta_banka'],
                    'banka_kods' => $rinda['klienta_banka_kods'],
                    'banka_nr' => $rinda['klienta_banka_nr']
                ],
                'apmaksa' => []
            ];

            do {
                $document_info['apmaksa'][] = [ //Dokumenta apmansas informācijas masīvs papildinās kamēr visa informācija saglabāta
                    'nosaukums' => $rinda['apmaksas_nosaukums'],
                    'mervieniba_id' => $rinda['mervieniba_id'],
                    'daudzums' => $rinda['daudzums'],
                    'cena' => $rinda['cena'],
                    'mervienibas_nosaukums' => $rinda['mervienibas_nosaukums']
                ];
            } while ($rinda = $rezultats->fetch_assoc());

            echo json_encode($document_info);   //Nosūta atpakaļ visu informāciju
        } else {    //Kļūda par rēķina neesamību
            echo json_encode(['error' => 'nav_datu']);
        }
    } else {    //Kļūda par neveiksmīgu datu saņemšanu vai pieprasījuma izpildi
        echo json_encode(['error' => 'kluda']);
    }
}
?>