<?php
/**
* Autors: Roberts Saulītis
* Apraksts: Nepieciešamās darbības lai ievāktu nākamo neizmantoto rēķina numuru
*/
session_start();    //Uzsāk sesiju
require '../config/savienojums.php';  //Pievieno datubāzes savienojumu no savienojums.php faila
header('Content-Type: application/json');   //Datu tips - JSON

if ($_SERVER['REQUEST_METHOD'] === 'GET') {    //Pārbauda, vai pieprasījuma metode ir "GET"
    require '../app/inc/sql_rekina_nr.php';
    $vaicajums = $savienojums->prepare($vaic);  //SQL pieprasījums, kas ievāc nākamo neizmantoto rēķina numuru
    if ($vaicajums->execute()) {    //Ja ievākšana veicama, tad veic darbības, ja nē - tad paziņo par kļūdu
        $rezultats = $vaicajums->get_result();
        if ($rezultats) {   //Ja ievākšana veiksmīga, tad nosūta atpakaļ jaunu rēķina numuru
            $rinda = $rezultats->fetch_assoc();
            $nakamais_rekina_nr = isset($rinda['nakamais_rekina_nr']) ? str_pad((int)$rinda['nakamais_rekina_nr'] + 1, 3, '0', STR_PAD_LEFT) : '001';

            echo json_encode([  //Atgriež lietotājam datus
                'nakamais_rekina_nr' => $nakamais_rekina_nr
            ]);
        } else {    //Kļūda par datu neesamību
            echo json_encode(['stavoklis' => 'nav_datu']);
        }
    } else {    //Kļūda datu ievākšanā
        echo json_encode(['stavoklis' => 'kluda']);
    }
}
?>