<?php
/**
* Autors: Roberts Saulītis
* Apraksts: Darbības, kas ievāc nepieciešamo informāciju priekš rēķinu veidošanas
*/
session_start();    //Uzsāk sesiju
require '../config/savienojums.php';  //Pievieno datubāzes savienojumu no savienojums.php faila
header('Content-Type: application/json');    //Datu tips - JSON

if ($_SERVER['REQUEST_METHOD'] === 'GET') {    //Pārbauda, vai pieprasījuma metode ir "GET"
    //SQL pieprasījums, kas ievāc datus par klientiem
    $klienti = [];
    require '../app/inc/sql_ievakt_klientus.php';
    $vaicajums = $savienojums->prepare($vaic);  //SQL pieprasījums, kas ievāc klientu sarakstu
    $vaicajums->execute();
    $rezultats = $vaicajums->get_result();
    while ($rinda = $rezultats->fetch_assoc()) {    //Katru klientu saglabā masīvā
        $klienti[] = $rinda;
    }

    
    $mervienibas = [];
    require '../app/inc/sql_ievakt_mervienibas.php';
    $vaicajums = $savienojums->prepare($vaic);  //SQL pieprasījums, kas ievāc mērvienības
    $vaicajums->execute();
    $rezultats = $vaicajums->get_result();
    while ($rinda = $rezultats->fetch_assoc()) {    //Katru mērvienību saglabā masīvā
        $mervienibas[] = $rinda;
    }

    if ($vaicajums->affected_rows === -1 || $vaicajums->errno !== 0) {  //Ja pieprasījums veikts veiksmīgi, tad nosūta datus, ja nē - tad paziņo par kļūdu
        echo json_encode(['stavoklis' => 'kluda']);
    } else {
        echo json_encode([  //Atgriež lietotājam datus
            'stavoklis' => 'izdevies',
            'klienti' => $klienti,
            'mervienibas' => $mervienibas
        ]);
    }
    exit;
}
?>