<?php
/**
* Autors: Roberts Saulītis
* Apraksts: Nepieciešamās darbības lai dzēstu klientu un tam saistītos rēķinus un to apmaksas informāciju
*/
require '../config/savienojums.php';  //Pievieno datubāzes savienojumu no savienojums.php faila

if ($_SERVER['REQUEST_METHOD'] == 'POST') { //Pārbauda, vai pieprasījuma metode ir "POST"
    $klientsId = $_POST['id'];  //Saņem klienta ID no POST pieprasījuma un saglabā to mainīgajā

    require '../app/inc/sql_klienta_esamiba.php';
    $vaicajums = $savienojums->prepare($vaic);   //Sagatavo SQL vaicājumu, lai pārbaudītu, vai klients ar norādīto ID eksistē
    $vaicajums->bind_param('i', $klientsId);                                     
    $vaicajums->execute();   
    $resultats = $vaicajums->get_result();

    if ($resultats->num_rows > 0) { //Ja klients eksistē, tad izdzeš klienta rēķinu apmaksas informāciju
        require '../app/inc/sql_dzest_klienta_apmaksas.php';
        $vaicajums = $savienojums->prepare($vaic);
        $vaicajums->bind_param("i", $klientsId);
        if ($vaicajums->execute()) { //Ja dzēšana ir pieejama, tad veic pieprasījumu
            $vaicajums->execute();
        } else {    //Ja rēķina informāciju nevarēja dzēst, paziņojums par to
            echo json_encode(['stavoklis' => 'kluda']);
            exit;
        }
        
        require '../app/inc/sql_dzest_klienta_rekinus.php'; 
        $vaicajums = $savienojums->prepare($vaic);  //Sagatavo SQL vaicājumu, lai dzēstu klienta rēķinu vispārējo informāciju
        $vaicajums->bind_param('i', $klientsId);
        if ($vaicajums->execute()) { //Ja dzēšana ir pieejama, tad veic pieprasījumu
            $vaicajums->execute();
        } else {    //Ja rēķina informāciju nevarēja dzēst, paziņojums par to
            echo json_encode(['stavoklis' => 'kluda']);
            exit;
        }

        require '../app/inc/sql_dzest_klientu.php';
        $vaicajums = $savienojums->prepare($vaic);  //Sagatavo SQL vaicājumu, lai dzēstu klienta datus
        $vaicajums->bind_param('i', $klientsId);
        if ($vaicajums->execute()) { //Ja dzēšana ir pieejama, tad veic pieprasījumu
            $vaicajums->execute();
            echo json_encode(['stavoklis' => 'izdevies']);
        } else {    //Ja klienta datus nevarēja dzēst, paziņojums par to
            echo json_encode(['stavoklis' => 'kluda']);
            exit;
        }
    }
    exit;
}
?>