<?php
/**
* Autors: Roberts Saulītis
* Apraksts: Lai lietotājs piekļūtu programmai, ir nepieciešama autentifikācija, kas pārbauda vai lietotājs ir pieslēdzies programmai
*/
session_start();    //Uzsāk sesiju
require '../config/savienojums.php';  //Pievieno datubāzes savienojumu no savienojums.php faila

function autentificet($savienojums) {   
    if (!isset($_SESSION['pierakstijies']) || $_SESSION['pierakstijies'] !== true || !isset($_SESSION['tokens'])) { //Lietotāja piekļuves pārbuade
        header("Location: ../public/pieslegsanas_lapa.php");    //Novirza lietotāju atpakaļ uz pieslēgšanās lapu
        exit;
    }

    //SQL pieprasījums, kas meklē vai lietotāja ievadītie pieslēgšanās dati atbilst kādam darbiniekam
    $lietotajs = $_SESSION['lietotajvards'];
    require '../app/inc/sql_autentifikacija.php';
    $vaicajums = $savienojums->prepare($vaic);    
    $vaicajums->bind_param("ss", $lietotajs, $_SESSION['tokens']);
    $vaicajums->execute();
    $resultats = $vaicajums->get_result();

    if ($resultats->num_rows !== 1) {   //Pārbauda, vai lietotāja tokens un tokena termiņš ir derīgi
        header("Location: ../public/pieslegsanas_lapa.php");    //Novirza lietotāju atpakaļ uz pieslēgšanās lapu
        exit;
    }
}
autentificet($savienojums);
?>