/**
* Autors: Roberts Saulītis
* Apraksts: Funkcijas priekš rēķinu lapas
*/
var url_parametri = new URLSearchParams(window.location.search); //Izveido URL parametru objektu no pašreizējās lapas meklēšanas daļas
var rekina_id = url_parametri.get('id'); //Iegūst 'id' parametra vērtību
var veids = url_parametri.get('veids'); //Iegūst 'veids' parametra vērtību
document.addEventListener("DOMContentLoaded", function () { //Kad lapa ir ielādēta, tad izpilda funkciju
    atjaunotLaiku(); //Atjaunina laiku
    if (veids == 'rediget') { //Ja 'veids' ir 'rediget', tad rediģē rēķinu
        rekinaDatuRedigesana(); //Izsauc rēķina datu rediģēšanas funkciju
    } else if (veids == "kopet") { //Ja 'veids' ir 'kopet', tad kopē rēķina datus
        rekinaDatuKopesana(); //Izsauc rēķina datu kopēšanas funkciju
    } else {
        jaunsRekins(); //Pretējā gadījumā veido jaunu rēķinu
    }
    setTimeout(() => { //Nedaudz aizķavēti izpilda funkciju
        atjaunotSummu('pvn'); //Atjaunina summu ar PVN aprēķinu
    }, 100); //Aizkave 100ms

    document.getElementById('izveidot_rekinu').addEventListener('click', function (event) {
        event.preventDefault(); // Aptur formu no iesniegšanas, lai kontrolētu validāciju
        
        let form = document.getElementById('rekinu_izveides_veidlapa');
        
        // Pārbaudām, vai forma ir derīga
        if (form.checkValidity()) {
            // Ja visi lauki ir aizpildīti, izsauc funkciju
            izveidotRekinu(rekina_id, veids);
        } else {
            // Ja kāds lauks nav aizpildīts, piespiežam pārlūkprogrammai rādīt validācijas ziņojumus
            form.reportValidity(); // Izsauc validācijas ziņojumus visiem laukiem
        }
    });
});

function ievaktRekinaIzveidesDatus(klienta_izvelnes_id, mervienibu_izvelnes_id) {
    return new Promise((resolve, reject) => { //Iepako funkciju Promise objektā
        $.ajax({
            url: '../app/ievakt_rekina_izveides_datus.php', //Servera skripts datu iegūšanai
            method: 'GET', //HTTP GET metode
            dataType: 'json', //Sagaida JSON atbildi
            success: function (dati) {
                $(klienta_izvelnes_id).empty(); //Notīra klienta izvēlnes elementu
                $(klienta_izvelnes_id).append('<option value="" selected disabled>Izvēlieties klientu</option>'); //Pievieno noklusējuma opciju
                if (dati.klienti) { //Ja ir klientu dati
                    dati.klienti.forEach(function (klients) {
                        $(klienta_izvelnes_id).append(
                            `<option value="${klients.id}">${klients.nosaukums}</option>` //Pievieno opciju ar klienta datiem
                        );
                    });
                }
                $(mervienibu_izvelnes_id).empty(); //Notīra mērvienību izvēlnes elementu
                $(mervienibu_izvelnes_id).append('<option value="" selected disabled>Izvēlieties mērvienību</option>'); //Pievieno noklusējuma opciju
                if (dati.mervienibas) { //Ja ir mērvienību dati
                    dati.mervienibas.forEach(function (mervieniba) {
                        $(mervienibu_izvelnes_id).append(
                            `<option value="${mervieniba.id}">${mervieniba.mervieniba}</option>` //Pievieno opciju ar mērvienības datiem
                        );
                    });
                }
                resolve(); //Solījuma izpildījums, ja viss ir veiksmīgi
            },
            error: function () {
                Swal.fire('Kļūda!', 'Kļūda ielādējot datus.', 'error'); //Parāda kļūdas paziņojumu
                reject(new Error('Kļūda ielādējot datus.')); //Noraida solījumu ar kļūdu
            }
        });
    });
}

function ievaktRekinaNr(rekina_nr) {
    return new Promise((resolve, reject) => { //Iepako funkciju Promise objektā
        $.ajax({
            url: '../app/ievakt_rekina_nr.php', //Servera skripts nākamā rēķina numuram
            method: 'GET', //HTTP GET metode
            dataType: 'json', //Sagaida JSON atbildi
            success: function (dati) {
                $(rekina_nr).val(dati.nakamais_rekina_nr); //Iestata rēķina numura lauku ar nākamo rēķina numuru
                resolve(); //Solījuma izpildījums, ja viss ir veiksmīgi
            },
            error: function () {
                Swal.fire('Error', 'Kļūda meklējot rēķina numuru.', 'error'); //Parāda kļūdas paziņojumu
                reject(new Error('Kļūda meklējot rēķina numuru.')); //Noraida solījumu ar kļūdu
            }
        });
    });
}

function ievaktRekinaDatus(rekins_id) {
    return new Promise((resolve, reject) => { //Iepako funkciju Promise objektā
        $.ajax({
            url: '../app/rediget_rekinu.php', //Servera skripts rēķina datu rediģēšanai
            method: 'GET', //HTTP GET metode
            data: { rekins_id: rekins_id }, //Nosūta rēķina ID kā parametru
            dataType: 'json', //Sagaida JSON atbildi
            success: function (dati) {
                var rekinuRedaktors = $('#rekinu_izveides_veidlapa'); //Atlasīt rēķina rediģēšanas formu
                rekinuRedaktors.find('#klients_id').val(dati.klients_id); //Iestata klienta ID
                rekinuRedaktors.find('#rekins_nr').val(dati.rekins_nr); //Iestata rēķina numuru
                rekinuRedaktors.find('#izr_datums').val(dati.izr_datums); //Iestata izrakstīšanas datumu
                rekinuRedaktors.find('#apm_datums').val(dati.apm_datums); //Iestata apmaksas datumu
                rekinuRedaktors.find('#pvn').val(dati.pvn); //Iestata PVN likmi
                rekinuRedaktors.find('#piezimes').val(dati.piezimes); //Iestata piezīmes

                var tabula = $('#rekinu_izveides_veidlapa #apmaksa_tabula tbody'); //Atlasīt apmaksas tabulas ķermeņa elementu
                tabula.empty(); //Notīra tabulu
                if (dati.apmaksa && dati.apmaksa.length > 0) { //Ja ir apmaksas ieraksti
                    $.each(dati.apmaksa, function (index, apmaksa) {
                        pievienotRindu(apmaksa.nosaukums, apmaksa.mervieniba_id, apmaksa.daudzums, apmaksa.cena, dati.pvn); //Pievieno rindu ar apmaksas datiem
                    });
                }
                resolve(); //Solījuma izpildījums, ja dati ir veiksmīgi iegūti
            },
            error: function () {
                Swal.fire('Kļūda!', 'Neizdevās iegūt rēķina datus.', 'error'); //Parāda kļūdas paziņojumu
                reject(new Error('Kļūda sazinoties ar serveri: ' + error)); //Noraida solījumu ar kļūdu
            }
        });
    });
}

function izveidotRekinu(rekina_id, veids) {    // Jauna rēķina veidošana
    var dati = {    // Rēķina vispārējo datu piešķiršana objektam
        klients_id: $('#klients_id').val(),    // Iegūst klienta ID no ievades lauka
        rekins_nr: $('#rekins_nr').val(),    // Iegūst rēķina numuru
        izr_datums: $('#izr_datums').val(),    // Iegūst izrakstīšanas datumu
        apm_datums: $('#apm_datums').val(),    // Iegūst apmaksas datumu
        pvn: $('#pvn').val(),    // Iegūst PVN vērtību
        piezimes: $('#piezimes').val(),    // Iegūst piezīmes
        tabulas_dati: []    // Inicializē tukšu masīvu rēķina tabulas datiem
    };

    $('#apmaksas_tabula tbody tr').each(function () {    // Iterē caur apmaksas tabulas rindām
        var rinda = {
            nosaukums: $(this).find('td:eq(0) input').val(),    // Iegūst nosaukumu no pirmās šūnas
            mervieniba_id: $(this).find('td:eq(1) select').val(),    // Iegūst mērvienības ID no otrās šūnas
            daudzums: $(this).find('td:eq(2) input').val(),    // Iegūst daudzumu no trešās šūnas
            cena: $(this).find('td:eq(3) input').val()    // Iegūst cenu no ceturtās šūnas
        };
        dati.tabulas_dati.push(rinda);    // Pievieno apstrādāto rindu masīvam
    });

    if (!rekina_id || veids == 'kopet') {    // Ja rēķina ID nav vai tas tiek kopēts, izveido jaunu rēķinu
        $.ajax({
            type: 'POST',    // HTTP POST metode
            url: '../app/pievienot_rekinu.php',    // Servera skripts rēķina pievienošanai
            data: dati,    // Nosūta rēķina datus
            success: function () {    // Ja pievienošana veiksmīga, parāda paziņojumu
                Swal.fire({
                    title: 'Saglabāts!',
                    text: 'Rēķins pievienots veiksmīgi.',
                    icon: 'success',
                    showConfirmButton: true,
                    confirmButtonText: 'OK'
                }).then((result) => {
                    if (result.isConfirmed) {
                        window.location.href = './index.php';    // Pāradresē uz galveno lapu
                    }
                });
            },
            error: function () {    // Ja pievienošana neizdevās, parāda kļūdas paziņojumu
                Swal.fire('Kļūda!', 'Neizdevās pievienot rēķinu.', 'error');
            }
        });
    } else {    // Ja rēķins jau eksistē, tad to rediģē
        dati.rekins_id = rekina_id;    // Pievieno esošā rēķina ID datiem
        $.ajax({
            type: 'POST',
            url: '../app/rediget_rekinu.php',    // Servera skripts rēķina rediģēšanai
            data: dati,    // Nosūta rediģētos datus
            success: function () {    // Ja saglabāšana veiksmīga, parāda paziņojumu
                Swal.fire({
                    title: 'Saglabāts!',
                    text: 'Rēķina dati atjaunoti veiksmīgi.',
                    icon: 'success',
                    showConfirmButton: true,
                    confirmButtonText: 'OK'
                }).then((result) => {
                    if (result.isConfirmed) {
                        window.location.href = './index.php';    // Pāradresē uz galveno lapu
                    }
                });
            },
            error: function () {    // Ja saglabāšana neizdevās, parāda kļūdas paziņojumu
                Swal.fire('Kļūda!', 'Neizdevās saglabāt rēķinu.', 'error');
            }
        });

    }
}

async function rekinaDatuKopesana() {    // Funkcija rēķina datu kopēšanai
    try {
        pievienotRindu("", 0, "", "", "");    // Pievieno tukšu rindu tabulai
        ievaktRekinaIzveidesDatus('#klients_id', '#mervienibas_id');    // Ielādē klientu un mērvienību datus
        setTimeout(() => {
            ievaktRekinaDatus(rekina_id);    // Ielādē rēķina datus ar nelielu aizkavi
        }, 50);
        setTimeout(() => {
            ievaktRekinaNr('#rekins_nr');    // Ielādē nākamo rēķina numuru ar nelielu aizkavi
        }, 100);
    } catch (error) {    // Ja rodas kļūda, parāda kļūdas paziņojumu
        Swal.fire('Kļūda!', error, 'error');
    }
}

async function rekinaDatuRedigesana() {    // Funkcija rēķina rediģēšanai
    try {
        pievienotRindu("", 0, "", "", "");    // Pievieno tukšu rindu tabulai
        ievaktRekinaIzveidesDatus('#klients_id', '#mervienibas_id');    // Ielādē klientu un mērvienību datus
        ievaktRekinaNr('#rekins_nr');    // Ielādē nākamo rēķina numuru
        setTimeout(() => {
            ievaktRekinaDatus(rekina_id);    // Ielādē rēķina datus ar nelielu aizkavi
        }, 50);
    } catch (error) {    // Ja rodas kļūda, parāda kļūdas paziņojumu
        Swal.fire('Kļūda!', error, 'error');
    }
}

async function jaunsRekins() {    // Funkcija jauna rēķina izveidei
    try {
        pievienotRindu("", 0, "", "", "");    // Pievieno tukšu rindu tabulai
        ievaktRekinaNr('#rekins_nr');    // Ielādē nākamo rēķina numuru
        ievaktRekinaIzveidesDatus('#klients_id', '#mervienibas_id');    // Ielādē klientu un mērvienību datus
    } catch (error) {    // Ja rodas kļūda, parāda kļūdas paziņojumu
        Swal.fire('Kļūda!', error, 'error');
    }
}

var rindas = 0;  // Skaitītājs pievienotajām rindām
var pirma_rinda = "";  // Pirmajai rindai sekojošs mainīgais

function pievienotRindu(nosaukums, mervieniba_id, daudzums, cena, pvn) {    
    // Apmaksas rindas pievienošana tabulai

    document.getElementById('izveidot_rekinu').addEventListener('click', function (event) {
        event.preventDefault(); // Novērš formas noklusēto iesniegšanu
    });

    var tabula = document.getElementById("apmaksas_tabula").getElementsByTagName('tbody')[0];
    var rinda = tabula.insertRow(); // Pievieno jaunu rindu tabulas ķermenim

    // Izveido tabulas šūnas
    var nosaukuma_suna = rinda.insertCell(0);
    var mervienibas_suna = rinda.insertCell(1);
    var daudzuma_suna = rinda.insertCell(2);
    var cenas_suna = rinda.insertCell(3);
    var summas_suna = rinda.insertCell(4);
    var dzesanas_suna = rinda.insertCell(5);

    // Ievades lauks nosaukumam
    nosaukuma_suna.innerHTML = '<input type="text" class="w-100" name="nosaukums[]" value="' + nosaukums + 
        '" required oninvalid="this.setCustomValidity(\'Ievadi nosaukumu!\')" oninput="this.setCustomValidity(\'\'); atjaunotSummu(this)">';

    var mervienibas_izvelne;

    if (rindas == 0) {    
        // Ja tā ir pirmā rinda, izveido jaunu mērvienību izvēlni
        mervienibas_izvelne = document.createElement('select');
        mervienibas_izvelne.name = 'mervieniba[]';
        mervienibas_izvelne.className = 'w-100';
        mervienibas_izvelne.id = 'mervienibas_id';
        mervienibas_suna.appendChild(mervienibas_izvelne);    //Mērvienību izvēlnes pievienošana šūnā
        mervienibas_izvelne.required = true;

        // Pievieno kļūdu validācijas
        mervienibas_izvelne.oninvalid = function () {
            this.setCustomValidity('Izvēlies mērvienību!');
        };
        mervienibas_izvelne.oninput = function () {
            this.setCustomValidity('');
        };

        mervienibas_suna.appendChild(mervienibas_izvelne);
    } else {    
        // Ja tā nav pirmā rinda, izmanto esošo mērvienību izvēlni
        mervienibas_izvelne = document.getElementById('mervienibas_id');
        var jauna_izvelne = document.createElement('select');
        jauna_izvelne.name = 'mervieniba[]';
        jauna_izvelne.className = 'w-100';
        jauna_izvelne.required = true;

        // Pievieno kļūdu validācijas
        jauna_izvelne.oninvalid = function () {
            this.setCustomValidity('Izvēlies mērvienību!');
        };
        jauna_izvelne.oninput = function () {
            this.setCustomValidity('');
        };

        // Pievieno visas opcijas no sākotnējās izvēlnes
        for (var i = 0; i < mervienibas_izvelne.options.length; i++) {
            var option = mervienibas_izvelne.options[i];
            var jauna_izvele = new Option(option.text, option.value);
            jauna_izvelne.options.add(jauna_izvele);
        }

        if (mervieniba_id) {
            setTimeout(function () {
                jauna_izvelne.value = mervieniba_id;
            }, 50);
        }

        mervienibas_suna.appendChild(jauna_izvelne);

        // Ja pirmajai rindai nebija mērvienības, tad to dzēš
        if (mervieniba_id == "0") {
            pirma_rinda = "dzests";
        }
        if (pirma_rinda != "dzests" && rindas != 0) {
            pirma_rinda = "dzests";
            document.getElementById("apmaksas_tabula").deleteRow(1);
            jauna_izvelne.id = "mervienibas_id";
        }
    }

    // Daudzuma ievades lauks
    daudzuma_suna.innerHTML = '<input type="number" name="daudzums[]" step="0.01" class="w-100" value="' + daudzums + 
        '" required oninvalid="this.setCustomValidity(\'Ievadi daudzumu!\')" oninput="this.setCustomValidity(\'\'); atjaunotSummu(this)">';

    // Cenas ievades lauks
    cenas_suna.innerHTML = '<input type="number" step="0.01" name="cena[]" class="w-100" value="' + cena + 
        '" required oninvalid="this.setCustomValidity(\'Ievadi cenu!\')" oninput="this.setCustomValidity(\'\'); atjaunotSummu(this)">';

    // Aprēķina un ievieto kopējo summu
    var summa = cena * daudzums + (cena * daudzums * (pvn / 100));
    summas_suna.innerHTML = '<span class="summa">' + summa + '</span>';

    // Ja tabulā ir vairāk nekā viena rinda, pievieno dzēšanas pogu
    if (tabula.rows.length > 1) {
        dzesanas_suna.innerHTML = "<button type='button' onclick='dzestRindu(this)'>Dzēst</button>";
    }

    rindas++;  // Palielina rindu skaitītāju
    atjaunotSummu("pvn");  // Atjauno kopējo summu
    izrekinatApmTerminu();  // Pārrēķina apmaksas termiņu
}

// Funkcija rindas dzēšanai
function dzestRindu(poga) {
    var rinda = poga.parentNode.parentNode; // Atrod rindas elementu
    rinda.parentNode.removeChild(rinda); // Noņem rindu no tabulas
}

function atjaunotSummu(elements) {     
    // Funkcija apmaksas summu aprēķināšanai un atjaunošanai

    if (elements == "pvn") {   // Ja tiek mainīta PVN vērtība, pārrēķina visas rindas
        var tabula = document.getElementById("apmaksas_tabula").getElementsByTagName('tbody')[0];
        var rindas = tabula.getElementsByTagName('tr');
        var pvn = document.getElementById("pvn").value;
        var kopasummaBezPvn = 0;
        var kopasummaArPvn = 0;

        // Caurstaigā visas rindas un aprēķina jaunas summas
        for (var i = 0; i < rindas.length; i++) {    
            var rinda = rindas[i];
            var daudzums = rinda.cells[2].getElementsByTagName('input')[0].value;
            var cena = rinda.cells[3].getElementsByTagName('input')[0].value;
            var summa = rinda.cells[4].getElementsByClassName('summa')[0];

            var summaBezPvn = daudzums * cena; // Aprēķina summu bez PVN
            var summaArPvn = summaBezPvn + (summaBezPvn * (pvn / 100)); // Aprēķina summu ar PVN

            summa.textContent = summaArPvn.toFixed(2); // Atjauno rindu summu

            kopasummaBezPvn += summaBezPvn;
            kopasummaArPvn += summaArPvn;
        }

    } else {    
        // Ja tiek mainīts daudzums vai cena, pārrēķina tikai konkrēto rindu un kopējās summas
        var rinda = elements.parentElement.parentElement;
        var daudzums = rinda.cells[2].getElementsByTagName('input')[0].value;
        var cena = rinda.cells[3].getElementsByTagName('input')[0].value;
        var summa = rinda.cells[4].getElementsByClassName('summa')[0];
        var pvn = document.getElementById("pvn").value;

        var summaBezPvn = daudzums * cena; // Aprēķina summu bez PVN
        var summaArPvn = summaBezPvn + (summaBezPvn * (pvn / 100)); // Aprēķina summu ar PVN
        summa.textContent = summaArPvn.toFixed(2); // Atjauno rindu summu

        // Pārrēķina visas rindas, lai atjauninātu kopējās summas
        var tabula = document.getElementById("apmaksas_tabula").getElementsByTagName('tbody')[0];
        var rindas = tabula.getElementsByTagName('tr');
        var kopasummaBezPvn = 0;
        var kopasummaArPvn = 0;

        for (var i = 0; i < rindas.length; i++) {    
            var rinda = rindas[i];
            var daudzums = rinda.cells[2].getElementsByTagName('input')[0].value;
            var cena = rinda.cells[3].getElementsByTagName('input')[0].value;
            var summaBezPvn = daudzums * cena;
            var summaArPvn = summaBezPvn + (summaBezPvn * (pvn / 100));

            kopasummaBezPvn += summaBezPvn;
            kopasummaArPvn += summaArPvn;
        }
    }

    // Atjauno kopējās summas HTML elementu saturā
    document.getElementById("kopasummaBezPvn").innerHTML = kopasummaBezPvn.toFixed(2);
    document.getElementById("kopsummaPvn").innerHTML = (kopasummaArPvn - kopasummaBezPvn).toFixed(2);
    document.getElementById("kopasummaArPvn").innerHTML = kopasummaArPvn.toFixed(2);
}

function izrekinatApmDatumu() {    
    // Funkcija aprēķina apmaksas datumu, balstoties uz izrakstīšanas datumu un termiņu
    let izr_datums = new Date(document.getElementById('izr_datums').value); // Paņem izrakstīšanas datumu
    let apm_termins = document.getElementById('apm_termins').value; // Paņem apmaksas termiņu (dienās)
    let apm_datums = new Date(izr_datums.setDate(izr_datums.getDate() + parseInt(apm_termins))); // Pievieno termiņu datiem
    document.getElementById('apm_datums').valueAsDate = apm_datums; // Atjauno apmaksas datuma lauku
}

function izrekinatApmTerminu() {    
    // Funkcija aprēķina apmaksas termiņu dienās, balstoties uz izrakstīšanas un apmaksas datumiem
    let izr_datums = new Date(document.getElementById('izr_datums').value); // Paņem izrakstīšanas datumu
    let apm_datums = new Date(document.getElementById('apm_datums').value); // Paņem apmaksas datumu
    let apm_termins = Math.ceil((apm_datums - izr_datums) / (1000 * 60 * 60 * 24)); // Aprēķina starpību dienās
    document.getElementById('apm_termins').value = apm_termins; // Atjauno apmaksas termiņu laukā
}
