/**
* Autors: Roberts Saulītis
* Apraksts: Funkcijas priekš galvenās (index) un rēķinu lapas
*/
function pievienotKlientu() {   //Jauna klienta pievienošana
    Swal.fire({   //Klienta pievienošanas dialogs
        title: 'Pievienot jaunu klientu',   //Dialoga virsraksts
        html: `
            <input type="text" id="klienta_nosaukums" class="swal2-input sweetalert-ievades" placeholder="Klients" required><span class="zvaigzne">*</span>
            <input type="text" id="reg_num" class="swal2-input sweetalert-ievades" placeholder="Reģistrācijas numurs"><span class="zvaigzne">*</span>
            <input type="text" id="pvn_num" class="swal2-input sweetalert-ievades" placeholder="PVN reģistrācijas numurs"><span class="zvaigzne">*</span>
            <input type="text" id="adrese" class="swal2-input sweetalert-ievades" placeholder="Juridiskā adrese"><span class="zvaigzne">*</span>
            <input type="text" id="bankas_nosauk" class="swal2-input sweetalert-ievades" placeholder="Banka">
            <input type="text" id="bankas_kods" class="swal2-input sweetalert-ievades" placeholder="Bankas kods">
            <input type="text" id="bankas_num" class="swal2-input sweetalert-ievades" placeholder="Bankas koda numurs">
        `,
        focusConfirm: false,   //Nedod automātisku fokusu uz apstiprināšanas pogu
        preConfirm: () => {   //Klienta datu validācija pirms saglabāšanas
            const klienta_nosaukums = $('#klienta_nosaukums').val();   //Iegūst klienta nosaukumu
            const reg_num = $('#reg_num').val();   //Iegūst reģistrācijas numuru
            const pvn_num = $('#pvn_num').val();   //Iegūst PVN reģistrācijas numuru
            const adrese = $('#adrese').val();   //Iegūst juridisko adresi
            const bankas_nosauk = $('#bankas_nosauk').val();   //Iegūst bankas nosaukumu
            const bankas_kods = $('#bankas_kods').val();   //Iegūst bankas kodu
            const bankas_num = $('#bankas_num').val();   //Iegūst bankas koda numuru

            let errors = [];
            if (!klienta_nosaukums) { errors.push('Klienta nosaukums ir obligāts!'); }
            if (!reg_num) { errors.push('Reģistrācijas numurs ir obligāts!'); }
            if (!pvn_num) { errors.push('PVN reģistrācijas numurs ir obligāts!'); }
            if (!adrese) { errors.push('Juridiskā adrese ir obligāta!'); }

            if (errors.length > 0) {
                Swal.showValidationMessage(errors.join('<br>'));
                return;
            }

            return { klienta_nosaukums, reg_num, pvn_num, bankas_nosauk, bankas_kods, bankas_num, adrese };   //Atgriež klienta datus kā objektu
        }
    }).then((resultats) => {   //Pēc lietotāja apstiprinājuma
        if (resultats.isConfirmed) {   //Ja lietotājs ir apstiprinājis datu ievadi
            $.ajax({   //Veic AJAX pieprasījumu klienta datu pievienošanai
                url: '../app/pievienot_klientu.php',   //Servera skripts klienta pievienošanai
                type: 'POST',   //HTTP metode POST
                data: resultats.value,   //Nosūta iegūtos klienta datus
                success: function (response) {   //Ja pievienošana ir veiksmīga
		    let atrasanas_vieta = window.location.pathname.split("/").pop();
                    if (atrasanas_vieta === "index.php") {
                        ievaktTabuluDatus();   //Atjaunina datus tabulās
                    } else if (atrasanas_vieta === "rekinu_lapa.php") {
                        ievaktRekinaIzveidesDatus('#klients_id', '#rekins_nr');   //Atjaunina rēķinu izveides datus
                    }
                    Swal.fire('Veiksmīgi!', 'Jauns klients pievienots veiksmīgi!', 'success');   //Parāda veiksmīgu paziņojumu
                },
                error: function (xhr, stavoklis, error) {   //Ja rodas kļūda klienta pievienošanā
                    Swal.fire('Error', 'Neizdevās pievienot klientu.', 'error');   //Parāda kļūdas paziņojumu
                }
            });
        }
    });
};

function ievaktTabuluDatus() {    //Ievāc datus tabulām no servera
    $.ajax({
        url: '../app/ievakt_tabulu_datus.php',    //Servera skripts datu iegūšanai
        method: 'GET',    //HTTP metode GET
        dataType: 'json',    //Sagaida datus JSON formātā
        success: function (dati) {    //Ja datus saņem veiksmīgi
            sobridejie_dati = dati.rekini;    //Iestata saņemtos rēķinu datus
            filtretie_dati = sobridejie_dati;    //Sākotnēji visi dati ir filtrēti
            sobrideja_lapa = 1;    //Nodrošina, ka lapas numurs sākas no 1
            ieladetRekinuTabulu();    //Atjaunina rēķinu tabulu
            ieladetKlientuTabulu(dati.klienti);    //Atjaunina klientu tabulu
        },
        error: function (xhr, stavoklis, error) {    //Ja rodas kļūda datu iegūšanā
            Swal.fire('Error', 'Neizdevās ievākt tabulu datus.', 'error');   //Parāda kļūdas paziņojumu
        }
    });
}

function htmlSpecRakstzimes(teksts) {   //Funkcija, kas aizsargā īpašās rakstzīmes HTML
    if (typeof teksts !== 'undefined') {   //Ja teksts ir definēts
        return teksts
            .replace(/&/g, '&amp;')   //Aizstāj &
            .replace(/</g, '&lt;')   //Aizstāj <
            .replace(/>/g, '&gt;')   //Aizstāj >
            .replace(/"/g, '&quot;')   //Aizstāj "
            .replace(/'/g, '&#039;');   //Aizstāj '
    } else {
        return '';   //Atgriež tukšu virkni, ja teksts nav definēts
    }
}

function atjaunotLaiku() {   //Funkcija laika atjaunošanai
    var now = new Date();   //Izveido jaunu datuma objektu ar pašreizējo laiku
    var iestatijumi = { 
        hour: '2-digit', minute: '2-digit', second: '2-digit',   //Iestata laika formātu
        hour12: false   //Izmanto 24 stundu formātu
    };
    var sobridejais_laiks = now.toLocaleTimeString('lv-LV', iestatijumi);   //Formatē laiku saskaņā ar iestatījumiem
    document.getElementById('pulkstenis').textContent = sobridejais_laiks;   //Atjaunina elementa ar id "pulkstenis" saturu ar laiku
}

setInterval(atjaunotLaiku, 1000);   //Atjauno laiku ik pēc 1 sekundes