<?php
/**
* Autors: Roberts Saulītis
* Apraksts: Nepieciešamās darbības lai rediģētu esoša rēķina datus
*/
session_start();    //Uzsāk sesiju
require '../config/savienojums.php';  //Pievieno datubāzes savienojumu no savienojums.php faila

header('Content-Type: application/json');   //Datu tips - JSON

if ($_SERVER['REQUEST_METHOD'] === 'POST') {    //Ja servera metode ir POST, tad ievieto dokumentu datubāzā
    $rekins_id = $_POST['rekins_id'];
    $klients_id = $_POST['klients_id'];
    $rekins_nr = $_POST['rekins_nr'];
    $izr_datums = $_POST['izr_datums'];
    $apm_datums = $_POST['apm_datums'];
    $pvn = $_POST['pvn'];
    $piezimes = $_POST['piezimes'];

    require '../app/inc/sql_rediget_rekinu.php';
    $vaicajums = $savienojums->prepare($vaic);    //SQL pieprasījums, kas atjaunina dokumenta datus
    $vaicajums->bind_param("isssdsi", $klients_id, $rekins_nr, $izr_datums, $apm_datums, $pvn, $piezimes, $rekins_id);
    $vaicajums->execute();

    $tabulas_dati = $_POST['tabulas_dati'];
    require '../app/inc/sql_dzest_apmaksas.php';    //SQL pieprasījums, kas dzēš esošās apmaksas no dokumenta
    $vaicajums = $savienojums->prepare($vaic);
    $vaicajums->bind_param("i", $rekins_id);
    $vaicajums->execute();

    foreach ($tabulas_dati as $rinda) {  //Dokumenta apmaksas datu rindu ievietošana masīvā
        require '../app/inc/sql_atjaunot_apmaksas.php';
        $vaicajums = $savienojums->prepare($vaic);
        $vaicajums->bind_param("isiss", $rekins_id, $rinda['nosaukums'], $rinda['mervieniba_id'], $rinda['daudzums'], $rinda['cena']);
        $vaicajums->execute();
    }

    echo json_encode(['izdevies' => 'Dokuments atjaunots!', 'stavoklis' => 'izdevies']);    //Paziņojums par dokumenta veiksmīgu atjaunšanu
    exit;
} elseif ($_SERVER['REQUEST_METHOD'] === 'GET') {    //Ja servera metode ir GET, tad ievāc dokumentu datus
    $rekins_id = $_GET['rekins_id'];

    require '../app/inc/sql_ievakt_rekinu.php';
    $vaicajums = $savienojums->prepare($vaic);      //SQL pieprasījums, kas ievāc dokumenta datus
    $vaicajums->bind_param("i", $rekins_id);
    $vaicajums->execute();
    $rezultats = $vaicajums->get_result();
    $rinda = $rezultats->fetch_assoc();

    require '../app/inc/sql_ievakt_apmaksas.php';
    $vaicajums = $savienojums->prepare($vaic);    //SQL pieprasījums, kas ievāc dokumenta apmaksas informāciju
    $vaicajums->bind_param("i", $rekins_id);
    $vaicajums->execute();
    $rezultats = $vaicajums->get_result();
    $apmaksa = array();

    while ($rinda2 = $rezultats->fetch_assoc()) {   //Katru apmaksu saglabā masīvā
        $apmaksa[] = $rinda2;
    }

    $dati = array(  //Dokumenta informācija
        'stavoklis' => 'izdevies',
        'klients_id' => $rinda['klients_id'],
        'rekins_nr' => $rinda['rekins_nr'],
        'izr_datums' => $rinda['izr_datums'],
        'apm_datums' => $rinda['apm_datums'],
        'pvn' => $rinda['pvn'],
        'piezimes' => $rinda['piezimes'],
        'apmaksa' => $apmaksa
    );

    echo json_encode($dati);    //Nosūta dokumenta informāciju apstrādei
    exit;
}

?>