<?php
/**
* Autors: Roberts Saulītis
* Apraksts: Nepieciešamās darbības lai veiktu lietotāja pieslēgšanos programmai
*/
session_start();    //Uzsāk sesiju
require '../config/savienojums.php';  //Pievieno datubāzes savienojumu no savienojums.php faila

if ($_SERVER["REQUEST_METHOD"] == "POST") { //Ja servera metode ir POST, tad programma salīdzina vai lietotāja ievadītie dati atbilst kādam no darbiniekiem
    $lietotajs = $_POST['lietotajvards'];
    $parole = $_POST['parole'];

    require '../app/inc/sql_pieslegties.php';
    $vaicajums = $savienojums->prepare($vaic);  //Pieprasījums, kas pārbauda vai darbinieks eksistē
    $vaicajums->bind_param("s", $lietotajs);
    $vaicajums->execute();
    $resultats = $vaicajums->get_result();

    if ($resultats->num_rows === 1) {   //Ja darbinieks eksistē, tad ļauj programmai turpināt pārbaudi, bet ja nē, tad izmet paziņojumu
        $rinda = $resultats->fetch_assoc();

        if ($rinda['parole'] === $parole) { //Ja parole sakrīt, tad piešķir lietotājam atļauju tikt pie datiem
            $tokens = bin2hex(random_bytes(32));
            $termins = date('Y-m-d H:i:s', strtotime('+1 hour'));

            require '../app/inc/sql_pieslegties_apstiprinats.php';
            $vaicajums = $savienojums->prepare($vaic);   //SQL pieprasījums, kas atjaunina darbinieka datus un pievieno token un termiņu
            $vaicajums->bind_param("sss", $tokens, $termins, $lietotajs);
            $vaicajums->execute();

            $_SESSION['pierakstijies'] = true;  //Saglabā lietotāja sesiju
            $_SESSION['lietotajvards'] = $rinda['lietotajvards'];
            $_SESSION['tokens'] = $tokens;

            header("Location: ../public/index.php"); //Aizvirza lietotāju uz galveno lapu
            exit;
        } else {    //Ja parole neatbilst, tad paziņo to
            echo "<head>
                <script src='https://cdn.jsdelivr.net/npm/sweetalert2@11'></script>
                <script src='https://code.jquery.com/jquery-3.7.1.slim.min.js'></script>
                <link rel='stylesheet' href='../public/CSS/stili.css'>
                <link rel='stylesheet' href='https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css'>
            </head>";
            echo "<script>
                $(document).ready(function() {
                    Swal.fire('Nepareiza parole!').then(function() {
                        window.location.href='../public/pieslegsanas_lapa.php';
                    });
                });
            </script>";
        }
    } else {    //Ja darbinieks neeksistē, tad paziņo to
        echo "<head>
            <script src='https://cdn.jsdelivr.net/npm/sweetalert2@11'></script>
            <script src='https://code.jquery.com/jquery-3.7.1.slim.min.js'></script>
            <link rel='stylesheet' href='../public/CSS/stili.css'>
            <link rel='stylesheet' href='https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css'>
        </head>";
        echo "<script>
            $(document).ready(function() {
                Swal.fire('Lietotājs neeksistē!').then(function() {
                    window.location.href='../public/pieslegsanas_lapa.php';
                });
            });
        </script>";
    }
}
$savienojums->close();  //Aizver savienojumu
?>