<?php
//Autors: Ralfs Riters; Konkrēta darījuma informācijas atjaunošanas php datne;
//Veidots: 2024. gadā, Jaunākā versija

// konekcijas piesaiste
include('connection.php');

//iegūst datus no POST metodes glabā tos lokālos mainīgajos
$data = json_decode(file_get_contents("php://input"), true);

$tradeId = $data['trade_id'] ?? null;
$coinName = $data['coin_name'] ?? null;
$coinPairName = $data['coinpair_name'] ?? null;
$directionId = $data['direction'] ?? null;
$leverage = $data['leverage'] ?? null;
$openPrice = $data['open_price'] ?? null;
$closePrice = $data['close_price'] ?? null;
$closeDate = $data['close_date'] ?? null;

if (!$tradeId) {
    echo json_encode(['error' => 'Trade ID is missing.']);//kļūdas ziņojums
    exit;
}

$conn->begin_transaction();

try {
    // izgūst pašreizējo informāciju par darījumu
    $stmt = $conn->prepare('
        SELECT c.coin_name, cp.coinpair_name, h.coin_id, h.coinpair_id, h.direction_id, h.open_price, 
               h.close_price, h.leverage, h.close_date, h.percents
        FROM rr_410_history_input h
        JOIN rr_410_coin c ON h.coin_id = c.coin_id
        JOIN rr_410_coinpair cp ON h.coinpair_id = cp.coinpair_id
        WHERE h.trade_id = ?
    ');
    $stmt->bind_param('i', $tradeId);//nodod darījums ID
    $stmt->execute();
    $stmt->bind_result($dbCoinName, $dbCoinPairName, $coinId, $coinpairId, $dbDirectionId, $dbOpenPrice, $dbClosePrice, $dbLeverage, $dbCloseDate, $dbPercents);
    $stmt->fetch();
    $stmt->close();

    // saglabā veco informāciju mainīgajos
    $coinName = $coinName ?? $dbCoinName;
    $coinPairName = $coinPairName ?? $dbCoinPairName;
    $directionId = $directionId ?? $dbDirectionId;
    $leverage = $leverage ?? $dbLeverage;
    $openPrice = $openPrice ?? $dbOpenPrice;
    $closePrice = $closePrice ?? $dbClosePrice;
    $closeDate = $closeDate ?? $dbCloseDate;

    // atjaunota kriptovalūtas nosaukuma pievienošana
    if ($coinName) {
        $stmt = $conn->prepare('SELECT coin_id FROM rr_410_coin WHERE coin_name = ?'); //izgūst kriptovalūtas ID pēc nosaukuma
        $stmt->bind_param('s', $coinName);//nodod kriptovalūtas nosaukumu
        $stmt->execute();
        $stmt->bind_result($existingCoinId);
        if ($stmt->fetch()) {
            // ja eksitē tāds nosaukums piešķir eksistējošo ID
            $coinId = $existingCoinId;
        } else {
            // ja neeksistē tāds nosaukums DB tad to reģistrē DB
            $stmt->close();
            $stmt = $conn->prepare('INSERT INTO rr_410_coin (coin_name) VALUES (?)');//reģistrē nosuakumu
            $stmt->bind_param('s', $coinName);//nodod nosaukumu
            $stmt->execute();
            $coinId = $stmt->insert_id; // izgūst jauno ID
        }
        $stmt->close();
    }
    // atjaunota kriptovalūtas nosaukuma pievienošana
    if ($coinPairName) {
        $stmt = $conn->prepare('SELECT coinpair_id FROM rr_410_coinpair WHERE coinpair_name = ?'); //izgūst darījuma valūtas ID pēc nosaukuma
        if ($stmt) {
            $stmt->bind_param('s', $coinPairName); //nodod darījuma valūtas nosaukumu
            $stmt->execute();
            $stmt->bind_result($existingCoinPairId);
    
            if ($stmt->fetch()) {
                // ja eksitē tāds nosaukums piešķir eksistējošo ID
                $coinpairId = $existingCoinPairId;
            } else {
                $stmt->close();
                // ja neeksistē tāds nosaukums DB tad to reģistrē DB
                $stmt = $conn->prepare('INSERT INTO rr_410_coinpair (coinpair_name) VALUES (?)'); //izgūst darījuma valūtas ID pēc nosaukuma
                if ($stmt) {
                    $stmt->bind_param('s', $coinPairName); //nodod darījuma valūtas nosaukumu
                    $stmt->execute();
                    $coinpairId = $stmt->insert_id; // izgūst jauno ID
                }
            }
            $stmt->close();
        }
    }
    
    

    // ja nepieciešams kalkulē jaunus procentus
    $newPercents = null;
    if ($directionId != $dbDirectionId || $openPrice != $dbOpenPrice || $closePrice != $dbClosePrice || $leverage != $dbLeverage) {
        if ($openPrice != 0) {
            $newPercents = calculatePercents($directionId == 1 ? 'Long' : 'Short', $openPrice, $closePrice, $leverage);
        } else {
            $newPercents = 0;
        }
    }

    // atjauno informācijas laukus DBD
    $stmt = $conn->prepare('
        UPDATE rr_410_history_input
        SET coin_id = ?, coinpair_id = ?, direction_id = ?, leverage = ?, open_price = ?, close_price = ?, percents = ?, close_date = ?
        WHERE trade_id = ?
    ');

    $percentsToUpdate = $newPercents ?? $dbPercents;
    $stmt->bind_param('iiiidddsi', $coinId, $coinpairId, $directionId, $leverage, $openPrice, $closePrice, $percentsToUpdate, $closeDate, $tradeId);//nodod parametrus
    $stmt->execute();
    $stmt->close();

    $conn->commit();

    echo json_encode(['success' => true]);
} catch (Exception $e) {
    $conn->rollback();
    echo json_encode(['error' => 'Failed to update trade: ' . $e->getMessage()]);//kļūdas ziņojums
}

// aizvert konekciju
$conn->close();

// funkcija, kas kalkulē procentus ja tas nepieciešams
function calculatePercents($direction, $open_price, $close_price, $leverage) {
    if ($open_price == 0) return 0;

    if ($direction === 'Long') {//long pozīcijas kalkulacija
        $percentage = ((100 / $open_price) * $close_price - 100) * $leverage;
    } elseif ($direction === 'Short') {//short pozīcijas kalkulacija
        $percentage = ((100 / $open_price) * $close_price - 100) * (-1) * $leverage;
    } else {
        return null;
    }
    //noapaļo procentus
    return round($percentage, 2);
}
?>
