<?php
//Autors: Ralfs Riters; Darījuma reģistrēšanas php datne;
//Veidots: 2024. gadā, Jaunākā versija

// debugošanas atļaujas
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// konekcijas piesaiste
include('connection.php');

//izgūst kriptovalūtu nosaukumus no datubāzes, ja tāda vēl nav to reģistrē
function getCoinId($coin, $conn) {
    $stmt = $conn->prepare("SELECT coin_id FROM rr_410_coin WHERE coin_name = ?"); //izgūst kriptovalūtu nosaukumus
    $stmt->bind_param('s', $coin);//nodod kripto nosaukumu
    $stmt->execute();
    $result = $stmt->get_result();//saglabā rezultātu
    
    if ($result->num_rows > 0) {//atarsti rezultāti
        $row = $result->fetch_assoc();
        return $row['coin_id'];
    } else {//nav rezultātu
        $stmt = $conn->prepare("INSERT INTO rr_410_coin (coin_name) VALUES (?)");//pievieno jaunu nosaukumu
        $stmt->bind_param('s', $coin);//nodod kripto nosaukumu
        if ($stmt->execute()) {
            return $conn->insert_id;
        }
    }
    return null;
}
//izgūst darījuma valūtu nosaukumus no datubāzes, ja tāda vēl nav to reģistrē
function getCoinpairId($coinpair, $conn) {
    $stmt = $conn->prepare("SELECT coinpair_id FROM rr_410_coinpair WHERE coinpair_name = ?");//izgūst darījumu valūtu nosaukumus
    $stmt->bind_param('s', $coinpair);//nodod valūtas nosaukumu
    $stmt->execute();
    $result = $stmt->get_result();//saglabā rezultātu
    
    if ($result->num_rows > 0) {//atarsti rezultāti
        $row = $result->fetch_assoc();
        return $row['coinpair_id'];
    } else {//nav rezultātu
        $stmt = $conn->prepare("INSERT INTO rr_410_coinpair (coinpair_name) VALUES (?)");//pievieno jaunu nosaukumu
        $stmt->bind_param('s', $coinpair);//nodod valūtas nosaukumu
        if ($stmt->execute()) {
            return $conn->insert_id;
        }
    }
    return null;
}
//izgūst darījuma virzienu no DB
function getDirectionId($direction, $conn) {
    $stmt = $conn->prepare("SELECT direction_id FROM rr_410_direction WHERE direction = ?");//vaicājums virziena iegūšanai
    $stmt->bind_param('s', $direction);
    $stmt->execute();
    $result = $stmt->get_result();//sagalabā rezultātu
    
    if ($result && $result->num_rows > 0) {
        $row = $result->fetch_assoc();
        return $row['direction_id'];
    }
    return null;
}



// funkcija,kas kalkulē iegūtos vai zaudētos procentus
function calculatePercents($direction, $open_price, $close_price, $leverage) {
    if ($direction === 'long') { //priekš long pozīcijas darījumiem
        $percentage = ((100 / $open_price) * $close_price - 100) * $leverage;
    } elseif ($direction === 'short') {//priekš short pozīcijas darījumiem
        $percentage = ((100 / $open_price) * $close_price - 100) * (-1) * $leverage;
    } else {
        return null;
    }
    //atgriež noapaļotus procentus
    return round($percentage, 2);
}

// savāc un piešķir datus mainīgajiem no POST metodes
if (isset($_POST['coin'], $_POST['coinpair'], $_POST['direction'], $_POST['account_name'], $_POST['open_price'], $_POST['close_price'], $_POST['leverage'], $_POST['close_date'], $_POST['profile_id'])) {
    $coin = $_POST['coin'];
    $coinpair = $_POST['coinpair'];
    $direction = $_POST['direction'];
    $account_name = $_POST['account_name'];
    $open_price = $_POST['open_price'];
    $close_price = $_POST['close_price'];
    $leverage = $_POST['leverage'];
    $close_date = $_POST['close_date'];
    $profile_id = $_POST['profile_id'];
    
    // izsauc procentu kalkulācijas funkciju nododot neopieciešamos datus
    $percents = calculatePercents($direction, $open_price, $close_price, $leverage);

    // bildes apstrāde, ja tāda tiek nodota
    $photo_name = null;
        if (isset($_FILES['photo']) && $_FILES['photo']['error'] === UPLOAD_ERR_OK) {
            $photo_tmp = $_FILES['photo']['tmp_name'];//pieņem pievienoto bildi, ka pagaidu variantu
            $original_name = basename($_FILES['photo']['name']); //tiek noteikt oriģinālais bildes nosaukums
            $file_extension = pathinfo($original_name, PATHINFO_EXTENSION);//nosaka bildes formātu
            $unique_phot_name = uniqid('photo_', true) . '_' . bin2hex(random_bytes(8)) . '.' . $file_extension;//izveido jaunu nosaukumu pievieno bildes formātu
            $photo_path = '../photo/' . $unique_phot_name; //tiek noteikt ceļš uz jaunizveidoto bildi ar nosuakumu
    
            $allowedTypes = ['image/jpeg', 'image/png', 'image/gif'];//pareiza formāta pārbaude
            $fileType = mime_content_type($photo_tmp);//salīdzina formātus
            //ja viss ir pareizi un formāts atbilst tad izpildās darbības un jaunais nosaukums ir pieškirts
            if (in_array($fileType, $allowedTypes)) {
                if (move_uploaded_file($photo_tmp, $photo_path)) {
                    $response['success'] = true;
                    $response['photo_name'] = $unique_phot_name; //piešķir jauno nosaukumu
                } else {
                    $response['message'] = 'Failed to upload photo';//kļūdas zoiņojums
                }
            } else {
                $response['message'] = 'Invalid file type';//kļūdas zoiņojums
            }
        }
    

    // izgūst konta ID no datubāzes izmantojot konta nosaukumu un profila ID
    $stmt = $conn->prepare("SELECT account_id FROM rr_410_accounts WHERE account_name = ? AND profile_id = ?");
    $stmt->bind_param("si", $account_name, $profile_id); //nodod profila ID un konta nosaukumu
    $stmt->execute();
    $account_result = $stmt->get_result();//saglabā rezultātu
    
    if ($account_result && $account_result->num_rows > 0) {
        $account_row = $account_result->fetch_assoc();
        $account_id = $account_row['account_id'];

        // iegūst un saglabā mainīgos
        $coin_id = getCoinId($coin, $conn);
        $coinpair_id = getCoinpairId($coinpair, $conn);
        $direction_id = getDirectionId($direction, $conn);

        //darījuma reģistrācijas vaicājums ar visiem nodotajiem parametriem
        if ($coin_id && $coinpair_id && $direction_id) {
            $stmt = $conn->prepare("INSERT INTO rr_410_history_input (coin_id, coinpair_id, direction_id, account_id, open_price, close_price, leverage, close_date, photo, percents) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
            $stmt->bind_param('iiiidddsss', $coin_id, $coinpair_id, $direction_id, $account_id, $open_price, $close_price, $leverage, $close_date, $unique_phot_name, $percents);//nodod parametrus
            //galbā dažus datus masīvā pēc veiksmīgas reģistrēšanas
            if ($stmt->execute()) {
                echo json_encode([
                    'success' => true,
                    'coin_id' => $coin_id,
                    'coinpair_id' => $coinpair_id,
                    'direction_id' => $direction_id,
                    'account_id' => $account_id,
                    'percents' => $percents
                ]);
            } else {
                echo json_encode(['success' => false, 'message' => 'Failed to insert trade data: ' . $stmt->error]);//kļūdas ziņojums
            }
        } else {
            //galbā dažus datus masīvā pēc neveiksmīgas reģistrēšanas
            echo json_encode([
                'success' => false, 
                'message' => 'Invalid coin, coinpair, or direction IDs', 
                'coin_id' => $coin_id, 
                'coinpair_id' => $coinpair_id, 
                'direction_id' => $direction_id, 
                'account_id' => $account_id
            ]);
        }
    } else {
        echo json_encode(['success' => false, 'message' => 'Account not found']);//kļūdas ziņojums
    }
} else {
    echo json_encode(['success' => false, 'message' => 'Invalid input']);//kļūdas ziņojums
}
// aizvert konekciju
$conn->close();
?>
