<?php
//Autors: Ralfs Riters; "Subkonta" izveides php datne;
//Veidots: 2024. gadā, Jaunākā versija

// konekcijas piesaiste
include('connection.php');

// izgūst konta nosaukumu un profil ID, saglabā to lokāli mainīgajos
if (isset($_POST['account_name']) && isset($_POST['profile_id'])) {
    $account_name = $_POST['account_name'];
    $profile_id = $_POST['profile_id'];
    
    // vaicājums eksistējoša konta pārbaidei izmantojot profila ID un konta nosaukumu
    $check_stmt = $conn->prepare("SELECT 1 FROM rr_410_accounts WHERE profile_id = ? AND account_name = ?");
    $check_stmt->bind_param("is", $profile_id, $account_name);//nodod profila id un konta nosaukumu
    $check_stmt->execute();
    $result = $check_stmt->get_result();//saglabā rezultātus

    if ($result->num_rows > 0) { //atsrats kāds konts tatad paziņo, ka tāds jau eksistē
        echo "Account name already exists. Please submit a new name!";//paziņojums
    } else {
        //ja nav šāda konta tad atļauj to veidot un reģistrē datubāzē jauno konta nosuakumu attiecīgajam profila ID
        $insert_stmt = $conn->prepare("INSERT INTO rr_410_accounts (profile_id, account_name) VALUES (?, ?)");
        $insert_stmt->bind_param("is", $profile_id, $account_name); //nodod profila id un konta nosaukumu
        
        if ($insert_stmt->execute()) {
            echo "New subaccount created successfully.";//veiksmīgs ziņojums
        } else {
            echo "Error: " . $conn->error;//kļūdas ziņojums
        }
        $insert_stmt->close();
    }

    // aizvert konekciju
    $check_stmt->close();
    $conn->close();
} else {
    echo "Invalid input";//kļūdas ziņojums
}
?>
