<?php
//Autors: Ralfs Riters; Konkrēta darījuma informācijas iegūšanas php datne;
//Veidots: 2024. gadā, Jaunākā versija

// konekcijas piesaiste
include('connection.php');

// iegūst konrēta darījuma ID
$tradeId = $_GET['trade_id'] ?? '';

if ($tradeId) {
    // pēc darījuma ID izgūst visu informāciju par to
    $stmt = $conn->prepare('
        SELECT 
            h.trade_id,
            c.coin_name,
            cp.coinpair_name,
            d.direction,
            h.leverage,
            h.open_price,
            h.close_price,
            h.percents,
            h.close_date,
            h.photo
        FROM rr_410_history_input h
        JOIN rr_410_coin c ON h.coin_id = c.coin_id
        JOIN rr_410_coinpair cp ON h.coinpair_id = cp.coinpair_id
        JOIN rr_410_direction d ON h.direction_id = d.direction_id
        WHERE h.trade_id = ?
    ');
    $stmt->bind_param('i', $tradeId); //nodod darījuma ID
    $stmt->execute();
    $result = $stmt->get_result(); //sagalbā info
    $tradeDetails = $result->fetch_assoc();
    
    if ($tradeDetails) {
        echo json_encode($tradeDetails);  // nosūta rezultātu kā JSON
    } else {
        echo json_encode(['error' => 'Trade not found']); //kļūdas ziņojums
    }

    $stmt->close();
} else {
    echo json_encode(['error' => 'No trade ID provided']);//kļūdas ziņojums
}
// aizvert konekciju
$conn->close();
?>
