<?php
//Autors: Ralfs Riters; Valūtu nosaukumu iegūšanas php datne;
//Veidots: 2024. gadā, Jaunākā versija

// konekcijas piesaiste
include('connection.php');

// iegūst profila ID un konta nosaukumu
$account_name = $_GET['account_name'] ?? null;
$profile_id = $_GET['profile_id'] ?? null;

    // izgūst konta ID no datubāzes izmantojot konta nosaukumu un profila ID
$account_query = "SELECT account_id FROM rr_410_accounts WHERE account_name = ? AND profile_id = ?";
$stmt = $conn->prepare($account_query);
$stmt->bind_param("si", $account_name,$profile_id);// nodod konta osaukumu un profila ID
$stmt->execute();
$result = $stmt->get_result();// saglabā rezultātu
$account_data = $result->fetch_assoc();

if (!$account_data) {
    echo json_encode(['error' => 'Account not found']);//kļūdas ziņojums
    http_response_code(404);
    exit;
}

$account_id = $account_data['account_id']; //salīdzina mainīgos

// pēc konta ID iegūst kriptovalūtu un darījuma valūtu ID
$history_query = "SELECT coin_id, coinpair_id FROM rr_410_history_input WHERE account_id = ?";//vaicājums
$stmt = $conn->prepare($history_query);
$stmt->bind_param("i", $account_id); //nodod konta ID
$stmt->execute();
$result = $stmt->get_result(); //saglabā rezultātus

$coin_ids = [];//veido masivu
$coinpair_ids = [];//veido masivu
while ($row = $result->fetch_assoc()) {
    $coin_ids[] = $row['coin_id'];  //piešķir vērtības masīvam
    $coinpair_ids[] = $row['coinpair_id'];//piešķir vērtības masīvam
}

//pārveido ID par jauniem ID lai nebūtu pārklāšanās
$coin_ids = array_unique($coin_ids);
$coinpair_ids = array_unique($coinpair_ids);

// Pēc konkrētājiem ID iegūst atbilstošos kriptovalūtu nosaukumus
if (!empty($coin_ids)) {
    $placeholders = implode(',', array_fill(0, count($coin_ids), '?'));
    $coin_query = "SELECT coin_name FROM rr_410_coin WHERE coin_id IN ($placeholders)";//vaicājums
    $stmt = $conn->prepare($coin_query);
    $stmt->bind_param(str_repeat('i', count($coin_ids)), ...$coin_ids);//nodod ID
    $stmt->execute();
    $result = $stmt->get_result();//sagalbā rezultātu

    $coins = []; //izveido un piepilda masīvu ar nosaukumiem
    while ($row = $result->fetch_assoc()) {
        $coins[] = $row['coin_name'];
    }
} else {
    $coins = [];
}

// Pēc konkrētājiem ID iegūst atbilstošos darījuma valūtu nosaukumus
if (!empty($coinpair_ids)) {
    $placeholders = implode(',', array_fill(0, count($coinpair_ids), '?'));
    $coinpair_query = "SELECT coinpair_name FROM rr_410_coinpair WHERE coinpair_id IN ($placeholders)";// vaicājums
    $stmt = $conn->prepare($coinpair_query);
    $stmt->bind_param(str_repeat('i', count($coinpair_ids)), ...$coinpair_ids);//nodod ID
    $stmt->execute();
    $result = $stmt->get_result();//saglabā rezultātu

    $coinpairs = [];//izveido un piepilda masīvu ar nosaukumiem
    while ($row = $result->fetch_assoc()) {
        $coinpairs[] = $row['coinpair_name'];
    }
} else {
    $coinpairs = [];
}

// atgriež inoformāciju kā JSON
echo json_encode(['coins' => $coins, 'coinpairs' => $coinpairs]);

// aizvert konekciju
$conn->close();
?>
