<?php
//Autors: Ralfs Riters; Darījuma dzēšanas php datne;
//Veidots: 2024. gadā, Jaunākā versija

// konekcijas piesaiste
include('connection.php');

// iegūst datus uz php
$input = json_decode(file_get_contents('php://input'), true);

//pārbauda vai pieejams darījums ID
if (isset($input['trade_id'])) {
    $tradeId = $input['trade_id'];

    // dzēš ierakstu no datubāzes pēc darījuma ID
    $stmt = $conn->prepare('DELETE FROM rr_410_history_input WHERE trade_id = ?');
    $stmt->bind_param('i', $tradeId); //padod darījuma ID

    if ($stmt->execute()) {
        echo json_encode(['success' => true,'deleted' => 'Trade deleted successfully!']); //veiksmīgs ziņojums
    } else {
        echo json_encode(['success' => false, 'error' => 'Failed to delete trade.']); //kļūdas ziņojums
    }

    $stmt->close();
} else {
    echo json_encode(['success' => false, 'error' => 'No trade ID provided.']); //klūdas ziņojums
}

// aizvert konekciju
$conn->close();
?>
