<?php
//Autors: Ralfs Riters; "Subkonta" dzēšanas php datne;
//Veidots: 2024. gadā, Jaunākā versija

// konekcijas piesaiste
include('connection.php');

//pārbauda vai profila ID un konta nosaukums ir pieejams caur POST metodi
if (isset($_POST['account_name']) && isset($_POST['profile_id'])) {
    $account_name = $conn->real_escape_string($_POST['account_name']);//konta nosaukums
    $profile_id = $conn->real_escape_string($_POST['profile_id']);// profila ID

    // izgūst konta ID no satubāzes izmantojot konta nosaukumu un profila ID
    $stmt = $conn->prepare("SELECT account_id FROM rr_410_accounts WHERE account_name = ? AND profile_id = ?");//vaicājums
    $stmt->bind_param('ss', $account_name, $profile_id);
    $stmt->execute();
    $stmt->bind_result($account_id); //sagalbā atbildi mainīgajā
    $stmt->fetch();
    $stmt->close();

    if ($account_id) {
        //dzēš ierakstus datubāzē konkrētajam konta ID
        $stmt = $conn->prepare("DELETE FROM rr_410_history_input WHERE account_id = ?"); //dzēšana izpilde
        $stmt->bind_param('i', $account_id); //padod konta ID
        $stmt->execute();
        $stmt->close();

        // Dzēš pašu kontu
        $stmt = $conn->prepare("DELETE FROM rr_410_accounts WHERE account_id = ?"); //dzēš kontu pēc tā ID
        $stmt->bind_param('i', $account_id); //padod konta ID
        $stmt->execute();
        $stmt->close();

        echo json_encode(["success" => "Account and history deleted successfully!"]); //veiksmīgs paziņojums
    } else {
        echo json_encode(["error" => "Account not found"]); //kļūdas paziņojums
    }
 // aizvert konekciju
    $conn->close();
} else {
    echo json_encode(["error" => "Invalid input"]); //kļūdas paziņojums
}
