//Autors: Ralfs Riters; JS datne, konkrēta darījuma informācijas loga izveide/piepildīšana, indfromācijas redīģēšanas funkcijas;
//Veidots: 2024. gadā, Jaunākā versija

document.addEventListener('DOMContentLoaded', function () {
    // izveido elementus kuriem piešķir jau eksistējošas vērtības, tālākais izmantošanai
    const tradeInfoModal = document.getElementById('tradeInfoModal'); 
    const tradeInfoContent = document.getElementById('trade-info-content');
    const closeInfoButton = document.getElementById('close-info-button');
    const editTradeButton = document.getElementById('edit-trade-button');
    const saveTradeButton = document.getElementById('save-trade-button');
    let currentTradeId = null; 
    let initialValues = {};
    let currentTradeDetails = null; 

    //funkcija, kas atjauno visu pogu darbību klausītājus, lai netiktu atkārtota kāda darbība no iepriekšējām reizēm.
    function cleanupListeners() {
        console.log("Removing all event listeners");
        closeInfoButton.removeEventListener('click', closeModal);
        editTradeButton.removeEventListener('click', handleEditClick);
        saveTradeButton.removeEventListener('click', saveTradeChanges);
    }

    // funkcija kas nostrādā verot ciet logu, izsauc funkciju kas notīra darbību klausītājus
    function closeModal() {
        console.log("Closing modal and cleaning up listeners");
        cleanupListeners();// klasītāju tīrīšanas funkcija
        tradeInfoModal.style.display = 'none'; // paslēpj, jeb noņem logu
    }

    // funkcija, kas izgūst konkrētā darījuma informāciju un ievada to logā
    async function fetchTradeInfo(tradeId) {
        currentTradeId = tradeId; // iegūst darījuma ID
    
        try {
            const response = await fetch(`../php/get_trade_info.php?trade_id=${tradeId}`); //izsauc PHP pilnās darījuma informācijas iegūšanai izmantojot savākto darījuma ID
            const tradeDetails = await response.json(); //gaida atbildi JSON
    
            if (tradeDetails.error) {
                tradeInfoContent.innerHTML = `<p>${tradeDetails.error}</p>`; // kļūdas ziņojums
            } else {
                // veiksmīgs atgrieztais rezultāts
                tradeDetails.open_price = parseFloat(tradeDetails.open_price).toString(); //pārveido atvēršanas cenu uz teksta formātu
                tradeDetails.close_price = parseFloat(tradeDetails.close_price).toString();//pārveido aizvēršanas cenu uz teksta formātu
    
                currentTradeDetails = tradeDetails; // saglabā iegūto informāciju lokālā mainīgajā
    
                // izveido html struktūru un piešķir nepieciešamo informāciju konkrētajiem laukiem, divas kolonas ar laukiem
                tradeInfoContent.innerHTML = `
                    <div id="info-container">
                     <div id="info-container-rows">
                    <div id="info-column-1">
                        <label class="info-caption"><p>Crypto:</p></label>
                        <span class="info-values" id="coin-name">${tradeDetails.coin_name}</span> 
                        <label class="info-caption"><p>Open Price:</p></label>
                        <span class="info-values" id="open-price">${tradeDetails.open_price}</span>
                        <label class="info-caption"><p>Direction:</p></label>
                        <span class="info-values" id="direction">${tradeDetails.direction}</span>
                        <label class="info-caption"><p>Close Date:</p></label>
                        <span class="info-values" id="close-date">${tradeDetails.close_date}</span>
                    </div>
                    <div id="info-column-2">
                        <label class="info-caption"><p>Currency:</p></label>
                        <span class="info-values" id="coinpair-name">${tradeDetails.coinpair_name}</span>
                        <label class="info-caption"><p>Close Price:</p></label>
                        <span class="info-values" id="close-price">${tradeDetails.close_price}</span>
                        <label class="info-caption"><p>Leverage:</p></label>
                        <span class="info-values" id="leverage">${tradeDetails.leverage}</span>
                        <label class="info-caption"><p>Percents:</p></label>
                        <span class="info-values-percent" id="percents">${tradeDetails.percents}%</span>
                    </div>
                    </div>
                        ${tradeDetails.photo ? `<img id="photo" src="../photo/${tradeDetails.photo}" alt="Trade Photo" />` : ''}
                    </div>
                `;
    
                // nodrošina pareizās pogas parādīšanos un paslepšano vajadzīgajā momentā - save poga pazūd un parādās edit, kad tiek iesniegta jaunā informācija
                editTradeButton.style.display = 'block'; // parāda 
                saveTradeButton.style.display = 'none'; // Hide the "Save" button
    
                cleanupListeners(); // notīra darbību klausītājus, lai novērtsu "loopošanu"
    
                // pievieno jaunus vajadzīgos darbību klasītājus
                closeInfoButton.addEventListener('click', closeModal);
                editTradeButton.addEventListener('click', handleEditClick);
            }
            
            tradeInfoModal.style.display = 'block'; // parāda logu
        } catch (error) {
            console.error('Error fetching trade details:', error); // kļūdas ziņojums
        }
    }

    //funkcija edit pogas piespiešanas gadījumam
    function handleEditClick() {
        console.log("Edit button clicked"); //ziņojums debugošanai
        enableEditMode(currentTradeDetails); // aktivizē pārmaiņu veikšanas iespēju informācijā

        // pārliecinās, ka tikai vienu reizi nostrādā save poga (produkta tapšanas procesā kļuva skaidrs ka šis ir būtiski nepieciešms, lai nerastios nejaušas kļūmes)
        saveTradeButton.removeEventListener('click', saveTradeChanges);
        saveTradeButton.addEventListener('click', saveTradeChanges);
    }

    // funkcija, kas pārmaina teksta laukus uz ievadlaukiem saglabājot tekstu tajās
    function enableEditMode(tradeDetails) {
        const editValues = document.querySelectorAll(".info-values");
       
        // nozīmē pareizas atstarpes
        editValues.forEach(el => {
            el.style.paddingLeft = "0"; 
        });

        // dinamsiki teksta laukus pārveido par ievadlaukiem
        document.getElementById('coin-name').innerHTML = `<input class="edit-input" type="text" id="edit-coin-name" value="${tradeDetails.coin_name}">`;
        document.getElementById('coinpair-name').innerHTML = `<input class="edit-input" type="text" id="edit-coinpair-name" value="${tradeDetails.coinpair_name}">`;
        document.getElementById('direction').innerHTML = `
            <select class="edit-input" id="edit-direction">
                <option value="1" ${(tradeDetails.direction === '1' || tradeDetails.direction === 'Long') ? 'selected' : ''}>Long</option>
                <option value="2" ${(tradeDetails.direction === '2' || tradeDetails.direction === 'Short') ? 'selected' : ''}>Short</option>
            </select>
        `;
        document.getElementById('leverage').innerHTML = `<input class="edit-input" type="number" id="edit-leverage" value="${tradeDetails.leverage}">`;
        document.getElementById('open-price').innerHTML = `<input class="edit-input" type="number" id="edit-open-price" value="${tradeDetails.open_price}">`;
        document.getElementById('close-price').innerHTML = `<input class="edit-input" type="number" id="edit-close-price" value="${tradeDetails.close_price}">`;
        document.getElementById('close-date').innerHTML = `<input class="edit-input" type="date" id="edit-close-date" value="${tradeDetails.close_date}">`;

        // noņem edit pogas redzamību un aktivizē save pogas redzamību
        editTradeButton.style.display = 'none'; // Hide "Edit" button
        saveTradeButton.style.display = 'block'; // Show "Save" button
    }

    // funkcija izmaiņu saglabāšsnai
    async function saveTradeChanges() {
        console.log("Save button clicked"); //debugošanas paziņojums konsolē
        const updatedTradeData = {};//mainīgais kurā paglabat atjaunoto info
        const updatedFields = { //atjaunotā info pieškīršana attiecīgajiem laukiem
            coin_name: document.getElementById('edit-coin-name').value,
            coinpair_name: document.getElementById('edit-coinpair-name').value,
            direction: document.getElementById('edit-direction').value,
            leverage: document.getElementById('edit-leverage').value,
            open_price: parseFloat(document.getElementById('edit-open-price').value.replace(',', '.')).toString(),
            close_price: parseFloat(document.getElementById('edit-close-price').value.replace(',', '.')).toString(),
            close_date: document.getElementById('edit-close-date').value,
        };

        // saglabā tikai izmainītās vērtības un pārējās patur vecās, lai nejauktu vecās bez vajadzības
        for (const [key, value] of Object.entries(updatedFields)) {
            if (value !== initialValues[key]) {
                updatedTradeData[key] = value;
            }
        }
        updatedTradeData.trade_id = currentTradeId; //piešķir jaunās vērtības  konkretam darījuma id

        try {
            const response = await fetch('../php/update_trade_info.php', {//izsauc PHP vērtību atjaunošanai
                method: 'POST', //metode POST
                headers: { 'Content-Type': 'application/json' },
                body: JSON.stringify(updatedTradeData), //nosūta JSON
            });

            const result = await response.json(); //atbilde JSON
            if (result.success) {
                alert('Trade updated successfully.'); //veiksmīgs paziņojums
                closeModal(); // aizver logu ciet
                window.dispatchEvent(new Event('updateTable')); // Tizveido jaunu notikumu laiizsauktu tabulas atjaunošanu
            } else {
                alert('Error updating trade: ' + result.error); //kļūdas ziņojums
            }
        } catch (error) {
            console.error('Error updating trade:', error);//kļūdas ziņojums
        }
    }

    // klausās, kad tiks nospiesta kāda konkrēta tabulas rinda
    window.addEventListener('tradeRowClicked', (e) => {
        console.log("Trade row clicked, fetching trade info"); //paziņojums debugošanai
        fetchTradeInfo(e.detail); // izsauc informācijas iegušanas funkciju konkrētajai nospiestajai rindai tabulā
    });
});
