//Autors: Ralfs Riters; JS datne, "subkontu" lapas funkcijas un "subkonta" izveides funkcijas;
//Veidots: 2024. gadā, Jaunākā versija

document.addEventListener('DOMContentLoaded', function () {
    // tiek iegūti lietotāja profila ID un epasta dati lai tos varētu izmanotot funkcijās
    const userEmail = document.getElementById("user-email").getAttribute("data-email");
    const profileId = document.getElementById("profile_id").getAttribute("data-profile-id");

    //iegūst nepieciešamos elementus ar to ID lai veiktu tālākas darbības
    const createButton = document.getElementById('create-object-btn');
    const objectsContainer = document.getElementById('objects-container');
    const popupDialog = document.getElementById('popup-dialog'); 
    const confirmBtn = document.getElementById('confirm-btn');
    const cancelBtn = document.getElementById('cancel-btn'); 
    const objectNameInput = document.getElementById('object-name-input');

    // Funkcija lai iegūtu jau eksistējošos kontus no datubazes
    function fetchExistingObjects() {
        fetch("../php/get_accounts.php", {//izsauc php failu
            method: "POST", //metode POST  
            body: new URLSearchParams({
                profile_id: profileId // sūta profila ID uz PHP
            })
        })
            .then(response => response.json()) //atgriež info no PHP un glabā JSON
            .then(data => {
                if (!data.error) {
                    // Aizveido sarakstu ar kontu nosaukumiem
                    data.forEach(accountName => addObjectToContainer(accountName));
                }
            })
            .catch(error => console.error("Error fetching accounts:", error)); //kļūdas paziņojums
    }

    // funkcija kas veido elementu sarakstu, jeb kontu sarakstu
    function addObjectToContainer(accountName) {
        const objectBox = document.createElement('div'); //izveido konteineri elementam
        objectBox.classList.add('object-box');

        const textBox = document.createElement('div'); //izveido elementa nosaukuma vietu
        textBox.textContent = accountName; //pievieno nosaukumu šai vietai
        textBox.classList.add('text-box');

        // katram elementam izveido savu dzēšanas pogu
        const deleteBtn = document.createElement('button');
        deleteBtn.innerHTML = '<i class="fas fa-trash"></i>'; // piešķir miskastes ikonu
        deleteBtn.classList.add('delete-btn');

        // piešķir tekstu un ikonu konk;retajiem elementiem
        objectBox.appendChild(textBox);
        objectBox.appendChild(deleteBtn);
        objectsContainer.appendChild(objectBox);

        objectBox.style.cursor = 'pointer'; //piešķir kursoram stilu
        objectBox.addEventListener('click', function () { //gaida kad piespiedīs kādu elementu
            sessionStorage.setItem('email', userEmail); // saglabā epastu
            sessionStorage.setItem('profile_id', profileId); // saglabā profila ID
            sessionStorage.setItem('account_name', accountName); // saglabā konta nosaukumu

            // pārvieto lietotāju uz galveno lapu
            window.location.href = "../html/history.html";
        });

        // elementa jeb konta dzēšana
        deleteBtn.addEventListener('click', function (e) {
            e.stopPropagation();
            if (confirm("Are you sure you want to delete this account?")) {//apstirptinajums
                deleteAccount(accountName, profileId, objectBox); // konta dzēšanas funkcijas izsaukšana
            }
        });
    }

    // funkcija lai dzēstu kontu no datubāzes
    function deleteAccount(accountName, profileId, objectBox) {
        fetch("../php/delete_account.php", { //izsaucphp konta dzēšanai
            method: "POST",
            body: new URLSearchParams({
                account_name: accountName, // nosūta konta nosaukumu
                profile_id: profileId // nosūta profila ID
            })
        })
            .then(response => response.json()) //atbilde JSON
            .then(data => {
                if (data.success) {
                    alert(data.success); // paziņojums par veiksmīgu dzēšanu
                    objectsContainer.removeChild(objectBox); // noņem konta elementu no saraksta
                } else if (data.error) {
                    alert(data.error); // kļūdas paziņojums
                }
            })
            .catch(error => console.error("Error deleting account:", error)); // kļūdas paziņojums
    }

    // izsauc eksistējošo kontu elementu srakasta parādīšanos lapu ielādējot
    fetchExistingObjects();

    // Parāda juna konta pievienošanas logu kad tiek piespiesta pievienošanas poga
    createButton.addEventListener('click', function () {
        popupDialog.style.display = 'flex';
    });

    // Aizver konta pievienošanas logu un notīra ievadlauku kad nospiesta poga Cancel
    cancelBtn.addEventListener('click', function () {
        popupDialog.style.display = 'none';
        objectNameInput.value = '';
    });

    // jauna konta izveides funkcija
    confirmBtn.addEventListener('click', function () {
        const accountName = objectNameInput.value; // iegūst nosaukumu no ievadlauka
        if (accountName) {
            fetch("../php/register_account.php", { // izsauc PHP jauna konta reģistrēšanai
                method: "POST", //metode POST
                body: new URLSearchParams({
                    account_name: accountName, // nosūta konta nosaukumu
                    profile_id: profileId // nosūta profila ID
                })
            })
                .then(response => response.text()) //atgūst atbildi
                .then(serverMessage => {
                    if (serverMessage.includes("Account name already exists")) { //paziņojums ka šads konts jau eksistē
                        alert(serverMessage); //parāda ziņojumu
                    } else if (serverMessage.includes("New subaccount created successfully")) { //paziņojums par veiksmīgu konta izveidi
                        addObjectToContainer(accountName); //pievieno jauno kontu elementu sarakstam
                        popupDialog.style.display = 'none'; // paslēpj pievienošanas logu
                        objectNameInput.value = ''; // notīra ievadlauku
                    } else {
                        console.error("Unexpected server response:", serverMessage); //parāda klūdas ziņojumu
                    }
                })
                .catch(error => console.error("Error creating account:", error));//parāda klūdas ziņojumu
        } else {
            alert('Please enter a valid name!'); // //parāda ziņojumu, ka jāievada korekts vārds ievadlaukā
        }
    });
});
