
//Autors: Ralfs Riters; JS datne, kas nodrošina darījuma pievienošanu'
// a;
//Veidots: 2024. gadā, Jaunākā versija

// Atpakaļ pogas funkcionalitāte, lai atvirzītos atpakaļ galveno lapu
document.getElementById('back-button').addEventListener('click', function () {
    window.history.back(); 
});

// Importē valūtu izvēlnes izveides funkciju
import { populateDropdowns } from './get_coin_names.js';
//Uzlecošā loga aktivizēšanas mainīgie
const modal = document.getElementById('tradeModal'); 
const openButton = document.getElementById('open-form-button'); 
const formContainer = document.getElementById('form-container'); 

/**
 * Ielādē darījumu pievienošanas ievadformu uzlecošajā logā un iestata tās funkcionalitāti
 */
function loadTradeForm() {
    fetch('../html/register_trade.html') // iegūst formu no HTML faila
        .then(response => response.text())
        .then(html => {
            formContainer.innerHTML = html; // ielādē formu iekš konteinera
            modal.style.display = 'block'; // parāda uzlecošo  logu

            // tiek izsaukta funkcija valūtu nosaukumu izvēlnes aizpildīšanai
            populateDropdowns();

            // iestata noklusējuma vērtības ievades laukiem
            const leverageInput = document.getElementById('leverage');
            leverageInput.value = 1; // noklusējuma darījuma pleca vērtība
            leverageInput.min = 1; // minimālā vērtība plecam

            const closeDate = document.getElementById('close_date');
            closeDate.valueAsDate = new Date(); // iestata darījuma slēgšanas noklusējuma datumu, kā pašreizējās dienas datumu
            closeDate.max = closeDate.value; // maksimālais datums ir līdz pašreizējās dienas datumam

            const openPrice = document.getElementById('open_price');//kriptovalūtas cena darījuma atvēršanas brīdī
            const closePrice = document.getElementById('close_price'); //kriptovalūtas cena darījuma aizvēršanas brīdī

// funkcija, kas nodrošina, ka kommati skaitļos tiek pārrakstīti kā punkti, tālākām darbībām
function normalizeInput(value) {
    return value.replace(/,/g, '.'); // Replace all commas with periods
}

// funkcija lai pārbaud;ītu ka skaitļu (cenu) vietā netiek rakstīts kas neiespējams vai ne-skaitlis
function handleInput(event) {
    let inputValue = event.target.value;

    // atļauj tikai ciparus punktus un kommatus
    inputValue = inputValue.replace(/[^0-9.,]/g, '');

    // izsauc funkciju, kas kommatus pārvērš punktos
    inputValue = normalizeInput(inputValue);

    // pārbaudā vai skaitlis nav negatīvs
    if (!isNaN(inputValue) && inputValue >= 0) {
        event.target.value = inputValue;
    } else {
        // ja kautkas nav pareizi ievadītais tiek dzēsts
        event.target.value = '';
    }
}

            openPrice.addEventListener('input', handleInput);//pārbauda kad tiek aktivizēts lauks
            closePrice.addEventListener('input', handleInput);//pārbauda kad tiek aktivizēts lauks



            // Aizver uzlecošo logu, kad tiek nospiesta aizvēršanas poga
            document.getElementById('close-form-button').addEventListener('click', function () {
                modal.style.display = 'none'; 
            });

            // Iestata  formas nosūtīšanas loģiku
            document.getElementById('trade-form').addEventListener('submit', function (event) {
                event.preventDefault(); // Novērš noklusējuma formas iesniegšanu

                // Savāc formas datus
                const coin = document.getElementById('coin').value; // kriptovalūta
                const coinPair = document.getElementById('coinpair').value; // darījuma valūta
                const direction = document.getElementById('direction').value; // darījuma virziens
                const openPrice = document.getElementById('open_price').value; // darījuma atvēršanas cena
                const closePrice = document.getElementById('close_price').value; // darījuma slēgšanas cena
                const leverage = document.getElementById('leverage').value; // darījuma plecs
                const closeDate = document.getElementById('close_date').value; // darījuma slēgšanas datums
                const photo = document.getElementById('photo').files[0]; // pievienotais foto
                const accountName = document.getElementById('account_name').innerText; // konta nosaukums
                const profileId = document.getElementById('profile_id').innerText; // profila ID

                const formData = new FormData(); // Izveido jaunu objektu kurš savāc sevī visu informāciju
                formData.append('coin', coin); // Pievieno monētu
                formData.append('coinpair', coinPair); // Pievieno monētu pāri
                formData.append('direction', direction); // darījuma virziens
                formData.append('open_price', openPrice); // darījuma atvēršanas cena
                formData.append('close_price', closePrice); // darījuma slēgšanas cena
                formData.append('leverage', leverage); // darījuma plecs
                formData.append('close_date', closeDate); // darījuma slēgšanas datums
                formData.append('photo', photo); // pievienotais foto
                formData.append('account_name', accountName); // konta nosaukums
                formData.append('profile_id', profileId); // profila ID

                // nosūta formas datus uz PHP reģistrēšanai datu bāzē
                fetch('../php/register_trade.php', {
                    method: 'POST',
                    body: formData 
                })
                    .then(response => {
                        if (!response.ok) {
                            throw new Error('Network response was not ok ' + response.statusText); // kļūdas paziņojums
                        }
                        return response.json(); // atgriež atbildi JSON formātā
                    })
                    .then(data => {
                        if (data.success) {
                            alert("Trade data successfully registered."); // paziņojums par veiksmīgu datu reģistrāciju
                            document.getElementById('trade-form').reset(); // notīra formas laukus
                            leverageInput.value = 1; // Atjauno pleca vērtību uz noklusējumu
                            modal.style.display = 'none'; // Aizver uzlecošo logu

                            //izveiodo elementu lai atjauno darījumu vēstures tabulu
                            window.dispatchEvent(new Event('updateTable'));
                        } else {
                            alert("Error: " + data.message); // kļūdas paziņojums
                        }
                    })
                    .catch(error => {
                        console.error('There was a problem with the fetch operation:', error); // kļūdas paziņojums
                        alert('Error: ' + error.message); // kļūdas paziņojums
                    });
            });
        })
        .catch(error => console.error('Error loading trade form:', error)); // kļūdas paziņojums
}

// Atver uzlecošio logu darījuma pievienošanai
openButton.addEventListener('click', loadTradeForm); // Aktivizē funkciju, lai ielādētu formu
