//Autors: Ralfs Riters; JS datne,nodrošina lietotāja reģistrēšanu, visi reģistrēšanās kritēriji;
//Veidots: 2024. gadā, Jaunākā versija

document.addEventListener('DOMContentLoaded', function () {
    //iegūst nepieciešamos elementus ar to ID lai veiktu tālākas reģistrācijas darbības
    const form = document.getElementById('loginForm'); 
    const passwordInput = document.getElementById('password');
    const confirmPasswordInput = document.getElementById('confirmPassword'); 
    const errorMessage = document.getElementById('error-message'); 
    const requirementsDiv = document.getElementById('password-requirements');

    requirementsDiv.style.display = 'block'; // Sākotnēji parāda paroles kritērijus uz ekrāna

    const validateInputs = () => {
        const password = passwordInput.value; // iegūst paroli no tās ievadlauka
        const confirmPassword = confirmPasswordInput.value; // iegūst atkārtoto paroli no tās ievadlauka

        // pārbauda paroles kritērijus
        const lengthRequirement = password.length >= 9; // pārbauda vai parole ir vismaz 9 simbolus gara
        const capitalRequirement = /[A-Z]/.test(password); // pārbauda vai parolē ir vismaz viens lielais burts
        const numberRequirement = /\d/.test(password); // pārbauda vai parolē ir vismaz viens cipars
        const passwordsMatch = password === confirmPassword; // pārbauda vai abas paroles ir vienādas

        // Pēc paroles kritērija izpildīšanas atjauno kritēriju uz zaļu krāsu no sarkanas un otrādi ja netiek izpildīts kritērijs
        document.getElementById('length-requirement').style.color = lengthRequirement ? 'green' : 'red'; // regulē paroles garuma kritērija krāsu
        document.getElementById('capital-requirement').style.color = capitalRequirement ? 'green' : 'red'; // regulē paroles lielā burta kritērija krāsu
        document.getElementById('number-requirement').style.color = numberRequirement ? 'green' : 'red'; // regulē paroles cipara kritērija krāsu

        // ja viss atbilst tad paslēpj paroles kritēriju logu
        if (lengthRequirement && capitalRequirement && numberRequirement) {
            requirementsDiv.style.display = 'none'; // paslēpj ja visi kritēriji izpildīti
        } else {
            requirementsDiv.style.display = 'block'; // parāda ja kāds kritērijs nav izpildīts
        }

        // parāda paziņojumu par abu paroļu nesakritību
        if (!passwordsMatch) {
            errorMessage.innerText = 'Passwords do not match!'; // ziņojums
            errorMessage.style.display = 'block'; // ziņojums tiek parādīts
        } else {
            errorMessage.style.display = 'none'; // ziņojums tiek paslēpts
        }

        // atgriež tikai tad ja viss viss ir izpildīts
        return lengthRequirement && capitalRequirement && numberRequirement && passwordsMatch;
    };

    // gaida ievadformas iesniegšanu
    form.addEventListener('submit', function (event) {
        if (!validateInputs()) {
            // nepieļauj neaizpildītas formas iesniegšanu
            event.preventDefault();
        }
    });

    // pārbauda paroles kritērijus katru reizi kad tiek ievadīts kāds simbols vai veikta darbība
    passwordInput.addEventListener('input', validateInputs);

    // pārbauda paroles sakritību katru reizi kad tiek ievadīts kāds simbols vai veikta darbība
    confirmPasswordInput.addEventListener('input', validateInputs);
});
