//Autors: Ralfs Riters; JS datne, galvenās lapas tabulas aizpildīšanas funkcijas, lapu pāršķiršanas funkcijas, 
// filtrēšanas funkcijas; darījumu dzēšanas funkcijas;
//Veidots: 2024. gadā, Jaunākā versija

// Importē nepieciešamās funkcijas no citas vietas kodā
import { populateDropdowns } from './get_coin_names.js';

// Kad lapa ir pilnībā ielādēta
document.addEventListener('DOMContentLoaded', () => {
    const email = sessionStorage.getItem('email'); // Iegūst e-pastu no sessionStorage
    const profileId = sessionStorage.getItem('profile_id'); // Iegūst profila ID no sessionStorage
    const accountName = sessionStorage.getItem('account_name'); // Iegūst konta nosaukumu no sessionStorage

    // Ja visi dati ir pieejami, iestata tos HTML elementos
    if (email && profileId && accountName) {
        document.getElementById('email').textContent = email;
        document.getElementById('profile_id').textContent = profileId;
        document.getElementById('account_name').textContent = accountName;

        populateDropdowns(); // Tiek izsaukta funkcija valūtu nosaukumu izvēlnes aizpildīšanai visās tam nepieciešamajās vietās

        // Pārsūta konta dati tiek nosūtīti darījumu vēstures iegūšanas funkcijai
        fetchTradeHistory(accountName, profileId);

        // Definēti mainīgie filtrēšanas realizēšanai
        const filterModal = document.getElementById('filterModal');
        const applyFilterButton = document.getElementById('apply-filter-button');
        const closeFilterButton = document.getElementById('close-filter-button');
        const clearAllFiltersButton = document.getElementById('clear-all-filters-button');
        const clearCoinNameFilterButton = document.getElementById('clear-coin-name-filter');
        const clearDirectionFilterButton = document.getElementById('clear-direction-filter');
        const clearPercentageFilterButton = document.getElementById('clear-percentage-filter');

        // Atver filtra uzlecošo logu, kad tiek piepsiesta filtrācijas poga
        document.getElementById('filter-button').addEventListener('click', () => {
            filterModal.style.display = 'block';
        });

        // Aizver filtra uzlecošo logu, kad tiek piepsiesta aizvēršanas poga
        closeFilterButton.addEventListener('click', () => {
            filterModal.style.display = 'none';
        });

       // Aizver filtra uzlecošo logu, kad tiek aktivizēti filtri ar aktivizēšanas pogu
        applyFilterButton.addEventListener('click', () => {
            applyFilters(accountName, profileId);
            filterModal.style.display = 'none'; // Aizver modālu logu
        });

        // Notīra konkrētu filtru - kriptovalūtu nosaukumu filtru
        clearCoinNameFilterButton.addEventListener('click', () => {
            document.getElementById('coin').value = '';
            fetchTradeHistory(accountName, profileId); // Pārlādē darījumu vēsturi bez konkrētā filtra
        });

       // Notīra konkrētu filtru - darījuma virziena filtru
        clearDirectionFilterButton.addEventListener('click', () => {
            document.getElementById('direction-filter').value = '';
            fetchTradeHistory(accountName, profileId);// Pārlādē darījumu vēsturi bez konkrētā filtra
        });

        // Notīra konkrētu filtru - darījuma procentu filtru
        clearPercentageFilterButton.addEventListener('click', () => {
            document.getElementById('percentage-filter').value = '';
            fetchTradeHistory(accountName, profileId);// Pārlādē darījumu vēsturi bez konkrētā filtra
        });

        // Notīra visus pielietotos filtrus
        clearAllFiltersButton.addEventListener('click', () => {
            document.getElementById('coin').value = '';
            document.getElementById('direction-filter').value = '';
            document.getElementById('percentage-filter').value = '';
            fetchTradeHistory(accountName, profileId);// Pārlādē darījumu vēsturi bez neviena filtra
        });
    } else {
        console.error("No data found!"); // Kļūdas paziņojums
    }
});

// Atjauno darījumu vēstures tabulu, kad tiek saņemta atjaunināšanas komanda
window.addEventListener('updateTable', () => {
    window.location.reload();//pārlādē lapu lai nodrošinātu aktuālos datus
    const accountName = sessionStorage.getItem('account_name');
    const profileId = sessionStorage.getItem('profile_id');

    // Ja konta nosaukums un profila ID ir pieejami, iegūst darījumu vēsturi
    if (accountName && profileId) {
        
        fetchTradeHistory(accountName, profileId);
    } else {
        console.error('Account name or profile ID not found.'); // Kļūdas paziņojums
    }
});

//Mainīgie tabulas izskatam un tabulas lapu pāršķiršanai
let currentPage = 1; 
const rowsPerPage = 10; //Maksimālais rindu skaits vienā tabulas lapā
let tradeData = [];

//Funkcija darījumu vēstures tabulas aizpildīšanai
async function fetchTradeHistory(accountName, profileId) {
    try {
   
        //Pieprasījums PHP, lai izgūtu darījumu vēsturi konkŗetajam profilam un kontam
        const response = await fetch(`../php/get_trade_history.php?account_name=${accountName}&profile_id=${profileId}`); 
        if (!response.ok) throw new Error(`HTTP error! Statuss: ${response.status}`); // Kļūdas paziņojums
        tradeData = await response.json();
        setupPagination(tradeData); // Atjauno tabulu ar jaunajiem datiem, piesaista tabulas lapu pāršķiršanas opcijas
    } catch (error) {
        console.error('Error geting trade histoy:', error); // Kļūdas paziņojums
    }
}

//Izveido tabulas struktūru kura tiks aipildīta ar datiem
function displayPage(page) {
    const tableBody = document.getElementById('trade-history-body');
    tableBody.innerHTML = ''; // Notīra esošo tabulas saturu

    //mainīgie lapu paŗškiršanai
    const start = (page - 1) * rowsPerPage;
    const end = start + rowsPerPage;
    const pageData = tradeData.slice(start, end); // Izņem nepieciešamo lapas datus

    // Pievieno iegūtos datus tabulai
    pageData.forEach((trade) => {
        const row = document.createElement('tr');
        row.innerHTML = `
            <td>${trade.coin_name}</td>
            <td style="color: ${trade.direction === 'Long' ? '#1ec124' : '#f9321c'};">${trade.direction}  <!--Ieststa attiecīgu krāsu vai nu zaļu, ja ir Long vai sarkanu ja short -->
            <td>${trade.leverage}X</td>
            <td>${trade.percents}%</td>
            <td>${trade.close_date}</td>
        `;

        // katrai tabulas rindai pievieno dzēšanas pogu ar miskastes ikonu
        const deleteCell = document.createElement('td');
        const deleteButton = document.createElement('button');
        deleteButton.innerHTML = '<i class="fas fa-trash"></i>';
        deleteButton.classList.add('delete-btn');
        //dzēšanas pogas nospiešanas rezultātā tiek izsaukts paziņojums
        deleteButton.addEventListener('click', async (e) => {
            e.stopPropagation();
            if (confirm('Are you sure you want to delete this trade?')) { //paziņojums dzēšanas nepieciešamības pārbaudei
                row.remove(); //noņem rindu no tabulas
                await deleteTrade(trade.trade_id); // Izsauc funkciju, lai dzēstu darījumu
            }
        });

        //funkcionalitāte, lai būtu iespējams nosppiest uz tabulas rindas
        deleteCell.appendChild(deleteButton);
        row.appendChild(deleteCell);

        row.addEventListener('click', () => {
            window.dispatchEvent(new CustomEvent('tradeRowClicked', { detail: trade.trade_id })); //izgūst darījuma ID no konkrētās tabulas rindas
        });

        tableBody.appendChild(row);
    });
}
//funkcija darījuma dzēšanai
async function deleteTrade(tradeId) {
    try {
        //izsauc PHP lai dzēstu konkrēto darījumu datu bāzē
        const response = await fetch(`../php/delete_trade.php`, {
            method: 'POST',
            headers: { 'Content-Type': 'application/json' },
            body: JSON.stringify({ trade_id: tradeId }) 
        });
        //Sagaida dzēšanas rezultātu
        const result = await response.json();
        if (result.success) {
            alert(result.deleted); // Paziņojums par veiksmīgu dzēšanu
            tradeData = tradeData.filter((trade) => trade.trade_id !== tradeId); // Filtrē ārā dzēsto darījumu
            displayPage(currentPage); // Atjauno tabulu bez dzēstā darījuma
            updatePageInfo(); // Atjauno informāciju tabulas lapu pārķiršanai
        } else {
            console.error('Error deleting trade:', result.error); // Izvada kļūdu, ja dzēšana neizdevās
        }
    } catch (error) {
        console.error('Error deleting trade:', error); // Izvada kļūdu, ja pieprasījums neizdodas
    }
}

//funkcija tabulas lapu pāršķiršnas darbībai
function setupPagination() {
    const totalPages = Math.ceil(tradeData.length / rowsPerPage); // Aprēķina kopējo lapu skaitu
    const prevButton = document.getElementById('prev-page');
    const nextButton = document.getElementById('next-page');
    const pageInfo = document.getElementById('page-info');

    // Inicializē lapu datu attēlošanu
    displayPage(currentPage);

    // Atajaunina pāršķiršanas pogas
    updatePageInfo();

    // piefiksē tabulas pašreizējo lapu, atjauno informāciju tabulā, ja šķir uz atpakaļu
    prevButton.addEventListener('click', () => {
        if (currentPage > 1) {
            currentPage--;
            displayPage(currentPage);
            updatePageInfo();
        }
    });
// piefiksē tabulas pašreizējo lapu, atjauno informāciju tabulā, ja šķir uz priekšu
    nextButton.addEventListener('click', () => {
        if (currentPage < totalPages) {
            currentPage++;
            displayPage(currentPage);
            updatePageInfo();
        }
    });
}

// funkcijas, kas nodrošina pašreizējās lapas nummura fiksāciju un pāršķiršanas pogu aktivizēšanau un bloķēšanu, ja tiek sasniegts konkrēts nosacījums
function updatePageInfo() {
    const totalPages = Math.ceil(tradeData.length / rowsPerPage);
    const pageInfo = document.getElementById('page-info');
    pageInfo.textContent = `Page ${currentPage} of ${totalPages}`;

    const prevButton = document.getElementById('prev-page');
    const nextButton = document.getElementById('next-page');
    //bloķē  iepriekšējās lapas pogas darbīnbu, ja tiek attēlota pirmā tabulas lapa
    prevButton.disabled = currentPage === 1;
    //bloķē  nākamās lapas pogas darbību, ja tiek attēlota pēdējā tabulas lapa
    nextButton.disabled = currentPage === totalPages || totalPages === 0;
}

// funkcija izmantoto filtrācijas nosacījumu pielietošanai. nosacījumu nosūtīšanai filtrētas darījumu tabulas izveides funkcijai
function applyFilters(accountName, profileId) {
    const coinName = document.getElementById('coin').value;
    const direction = document.getElementById('direction-filter').value;
    const percentage = document.getElementById('percentage-filter').value;

    fetchFilteredTradeHistory(accountName, profileId, coinName, direction, percentage); // Iegūst tirdzniecību ar filtriem
}

//funkcijas, kas izgūst konkŗetos filytrētos darījumus
async function fetchFilteredTradeHistory(accountName, profileId, coinName, direction, percentage) {
    try {
        const query = new URLSearchParams({
            account_name: accountName,
            profile_id: profileId,
            coin_name: coinName || '',
            direction: direction || '',
            percentage: percentage || ''
        });
        //nosūta pieprasījumu PHP pēc filtrētiem datiem ņemot vērā filtrēšsnas nosacījumus
        const response = await fetch(`../php/get_trade_history.php?${query.toString()}`);
        tradeData = await response.json();
        //ja netiek atrasti filtrēti dati tiek izsaukts paziņojums
        if (tradeData.length === 0) {
            displayNoTradesMessage();
        } else {
            // Nerāda ka nav atrasti darījumi, jaa tie tiek atrasti
            hideNoTradesMessage();
            setupPagination(); // atjauno tabulas lapu pāršķiršanas iespējas balstoties uz jauno filtrēto tabulu
        }
    } catch (error) {
        console.error('Eror geting filtered data:', error); // Kļūdas paziņojums
    }
}

//Funkcija paziņopjumam tabulas vietā, ka nav atrasti filtrēti darījumi
function displayNoTradesMessage() {
    const tableBody = document.getElementById('trade-history-body');
    tableBody.innerHTML = `<tr><td colspan="6" style="text-align: center;">No Trades found!</td></tr>`; //paziņojuma stils
}

//Paslēpj ziņu no tabulas, par netarastiem darījumiem
function hideNoTradesMessage() {
    const tableBody = document.getElementById('trade-history-body');
    tableBody.innerHTML = '';
}
