//Autors: Ralfs Riters; JS datne, kura iegūst un papildina valūtu izvēles sarakstus; 
//Veidots: 2024. gadā, Jaunākā versija

// Funkcija kriptovalūtu un darījuma valūtu izvēlnes lauka aizpildīšanai
function populateDropdown(inputId, items) {
    const input = document.getElementById(inputId); // Iegūst izvēlnes lauku pēc tā ID
    const dropdown = document.getElementById(`${inputId}-list`);

    if (!input || !dropdown) return; // Funkcija nedarbojas ja netiek atrasts izvēlnes elements

    // Notīra iepriekšējo izvēli no izvēlnes ievadlauka
    dropdown.innerHTML = '';

    // Aizpildi pašu izvēlni ar elementiem
    items.forEach(item => {
        const option = document.createElement('div'); // Katram nosaukumam izveido savu div elementu
        option.classList.add('dropdown-item');
        option.textContent = item; 
        dropdown.appendChild(option); // Izveidotos elementu pievieno kā izvēlnes opcijas

        // Funkcija, lai izvēlnes lauks nerādītos ja ir izvēlēta opcija
        option.addEventListener('click', () => {
            input.value = item; // Nodrošina ievadlauka informācijas pieņemšanu no izvēlnes opcijas
            dropdown.classList.add('hidden'); 
        });
    });

    // Parāda izvēlni ar opcijām, kad tiek aktivizēts konkrētais lauks
    input.addEventListener('focus', () => {
        dropdown.classList.remove('hidden');
    });

    input.addEventListener('click', () => {
        dropdown.classList.remove('hidden'); 
    });

    // Filtrē izvēlnes  opcijas, lietotājam rakstot ievades laukā
    input.addEventListener('input', () => {
        const value = input.value.toLowerCase(); // Konvertē ievades vērtību uz mazajiem burtiem
        dropdown.classList.remove('hidden'); // Papildus nodrošinājums, ka pildot ievadlauku tiek paralēli rādīta izvēlne

        // Parāda tās opcijas, kas atbilst jau ievadītajām vērtībām ievadlaukā, opcijas kas neatbilst netiek rādītas izvēlnē
        document.querySelectorAll(`#${inputId}-list .dropdown-item`).forEach(option => {
            option.style.display = option.textContent.toLowerCase().includes(value) ? '' : 'none';
        });
    });

    // Paslēpj izvēlni, ja tiek nospiests ārpus ievades lauka un vai pašas izvēlnes
    document.addEventListener('click', (e) => {
        if (!input.contains(e.target) && !dropdown.contains(e.target)) {
            dropdown.classList.add('hidden'); // Pievieno "hidden" klasi, lai paslēptu dropdown
        }
    });
}

// Funkcija, kuru izsauks lai veiktu valūtu nosaukumu izvēlnes implementēšanu kcitās koda daļās
export function populateDropdowns() {
    // Iegūst lieottāja datus, lai izvēlnē piedāvātu tikai personīgi iepriekš reģistrētus nosaukumus
    const account_name = document.getElementById('account_name').innerText.trim(); // Lietotāja "subkonta" nosaukums
    const profile_id = document.getElementById('profile_id').innerText.trim(); // Lietotāja profila ID

    // Pieprasījums PHP failam lai izgūtu nosaukumus
    fetch(`../php/get_coin_names.php?account_name=${encodeURIComponent(account_name)}&profile_id=${encodeURIComponent(profile_id)}`)
        .then(response => response.json()) // Iegūto atbildi pārveido par JSON
        .then(data => {
            // Aizpilda kriptovalūtas nosaukumu izvēlni
            if (document.getElementById('coin')) {
                populateDropdown('coin', data.coins || []); // Izmanto saņemto nosaukumu sarakstu
            }

            // Aizpilda darījuma valūtas nosaukumu izvēlni
            if (document.getElementById('coinpair')) {
                populateDropdown('coinpair', data.coinpairs || []); // Izmanto saņemto nosaukumu sarakstu
            }
        })
        .catch(error => {
            // Apstrādā kļūdu, ja datu saņemšana neizdodas
            console.error('Error fetching dropdown data:', error);
        });
}
