<?php
// Database connection
include('connection.php');

// Get trade ID from query string
$tradeId = $_GET['trade_id'] ?? '';

if ($tradeId) {
    // Fetch trade details for the given trade ID
    $stmt = $conn->prepare('
        SELECT 
            h.trade_id,
            c.coin_name,
            cp.coinpair_name,
            d.direction,
            h.leverage,
            h.open_price,
            h.close_price,
            h.percents,
            h.close_date,
            h.photo
        FROM rr_410_history_input h
        JOIN rr_410_coin c ON h.coin_id = c.coin_id
        JOIN rr_410_coinpair cp ON h.coinpair_id = cp.coinpair_id
        JOIN rr_410_direction d ON h.direction_id = d.direction_id
        WHERE h.trade_id = ?
    ');
    $stmt->bind_param('i', $tradeId);
    $stmt->execute();
    $result = $stmt->get_result();
    $tradeDetails = $result->fetch_assoc();
    
    if ($tradeDetails) {
        echo json_encode($tradeDetails);  // Return trade details as JSON
    } else {
        echo json_encode(['error' => 'Trade not found']);
    }

    $stmt->close();
} else {
    echo json_encode(['error' => 'No trade ID provided']);
}

$conn->close();
?>
