<?php
// Include database connection
include('connection.php');

// Get raw POST data
$input = json_decode(file_get_contents('php://input'), true);

// Check if trade_id is set
if (isset($input['trade_id'])) {
    $tradeId = $input['trade_id'];

    // Prepare and execute delete statement
    $stmt = $conn->prepare('DELETE FROM rr_410_history_input WHERE trade_id = ?');
    $stmt->bind_param('i', $tradeId);

    if ($stmt->execute()) {
        echo json_encode(['success' => true,'deleted' => 'Trade deleted successfully!']);
    } else {
        echo json_encode(['success' => false, 'error' => 'Failed to delete trade.']);
    }

    $stmt->close();
} else {
    echo json_encode(['success' => false, 'error' => 'No trade ID provided.']);
}

// Close the database connection
$conn->close();
?>
