<?php
// Database connection
include('connection.php');

// Check if the account_name and profile_id are provided
if (isset($_POST['account_name']) && isset($_POST['profile_id'])) {
    $account_name = $conn->real_escape_string($_POST['account_name']);
    $profile_id = $conn->real_escape_string($_POST['profile_id']);

    // Retrieve account_id from rr_410_accounts
    $stmt = $conn->prepare("SELECT account_id FROM rr_410_accounts WHERE account_name = ? AND profile_id = ?");
    $stmt->bind_param('ss', $account_name, $profile_id);
    $stmt->execute();
    $stmt->bind_result($account_id);
    $stmt->fetch();
    $stmt->close();

    if ($account_id) {
        // Delete from rr_410_history_input using account_id
        $stmt = $conn->prepare("DELETE FROM rr_410_history_input WHERE account_id = ?");
        $stmt->bind_param('i', $account_id);
        $stmt->execute();
        $stmt->close();

        // Delete the account itself
        $stmt = $conn->prepare("DELETE FROM rr_410_accounts WHERE account_id = ?");
        $stmt->bind_param('i', $account_id);
        $stmt->execute();
        $stmt->close();

        echo json_encode(["success" => "Account and history deleted successfully!"]);
    } else {
        echo json_encode(["error" => "Account not found"]);
    }

    $conn->close();
} else {
    echo json_encode(["error" => "Invalid input"]);
}
