document.addEventListener('DOMContentLoaded', function () {
    const form = document.getElementById('loginForm'); // Get the login form
    const passwordInput = document.getElementById('password'); // Get the password input field
    const confirmPasswordInput = document.getElementById('confirmPassword'); // Get the confirm password input field
    const errorMessage = document.getElementById('error-message'); // Get the error message element
    const requirementsDiv = document.getElementById('password-requirements'); // Get the password requirements element

    requirementsDiv.style.display = 'block'; // Initially show the password requirements

    const validateInputs = () => {
        const password = passwordInput.value;
        const confirmPassword = confirmPasswordInput.value;

        // Password requirements checks
        const lengthRequirement = password.length >= 8;
        const capitalRequirement = /[A-Z]/.test(password);
        const numberRequirement = /\d/.test(password);
        const passwordsMatch = password === confirmPassword;

        // Update the visual indicators for requirements
        document.getElementById('length-requirement').style.color = lengthRequirement ? 'green' : 'red';
        document.getElementById('capital-requirement').style.color = capitalRequirement ? 'green' : 'red';
        document.getElementById('number-requirement').style.color = numberRequirement ? 'green' : 'red';

        // Display the requirements if not all are met
        if (lengthRequirement && capitalRequirement && numberRequirement) {
            requirementsDiv.style.display = 'none';
        } else {
            requirementsDiv.style.display = 'block';
        }

        // Handle password match validation
        if (!passwordsMatch) {
            errorMessage.innerText = 'Passwords do not match!';
            errorMessage.style.display = 'block';
        } else {
            errorMessage.style.display = 'none';
        }

        // Return the validation status
        return lengthRequirement && capitalRequirement && numberRequirement && passwordsMatch;
    };

    form.addEventListener('submit', function (event) {
        if (!validateInputs()) {
            // Prevent submission if validation fails
            event.preventDefault();
        }
    });

    // Validate password input live
    passwordInput.addEventListener('input', validateInputs);

    // Validate confirm password input live
    confirmPasswordInput.addEventListener('input', validateInputs);
});
