document.addEventListener('DOMContentLoaded', function () {
  const form = document.getElementById('loginForm');
  const passwordInput = document.getElementById('password');
  const confirmPasswordInput = document.getElementById('confirmPassword');
  const errorMessage = document.getElementById('error-message');
  const requirementsDiv = document.getElementById('password-requirements');
  
  // Initial state of password requirements
  requirementsDiv.style.display = 'block'; // Show requirements initially

  form.addEventListener('submit', function (event) {
      const password = passwordInput.value;
      const confirmPassword = confirmPasswordInput.value;

      // Validate passwords match
      if (password !== confirmPassword) {
          errorMessage.innerText = 'Passwords do not match!';
          errorMessage.style.display = 'block'; // Show error message
          event.preventDefault(); // Prevent form submission
          return;
      } else {
          errorMessage.style.display = 'none'; // Hide error message if they match
      }
  });

  // Validate password as the user types
  passwordInput.addEventListener('input', function () {
      const password = passwordInput.value;
      
      // Password criteria checks
      const lengthRequirement = password.length >= 8;
      const capitalRequirement = /[A-Z]/.test(password);
      const numberRequirement = /\d/.test(password);

      // Update requirement display
      document.getElementById('length-requirement').style.color = lengthRequirement ? 'green' : 'red';
      document.getElementById('capital-requirement').style.color = capitalRequirement ? 'green' : 'red';
      document.getElementById('number-requirement').style.color = numberRequirement ? 'green' : 'red';

      // Hide requirements if all criteria are met
      if (lengthRequirement && capitalRequirement && numberRequirement) {
          requirementsDiv.style.display = 'none'; // Hide requirements if met
      } else {
          requirementsDiv.style.display = 'block'; // Show requirements if not met
      }

      // Check for matching passwords
      const confirmPassword = confirmPasswordInput.value;
      if (password !== confirmPassword) {
          errorMessage.innerText = 'Passwords do not match!';
          errorMessage.style.display = 'block'; // Show error message
      } else {
          errorMessage.style.display = 'none'; // Hide error if they match
      }
  });

  // Check password confirmation as user types
  confirmPasswordInput.addEventListener('input', function () {
      const password = passwordInput.value;
      const confirmPassword = confirmPasswordInput.value;

      if (password !== confirmPassword) {
          errorMessage.innerText = 'Passwords do not match!';
          errorMessage.style.display = 'block'; // Show error message
      } else {
          errorMessage.style.display = 'none'; // Hide error if they match
      }
  });
});
