// Fetch query parameters (email, profile_id, and account_name) from the URL
const params = new URLSearchParams(window.location.search);
const email = params.get('email');
const profileId = params.get('profile_id');
const accountName = params.get('account_name');

// Display the values on the page
document.getElementById('email').textContent = email;
document.getElementById('profile_id').textContent = profileId;
document.getElementById('account_name').textContent = accountName;

// Back button functionality
document.getElementById('back-button').addEventListener('click', function() {
    window.history.back(); // Go back to the previous page
});

// JavaScript to handle modal popup and form loading
const modal = document.getElementById('tradeModal');
const openButton = document.getElementById('open-form-button');
const closeButton = document.getElementById('close-modal');
const formContainer = document.getElementById('form-container');

// Function to load the trade form
function loadTradeForm() {
    fetch('../html/register_trade.html')  // Path to the trade form HTML file
        .then(response => response.text())
        .then(html => {
            formContainer.innerHTML = html; // Insert the form HTML into the modal
            modal.style.display = 'block';  // Display the modal

            // Attach event listeners after loading the form
            document.getElementById('close-form-button').addEventListener('click', function() {
                modal.style.display = 'none';  // Hide the modal when "Close" is clicked
            });

            // Handle form submission using AJAX
            document.getElementById('submit-button').addEventListener('click', function() {
                var coin = document.getElementById('coin').value;
                var coinpair = document.getElementById('coinpair').value;
                var direction = document.getElementById('direction').value;
                var open_price = document.getElementById('open_price').value;
                var close_price = document.getElementById('close_price').value;
                var leverage = document.getElementById('leverage').value;
                var close_date = document.getElementById('close_date').value;
                var photo = document.getElementById('photo').files[0];
                var account_name = document.getElementById('account_name').innerText;

                var formData = new FormData();
                formData.append('coin', coin);
                formData.append('coinpair', coinpair);
                formData.append('direction', direction);
                formData.append('open_price', open_price);
                formData.append('close_price', close_price);
                formData.append('leverage', leverage);
                formData.append('close_date', close_date);
                formData.append('photo', photo);
                formData.append('account_name', account_name);

                // AJAX request to send the form data to the PHP file
                fetch('../php/register_trade.php', {
                    method: 'POST',
                    body: formData
                })
                .then(response => {
                    if (!response.ok) {
                        throw new Error('Network response was not ok ' + response.statusText);
                    }
                    return response.json();
                })
                .then(data => {
                    if (data.success) {
                        alert("Trade data successfully submitted.");
                    } else {
                        alert("Error: " + data.message);
                    }
                })
                .catch(error => {
                    console.error('There was a problem with the fetch operation:', error);
                    alert('Error: ' + error.message);
                });
            });
        })
        .catch(error => console.log('Error loading trade form:', error));
}

// Open modal when button is clicked
openButton.addEventListener('click', loadTradeForm);

// Close modal when clicking the close button or outside the modal
closeButton.addEventListener('click', function() {
    modal.style.display = 'none';
});

window.onclick = function(event) {
    if (event.target === modal) {
        modal.style.display = 'none';
    }
};
