<?php
include("includes/includedFiles.php"); 

if(isset($_GET['term'])) {
    $term = urldecode($_GET['term']);
} else {
    $term = "";
}

$artistQuery = mysqli_query($con, "SELECT * FROM artists WHERE name LIKE '$term%' LIMIT 10");

if(mysqli_num_rows($artistQuery) == 0) {
    $albumQuery = mysqli_query($con, "SELECT * FROM albums WHERE title LIKE '$term%' LIMIT 10");
    if(mysqli_num_rows($albumQuery) == 0) {
        $songQuery = mysqli_query($con, "SELECT * FROM songs WHERE title LIKE '$term%' OR artist LIKE '$term%' LIMIT 10");
    }
}
?>

<div class="searchContainer">
    <h4>Search for an artist, album or song</h4>
    <input type="text" class="searchInput" value="<?php echo $term; ?>" onfocus="this.value = this.value;" onblur="if(this.value == '') {this.value = '<?php echo $term; ?>';}" placeholder="artist, album or song....">
</div>

<script >
$(".searchInput").focus(function() {
    $(this).val("");
});

$(function() {
    $(".searchInput").keyup(function() {
        clearTimeout(timer);
        timer = setTimeout(function() {
            var val = $(".searchInput").val();
            openPage("search.php?term=" + val);
        }, 2000);
    });
});

</script>

<?php  
 if ($term == "") exit();
?>


<div class="trackListContainer borderBottom">
    <ul class="trackList">

    <h2>Songs</h2>

        <?php

        $songsQuery = mysqli_query($con, "SELECT id FROM songs WHERE title LIKE '$term%' OR artist LIKE '$term%' ORDER BY plays DESC LIMIT 10");

        if(mysqli_num_rows($songsQuery) == 0) {
            echo "<span class='noResults'>No results found for " . $term . "</span>";
        }

            $songIdArray = array();
            $i = 1;
            while($row = mysqli_fetch_array($songsQuery)) {
                array_push($songIdArray, $row['id']);

                if($i > 10) {
                    break;
                }

                $albumSong = new Song($con, $row['id']);
                $albumArtist = $albumSong->getArtist();

                echo "<li class='trackListRow'>
                        <div class='trackCount'>
                            <img class='play' src='assets/images/icons/play-white.png' onclick ='setTrack(\"". $albumSong->getId() . "\", tempPlaylist, setTimeout(playSong, 100))'>
                            <span class='trackNumber'>$i</span>
                        </div>

                        <div class='trackInfo'>
                            <span class='trackName'>" . $albumSong->getTitle() . "</span>
                            <span class='artistName'>" . $albumArtist->getName() . "</span>
                        </div>

                        <div class='trackOptions'>
                            <img class='optionsButton' src='assets/images/icons/more.png'> 
                        </div>

                        <div class='trackDuration'>
                            <span class='duration'>" . $albumSong->getDuration() . "</span>
                        </div>
                    </li>";
                $i++;
            }
        ?>

        <script>
            var tempSongIds = '<?php echo json_encode($songIdArray); ?>';
            tempPlaylist = JSON.parse(tempSongIds);
        </script>



    </ul>
</div>


<div class="artistContainer borderBottom"> <h2>Artists</h2>

<?php

$artistQuery = mysqli_query($con, "SELECT id FROM artists WHERE name LIKE '$term%' LIMIT 10");

if(mysqli_num_rows($artistQuery) == 0) {
    echo "<span class='noResults'>No results found for " . $term . "</span>";
}

while($row = mysqli_fetch_array($artistQuery)) {

    $artist = new Artist($con, $row['id']);
    echo "<div class='searchResultRow'>
            <div class='artistName'>
                <span role='link' tabindex='0' onclick='openPage(\"artist.php?id=" . $artist->getId() . "\")'>
                    " . $artist->getName() . "
                </span>
            </div>
        </div>";
}

?>

</div>

<div class="gridViewContainer borderBottom">

    <h2>Albums</h2>

    <?php 
        $albumQuery = mysqli_query($con, "SELECT * FROM albums WHERE title LIKE '$term%' LIMIT 10");

        if(mysqli_num_rows($albumQuery) == 0) {
            echo "<span class='noResults'>No results found for " . $term . "</span>";
        }

        while($row = mysqli_fetch_array($albumQuery)) {
            echo "<div class='gridViewItem'>
                    <span role='link' tabindex='0' onclick='openPage(\"album.php?id=" . $row['id'] . "\")' >
                        <img src='" . $row['artworkPath'] . "'>
                        <div class='gridViewInfo'>"
                            . $row['title'] .
                        "</div>
                    </span>
                </div>";
        }
    ?>
</div>